/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo.support;

import com.github._1c_syntax.utils.GenericInterner;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class MultiLanguageString
implements Comparable<MultiLanguageString> {
    public static final MultiLanguageString EMPTY = new MultiLanguageString();
    private static final GenericInterner<MultiLanguageString> interner = new GenericInterner();
    private final Set<Entry> content;

    private MultiLanguageString() {
        this.content = Collections.emptySet();
    }

    private MultiLanguageString(@NonNull String langKey, @NonNull String value) {
        this(Set.of(Entry.create(langKey, value)));
        if (langKey == null) {
            throw new NullPointerException("langKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    private MultiLanguageString(@NonNull MultiLanguageString first, @NonNull MultiLanguageString second) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        HashSet<Entry> fullContent = new HashSet<Entry>(first.getContent());
        fullContent.addAll(second.getContent());
        this.content = Collections.unmodifiableSet(fullContent);
    }

    private MultiLanguageString(Set<Entry> content) {
        this.content = Collections.unmodifiableSet(content);
    }

    public static MultiLanguageString create(@NonNull List<MultiLanguageString> strings) {
        if (strings == null) {
            throw new NullPointerException("strings is marked non-null but is null");
        }
        if (strings.isEmpty()) {
            return EMPTY;
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        HashSet<Entry> content = new HashSet<Entry>();
        strings.forEach(string -> content.addAll(string.getContent()));
        return new MultiLanguageString(content).intern();
    }

    public static MultiLanguageString create(@NonNull Set<Entry> langContent) {
        if (langContent == null) {
            throw new NullPointerException("langContent is marked non-null but is null");
        }
        return new MultiLanguageString(langContent).intern();
    }

    public static MultiLanguageString create(@NonNull MultiLanguageString first, @NonNull MultiLanguageString second) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        return new MultiLanguageString(first, second).intern();
    }

    public static MultiLanguageString create(@NonNull String langKey, @NonNull String value) {
        if (langKey == null) {
            throw new NullPointerException("langKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MultiLanguageString(langKey, value).intern();
    }

    @NonNull
    public String get(@NonNull String lang) {
        if (lang == null) {
            throw new NullPointerException("lang is marked non-null but is null");
        }
        return this.content.stream().filter(entry -> entry.getLangKey().equals(lang)).map(Entry::getValue).findFirst().orElse("");
    }

    @NonNull
    public String getAny() {
        if (this.content.isEmpty()) {
            return "";
        }
        return this.content.iterator().next().getValue();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public int compareTo(@Nullable MultiLanguageString multiLanguageString) {
        if (multiLanguageString == null) {
            return 1;
        }
        if (this.equals(multiLanguageString)) {
            return 0;
        }
        int compareResult = this.content.size() - multiLanguageString.content.size();
        if (compareResult != 0) {
            return compareResult;
        }
        HashSet<Entry> left = new HashSet<Entry>(this.content);
        HashSet<Entry> right = new HashSet<Entry>(multiLanguageString.content);
        left.removeAll(right);
        right.removeAll(left);
        if (left.isEmpty() && right.isEmpty()) {
            return 0;
        }
        if (left.isEmpty()) {
            return -1;
        }
        if (right.isEmpty()) {
            return 1;
        }
        Entry leftOne = left.iterator().next();
        Entry rightOne = right.iterator().next();
        return leftOne.compareTo(rightOne);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "empty";
        }
        return this.content.stream().map(entry -> entry.langKey + ": " + entry.value).collect(Collectors.joining(", "));
    }

    private MultiLanguageString intern() {
        return (MultiLanguageString)interner.intern((Object)this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<Entry> getContent() {
        return this.content;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiLanguageString)) {
            return false;
        }
        MultiLanguageString other = (MultiLanguageString)o;
        Set<Entry> this$content = this.getContent();
        Set<Entry> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Entry> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public static final class Entry
    implements Comparable<Entry> {
        private static final StringInterner stringInterner = new StringInterner();
        private static final GenericInterner<Entry> interner = new GenericInterner();
        private final String langKey;
        private final String value;

        private Entry(String langKey, String value) {
            this.langKey = stringInterner.intern(langKey);
            this.value = value;
        }

        public static Entry create(String langKey, String value) {
            return new Entry(langKey, value).intern();
        }

        @Override
        public int compareTo(@Nullable Entry entry) {
            if (entry == null) {
                return 1;
            }
            if (this.equals(entry)) {
                return 0;
            }
            int compareResult = this.langKey.compareTo(entry.langKey);
            if (compareResult != 0) {
                return compareResult;
            }
            return this.value.compareTo(entry.value);
        }

        private Entry intern() {
            return (Entry)interner.intern((Object)this);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getLangKey() {
            return this.langKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            String this$langKey = this.getLangKey();
            String other$langKey = other.getLangKey();
            if (this$langKey == null ? other$langKey != null : !this$langKey.equals(other$langKey)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $langKey = this.getLangKey();
            result = result * 59 + ($langKey == null ? 43 : $langKey.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

