/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo.support;

import com.github._1c_syntax.bsl.mdo.support.EnumWithValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ScriptVariant implements EnumWithValue
{
    ENGLISH("English", "\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439", "en"),
    RUSSIAN("Russian", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "ru"),
    UNKNOWN("unknown", "unknown", "--"){

        @Override
        public boolean isUnknown() {
            return true;
        }
    };

    private static final Map<String, ScriptVariant> keys;
    private final String value;
    private final String valueRu;
    private final String shortName;

    public static ScriptVariant valueByString(String string) {
        return keys.getOrDefault(string, RUSSIAN);
    }

    private static Map<String, ScriptVariant> computeKeys() {
        ConcurrentSkipListMap<String, ScriptVariant> keysMap = new ConcurrentSkipListMap<String, ScriptVariant>(String.CASE_INSENSITIVE_ORDER);
        for (ScriptVariant element : ScriptVariant.values()) {
            if (element.isUnknown()) continue;
            keysMap.put(element.value(), element);
            keysMap.put(element.valueRu(), element);
            keysMap.put(element.shortName(), element);
        }
        return keysMap;
    }

    @ConstructorProperties(value={"value", "valueRu", "shortName"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ScriptVariant(String value, String valueRu, String shortName) {
        this.value = value;
        this.valueRu = valueRu;
        this.shortName = shortName;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String value() {
        return this.value;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String valueRu() {
        return this.valueRu;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String shortName() {
        return this.shortName;
    }

    static {
        keys = ScriptVariant.computeKeys();
    }
}

