/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo.utils;

import com.github._1c_syntax.bsl.mdclasses.ConfigurationTree;
import com.github._1c_syntax.bsl.mdo.Attribute;
import com.github._1c_syntax.bsl.mdo.AttributeOwner;
import com.github._1c_syntax.bsl.mdo.CalculationRegister;
import com.github._1c_syntax.bsl.mdo.ChartOfAccounts;
import com.github._1c_syntax.bsl.mdo.ChildrenOwner;
import com.github._1c_syntax.bsl.mdo.CommandOwner;
import com.github._1c_syntax.bsl.mdo.CommonModule;
import com.github._1c_syntax.bsl.mdo.Enum;
import com.github._1c_syntax.bsl.mdo.FormOwner;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.Module;
import com.github._1c_syntax.bsl.mdo.ModuleOwner;
import com.github._1c_syntax.bsl.mdo.Register;
import com.github._1c_syntax.bsl.mdo.TabularSectionOwner;
import com.github._1c_syntax.bsl.mdo.Task;
import com.github._1c_syntax.bsl.mdo.TemplateOwner;
import com.github._1c_syntax.bsl.mdo.storage.ManagedFormData;
import com.github._1c_syntax.bsl.mdo.storage.form.FormItem;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.github._1c_syntax.bsl.types.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public final class LazyLoader {
    public static List<MD> computeChildren(ChildrenOwner mdo) {
        List<Object> children = Collections.emptyList();
        if (mdo instanceof AttributeOwner) {
            AttributeOwner attributeOwner = (AttributeOwner)mdo;
            children = LazyLoader.addAll(children, attributeOwner.getAllAttributes());
        }
        if (mdo instanceof TabularSectionOwner) {
            TabularSectionOwner tabularSectionOwner = (TabularSectionOwner)mdo;
            children = LazyLoader.addAll(children, tabularSectionOwner.getTabularSections());
        }
        if (mdo instanceof CommandOwner) {
            CommandOwner commandOwner = (CommandOwner)mdo;
            children = LazyLoader.addAll(children, commandOwner.getCommands());
        }
        if (mdo instanceof TemplateOwner) {
            TemplateOwner templateOwner = (TemplateOwner)mdo;
            children = LazyLoader.addAll(children, templateOwner.getTemplates());
        }
        if (mdo instanceof FormOwner) {
            FormOwner formOwner = (FormOwner)mdo;
            children = LazyLoader.addAll(children, formOwner.getForms());
        }
        if (mdo instanceof Enum) {
            Enum anEnum = (Enum)mdo;
            children = LazyLoader.addAll(children, anEnum.getEnumValues());
        }
        if (mdo instanceof Task) {
            Task task = (Task)mdo;
            children = LazyLoader.addAll(children, task.getAddressingAttributes());
        }
        if (mdo instanceof CalculationRegister) {
            CalculationRegister calculationRegister = (CalculationRegister)mdo;
            children = LazyLoader.addAll(children, calculationRegister.getRecalculations());
        }
        return Collections.unmodifiableList(children);
    }

    public static List<MD> computePlainChildren(ChildrenOwner mdo) {
        List<MD> children = LazyLoader.addAll(Collections.emptyList(), mdo.getChildren());
        children = LazyLoader.addAll(children, children.stream().filter(ChildrenOwner.class::isInstance).map(ChildrenOwner.class::cast).map(ChildrenOwner::getPlainChildren).flatMap(Collection::stream).toList());
        return Collections.unmodifiableList(children);
    }

    public static List<MD> computeStorageFields(ChildrenOwner mdo) {
        List<Object> children = Collections.emptyList();
        if (mdo instanceof AttributeOwner) {
            AttributeOwner attributeOwner = (AttributeOwner)mdo;
            children = LazyLoader.addAll(children, attributeOwner.getAllAttributes());
        }
        if (mdo instanceof TabularSectionOwner) {
            TabularSectionOwner tabularSectionOwner = (TabularSectionOwner)mdo;
            children = LazyLoader.addAll(children, tabularSectionOwner.getTabularSections());
        }
        return Collections.unmodifiableList(children);
    }

    public static List<MD> computePlainStorageFields(AttributeOwner mdo) {
        List<MD> children = LazyLoader.addAll(Collections.emptyList(), mdo.getStorageFields());
        children = LazyLoader.addAll(children, children.stream().filter(AttributeOwner.class::isInstance).map(AttributeOwner.class::cast).map(AttributeOwner::getPlainStorageFields).flatMap(Collection::stream).toList());
        return Collections.unmodifiableList(children);
    }

    public static List<Attribute> computeAllAttributes(AttributeOwner mdo) {
        List<Object> children = Collections.emptyList();
        if (mdo instanceof Register) {
            Register register = (Register)mdo;
            children = LazyLoader.addAll(children, register.getAttributes());
            children = LazyLoader.addAll(children, register.getResources());
            children = LazyLoader.addAll(children, register.getDimensions());
        }
        if (mdo instanceof ChartOfAccounts) {
            ChartOfAccounts chartOfAccounts = (ChartOfAccounts)mdo;
            children = LazyLoader.addAll(children, chartOfAccounts.getAttributes());
            children = LazyLoader.addAll(children, chartOfAccounts.getAccountingFlags());
            children = LazyLoader.addAll(children, chartOfAccounts.getExtDimensionAccountingFlags());
        }
        return Collections.unmodifiableList(children);
    }

    public static List<Module> computeAllModules(ModuleOwner mdo) {
        ArrayList<Module> modules = new ArrayList<Module>(mdo.getModules());
        if (mdo instanceof ChildrenOwner) {
            ChildrenOwner childrenOwner = (ChildrenOwner)((Object)mdo);
            modules.addAll(childrenOwner.getPlainChildren().stream().filter(ModuleOwner.class::isInstance).map(ModuleOwner.class::cast).map(ModuleOwner::getModules).flatMap(Collection::stream).toList());
        }
        return Collections.unmodifiableList(modules);
    }

    public static Map<URI, ModuleType> computeModulesByType(ModuleOwner mdo) {
        return mdo.getAllModules().stream().collect(Collectors.toUnmodifiableMap(Module::getUri, Module::getModuleType));
    }

    public static Map<URI, MD> computeModulesByObject(ChildrenOwner mdo) {
        HashMap result = new HashMap();
        mdo.getPlainChildren().stream().filter(ModuleOwner.class::isInstance).map(ModuleOwner.class::cast).forEach(moduleOwner -> moduleOwner.getModules().forEach(module -> result.put(module.getUri(), moduleOwner)));
        if (mdo instanceof ModuleOwner) {
            ModuleOwner moduleOwner2 = (ModuleOwner)((Object)mdo);
            moduleOwner2.getModules().forEach(module -> result.put(module.getUri(), moduleOwner2));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<MdoReference, MD> computeChildrenByMdoRef(ChildrenOwner childrenOwner) {
        return childrenOwner.getPlainChildren().stream().collect(Collectors.toUnmodifiableMap(MD::getMdoReference, child -> child));
    }

    public static Map<URI, Module> computeModulesByURI(ModuleOwner mdo) {
        return mdo.getAllModules().stream().collect(Collectors.toUnmodifiableMap(Module::getUri, module -> module));
    }

    public static List<FormItem> computePlainFormItems(FormItem formItem) {
        List<FormItem> items = LazyLoader.addAll(Collections.emptyList(), formItem.getItems());
        items = LazyLoader.addAll(items, items.stream().map(FormItem::getPlainItems).flatMap(Collection::stream).toList());
        return Collections.unmodifiableList(items);
    }

    public static List<FormItem> computePlainFormItems(ManagedFormData formData) {
        List<FormItem> items = LazyLoader.addAll(Collections.emptyList(), formData.getItems());
        items = LazyLoader.addAll(items, items.stream().map(FormItem::getPlainItems).flatMap(Collection::stream).toList());
        return Collections.unmodifiableList(items);
    }

    public static Map<String, CommonModule> computeCommonModulesByName(ConfigurationTree cf) {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        cf.getCommonModules().forEach(arg_0 -> LazyLoader.lambda$computeCommonModulesByName$5((Map)result, arg_0));
        return Collections.unmodifiableMap(result);
    }

    private static <T> List<T> addAll(List<T> result, List<? extends T> source) {
        if (result.isEmpty()) {
            return Collections.unmodifiableList(source);
        }
        if (source.isEmpty()) {
            return result;
        }
        if ("UnmodifiableRandomAccessList".equals(result.getClass().getSimpleName())) {
            ArrayList<T> newList = new ArrayList<T>(result);
            newList.addAll(source);
            return newList;
        }
        result.addAll(source);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private LazyLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$computeCommonModulesByName$5(Map result, CommonModule commonModule) {
        result.put(commonModule.getName(), commonModule);
    }
}

