/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformationUtils {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformationUtils.class);
    private static final Map<String, Map<String, Optional<Method>>> METHODS = new ConcurrentHashMap<String, Map<String, Optional<Method>>>();
    private static final Map<String, Map<String, Optional<Type>>> TYPES = new ConcurrentHashMap<String, Map<String, Optional<Type>>>();
    private static final String BUILD_METHOD_NAME = "build";
    private static final String BUILDER_METHOD_NAME = "builder";
    private static final String LOGGER_MESSAGE_PREF = "Class {}, method {}";

    public static void setValue(@NonNull Object source, @NonNull String methodName, Object value) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        Method method = TransformationUtils.getMethod(source.getClass(), methodName);
        if (method != null && value != null) {
            try {
                Type parameterType = method.getGenericParameterTypes()[0];
                if (parameterType instanceof ParameterizedType && !(value instanceof List)) {
                    Method singular = TransformationUtils.getMethod(source.getClass(), "add" + methodName);
                    Objects.requireNonNullElse(singular, method).invoke(source, value);
                } else {
                    method.invoke(source, value);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.error(LOGGER_MESSAGE_PREF, new Object[]{source.getClass(), methodName, e});
            }
        }
    }

    @Nullable
    public static Type fieldType(Object source, String methodName) {
        return TYPES.computeIfAbsent(source.getClass().getName(), k -> new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER)).computeIfAbsent(methodName, l -> TransformationUtils.computeFieldType(source, methodName)).orElse(null);
    }

    @Nullable
    public static Object builder(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Method method = TransformationUtils.getMethod(clazz, BUILDER_METHOD_NAME);
        if (method != null) {
            try {
                return method.invoke(clazz, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.error(LOGGER_MESSAGE_PREF, new Object[]{clazz, BUILDER_METHOD_NAME, e});
            }
        }
        return null;
    }

    @Nullable
    public static Object build(@NonNull Object builder, @NonNull Path path) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Method method = TransformationUtils.getMethod(builder.getClass(), BUILD_METHOD_NAME);
        if (method != null) {
            try {
                return method.invoke(builder, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("File {}, Class {}, method {}", new Object[]{path, builder.getClass(), BUILD_METHOD_NAME, e});
            }
        }
        return null;
    }

    @Nullable
    private static Method getMethod(@NonNull Class<?> clazz, @NonNull String methodName) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        return METHODS.computeIfAbsent(clazz.getName(), k -> new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER)).computeIfAbsent(methodName, k -> Arrays.stream(clazz.getDeclaredMethods()).filter(m -> methodName.equalsIgnoreCase(m.getName())).findFirst()).orElse(null);
    }

    private static Optional<Type> computeFieldType(Object source, String methodName) {
        Method method = TransformationUtils.getMethod(source.getClass(), methodName);
        if (method != null) {
            Type fieldClass = method.getGenericParameterTypes()[0];
            if (fieldClass instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)fieldClass;
                Type type = parameterizedType.getActualTypeArguments()[0];
                if (type instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)type;
                    fieldClass = wildcardType.getUpperBounds()[0];
                } else {
                    fieldClass = type;
                }
            }
            return Optional.of(fieldClass);
        }
        return Optional.empty();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private TransformationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

