/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.context;

import com.github._1c_syntax.bsl.mdo.Module;
import com.github._1c_syntax.bsl.mdo.children.ObjectModule;
import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.common.TransformationUtils;
import com.github._1c_syntax.bsl.reader.common.converter.ProtectedModuleInfo;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.support.SupportVariant;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public abstract class AbstractReaderContext {
    protected static final String MODULES_FIELD_NAME = "modules";
    protected final Path currentPath;
    protected final MDReader mdReader;
    protected Class<?> realClass;
    protected Object builder;
    protected SupportVariant supportVariant;
    protected MDOType mdoType;
    protected MdoReference mdoReference = MdoReference.EMPTY;
    protected String name;
    private String lastName;
    private Object lastValue;

    protected AbstractReaderContext(@NonNull HierarchicalStreamReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        this.currentPath = ExtendXStream.getCurrentPath(reader);
        this.mdReader = ExtendXStream.getCurrentMDReader(reader);
    }

    public void setValue(String methodName, Object value) {
        TransformationUtils.setValue(this.builder, methodName, value);
    }

    public Class<?> fieldType(String fieldName) {
        return (Class)TransformationUtils.fieldType(this.builder, fieldName);
    }

    public Object build() {
        return TransformationUtils.build(this.builder, this.currentPath);
    }

    protected void setValueModules() {
        List<Module> modules = this.readModules();
        if (!modules.isEmpty()) {
            this.setValue(MODULES_FIELD_NAME, modules);
        }
    }

    private List<Module> readModules() {
        Path folder = this.mdReader.moduleFolder(this.currentPath, this.mdoType);
        if (!folder.toFile().exists()) {
            return Collections.emptyList();
        }
        Set moduleTypes = ModuleType.byMDOType((MDOType)this.mdoType);
        if (moduleTypes.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isDesigner = this.mdReader.getConfigurationSource() == ConfigurationSource.DESIGNER;
        ArrayList<Module> modules = new ArrayList<Module>();
        moduleTypes.forEach(moduleType -> {
            ProtectedModuleInfo protectedModuleInfo = new ProtectedModuleInfo(this.mdReader.modulePath(folder, this.name, (ModuleType)moduleType), isDesigner);
            if (protectedModuleInfo.isExist()) {
                modules.add(ObjectModule.builder().moduleType((ModuleType)moduleType).uri(protectedModuleInfo.getModulePath().toUri()).owner(this.mdoReference).supportVariant(this.supportVariant).isProtected(protectedModuleInfo.isProtected()).build());
            }
        });
        return modules;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getCurrentPath() {
        return this.currentPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MDReader getMdReader() {
        return this.mdReader;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Class<?> getRealClass() {
        return this.realClass;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object getBuilder() {
        return this.builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MDOType getMdoType() {
        return this.mdoType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setLastValue(Object lastValue) {
        this.lastValue = lastValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object getLastValue() {
        return this.lastValue;
    }
}

