/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.CommonAttribute;
import com.github._1c_syntax.bsl.mdo.support.UseMode;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.ArrayList;

@CommonConverter
public class CommonAttributeUseContentConverter
implements ReadConverter {
    private static final String METADATA_NODE_NAME = "Metadata";
    private static final String USE_NODE_NAME = "Use";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (ExtendXStream.getCurrentMDReader(reader).getConfigurationSource() == ConfigurationSource.DESIGNER) {
            ArrayList<CommonAttribute.UseContent> contents = new ArrayList<CommonAttribute.UseContent>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                contents.add(CommonAttributeUseContentConverter.commonAttributeUseContent(reader, context));
                reader.moveUp();
            }
            return contents;
        }
        return CommonAttributeUseContentConverter.commonAttributeUseContent(reader, context);
    }

    public boolean canConvert(Class type) {
        return CommonAttribute.UseContent.class.isAssignableFrom(type);
    }

    private static CommonAttribute.UseContent commonAttributeUseContent(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (!reader.hasMoreChildren()) {
            return null;
        }
        CommonAttribute.UseContent.UseContentBuilder builder = CommonAttribute.UseContent.builder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String node = reader.getNodeName();
            if (METADATA_NODE_NAME.equalsIgnoreCase(node)) {
                builder.metadata(MdoReference.create((String)reader.getValue()));
            } else if (USE_NODE_NAME.equalsIgnoreCase(node)) {
                builder.use(ExtendXStream.readValue(context, UseMode.class));
            }
            reader.moveUp();
        }
        return builder.build();
    }
}

