/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.CommonModule;
import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.common.context.MDReaderContext;
import com.github._1c_syntax.bsl.reader.common.converter.AbstractReadConverter;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.converter.ProtectedModuleInfo;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.file.Path;

@CommonConverter
public class CommonModuleConverter
extends AbstractReadConverter {
    private static final String URI_FIELD_NAME = "uri";
    private static final String IS_PROTECTED_FIELD_NAME = "isProtected";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        MDReaderContext readerContext = super.read(reader, context);
        MDReader mdReader = ExtendXStream.getCurrentMDReader(reader);
        Path moduleFolder = mdReader.moduleFolder(readerContext.getCurrentPath(), MDOType.COMMON_MODULE);
        Path modulePath = mdReader.modulePath(moduleFolder, readerContext.getName(), ModuleType.CommonModule);
        ProtectedModuleInfo protectedModuleInfo = new ProtectedModuleInfo(modulePath, mdReader.getConfigurationSource() == ConfigurationSource.DESIGNER);
        readerContext.setValue(URI_FIELD_NAME, protectedModuleInfo.getModulePath().toUri());
        readerContext.setValue(IS_PROTECTED_FIELD_NAME, protectedModuleInfo.isProtected());
        return readerContext.build();
    }

    public boolean canConvert(Class type) {
        return CommonModule.class.isAssignableFrom(type);
    }
}

