/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.storage.DataCompositionSchema;
import com.github._1c_syntax.bsl.mdo.storage.QuerySource;
import com.github._1c_syntax.bsl.mdo.support.DataSetType;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

@CommonConverter
public class DataSetConverter
implements ReadConverter {
    private static final String NAME_NODE_NAME = "name";
    private static final String FIELD_NODE_NAME = "field";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String DATA_SOURCE_NODE_NAME = "dataSource";
    private static final String QUERY_SOURCE_NODE_NAME = "query";
    private static final String ITEM_SOURCE_NODE_NAME = "item";
    private static final String DATA_PATH_NODE_NAME = "dataPath";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DataCompositionSchema.DataSet.DataSetBuilder dataSet = DataCompositionSchema.DataSet.builder();
        dataSet.type(DataSetType.fromString(reader.getAttribute(TYPE_ATTRIBUTE_NAME)));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "name": {
                    dataSet.name(reader.getValue());
                    break;
                }
                case "dataSource": {
                    dataSet.dataSource(reader.getValue());
                    break;
                }
                case "item": {
                    dataSet.item(ExtendXStream.readValue(context, DataCompositionSchema.DataSet.class));
                    break;
                }
                case "field": {
                    dataSet.field(DataSetConverter.readField(reader));
                    break;
                }
                case "query": {
                    dataSet.querySource(ExtendXStream.readValue(context, QuerySource.class));
                    break;
                }
            }
            reader.moveUp();
        }
        return dataSet.build();
    }

    private static DataCompositionSchema.DataSetField readField(HierarchicalStreamReader reader) {
        String dataPath = "";
        String field = "";
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "field": {
                    field = reader.getValue();
                    break;
                }
                case "dataPath": {
                    dataPath = reader.getValue();
                    break;
                }
            }
            reader.moveUp();
        }
        return new DataCompositionSchema.DataSetField(dataPath, field);
    }

    public boolean canConvert(Class type) {
        return type == DataCompositionSchema.DataSet.class;
    }
}

