/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.support.EnumWithValue;
import com.github._1c_syntax.bsl.mdo.support.UsePurposes;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumConverter<T extends Enum<T>>
extends AbstractSingleValueConverter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumConverter.class);
    private static final String URL_TEMPLATE = "https://github.com/1c-syntax/mdclasses/issues/new?labels=bug&title=%5BBUG%5D%20Unknown%20element%20%5B{}%20{}%5D";
    private static final String WARN_TEMPLATE = "Parsing error due to unknown element {}. Please, create issue using link https://github.com/1c-syntax/mdclasses/issues/new?labels=bug&title=%5BBUG%5D%20Unknown%20element%20%5B{}%20{}%5D";
    private final Class<T> enumClazz;
    private final T unknown;
    private final Map<String, T> enumElements;

    public EnumConverter(Class<T> clazz) {
        this.enumClazz = clazz;
        this.unknown = this.unknown();
        this.enumElements = new HashMap<String, T>();
        for (Enum item : (Enum[])this.enumClazz.getEnumConstants()) {
            this.enumElements.put(((EnumWithValue)((Object)item)).value(), item);
            if (!UsePurposes.class.isAssignableFrom(this.enumClazz)) continue;
            this.enumElements.put(((UsePurposes)item).valueVar2(), item);
        }
    }

    public Object fromString(String sourceString) {
        Enum result = (Enum)this.enumElements.get(sourceString);
        if (result == null) {
            LOGGER.warn(WARN_TEMPLATE, new Object[]{sourceString, this.enumClazz.getName(), sourceString});
            result = this.unknown;
        }
        return result;
    }

    private T unknown() {
        for (Enum item : (Enum[])this.enumClazz.getEnumConstants()) {
            if (!((EnumWithValue)((Object)item)).isUnknown()) continue;
            return (T)item;
        }
        throw new IllegalStateException("No unknown value found for enum " + this.enumClazz.getName());
    }

    public boolean canConvert(Class type) {
        return this.enumClazz.isAssignableFrom(type);
    }
}

