/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.support.MultiLanguageString;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommonConverter
public class MultiLanguageStringConverter
implements ReadConverter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiLanguageStringConverter.class);

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (!reader.hasMoreChildren()) {
            return MultiLanguageString.EMPTY;
        }
        HashSet<MultiLanguageString.Entry> langContent = new HashSet<MultiLanguageString.Entry>();
        if (ExtendXStream.getCurrentMDReader(reader).getConfigurationSource() == ConfigurationSource.DESIGNER) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                langContent.add(MultiLanguageStringConverter.multiLanguageString(reader, "lang", "content"));
                reader.moveUp();
            }
        } else {
            langContent.add(MultiLanguageStringConverter.multiLanguageString(reader, "key", "value"));
        }
        return MultiLanguageString.create(langContent);
    }

    public boolean canConvert(Class type) {
        return type == MultiLanguageString.class;
    }

    private static MultiLanguageString.Entry multiLanguageString(HierarchicalStreamReader reader, String langNodeName, String contentNodeName) {
        String lang = "";
        String content = "";
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String node = reader.getNodeName();
            if (langNodeName.equals(node)) {
                lang = reader.getValue();
            } else if (contentNodeName.equals(node)) {
                content = reader.getValue();
            }
            reader.moveUp();
        }
        return MultiLanguageString.Entry.create(lang, content);
    }
}

