/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.storage.RoleData;
import com.github._1c_syntax.bsl.reader.common.TransformationUtils;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

@CommonConverter
public class RoleDataConverter
implements ReadConverter {
    private static final String OBJECT_NODE_NAME = "object";
    private static final String RIGHT_NODE_NAME = "right";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RoleData.RoleDataBuilder builder = RoleData.builder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if (OBJECT_NODE_NAME.equals(name)) {
                RoleData.ObjectRight objectRight = RoleDataConverter.readObjectRight(reader, context);
                builder.objectRight(objectRight);
            } else {
                Class fieldClass = (Class)TransformationUtils.fieldType(builder, name);
                Object value = ExtendXStream.readValue(context, fieldClass);
                TransformationUtils.setValue(builder, name, value);
            }
            reader.moveUp();
        }
        return builder.build();
    }

    private static RoleData.ObjectRight readObjectRight(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RoleData.ObjectRight.ObjectRightBuilder builder = RoleData.ObjectRight.builder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if (RIGHT_NODE_NAME.equals(name)) {
                RoleData.Right right = RoleDataConverter.readRight(reader, context);
                builder.right(right);
            } else {
                Class fieldClass = (Class)TransformationUtils.fieldType(builder, name);
                Object value = ExtendXStream.readValue(context, fieldClass);
                TransformationUtils.setValue(builder, name, value);
            }
            reader.moveUp();
        }
        return builder.build();
    }

    private static RoleData.Right readRight(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RoleData.Right.RightBuilder builder = RoleData.Right.builder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            Class fieldClass = (Class)TransformationUtils.fieldType(builder, name);
            Object value = ExtendXStream.readValue(context, fieldClass);
            TransformationUtils.setValue(builder, name, value);
            reader.moveUp();
        }
        return (RoleData.Right)RoleData.RIGHT_INTERNER.intern((Object)builder.build());
    }

    public boolean canConvert(Class type) {
        return RoleData.class.isAssignableFrom(type);
    }
}

