/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.xstream;

import com.github._1c_syntax.bsl.mdclasses.ConfigurationTree;
import com.github._1c_syntax.bsl.mdclasses.ExternalDataProcessor;
import com.github._1c_syntax.bsl.mdclasses.ExternalReport;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.storage.DataCompositionSchema;
import com.github._1c_syntax.bsl.mdo.storage.RoleData;
import com.github._1c_syntax.bsl.mdo.storage.XdtoPackageData;
import com.github._1c_syntax.bsl.mdo.storage.form.FormElementType;
import com.github._1c_syntax.bsl.mdo.support.ApplicationRunMode;
import com.github._1c_syntax.bsl.mdo.support.AutoRecordType;
import com.github._1c_syntax.bsl.mdo.support.ConfigurationExtensionPurpose;
import com.github._1c_syntax.bsl.mdo.support.DataLockControlMode;
import com.github._1c_syntax.bsl.mdo.support.DataSeparation;
import com.github._1c_syntax.bsl.mdo.support.FormType;
import com.github._1c_syntax.bsl.mdo.support.IndexingType;
import com.github._1c_syntax.bsl.mdo.support.InterfaceCompatibilityMode;
import com.github._1c_syntax.bsl.mdo.support.MessageDirection;
import com.github._1c_syntax.bsl.mdo.support.ObjectBelonging;
import com.github._1c_syntax.bsl.mdo.support.ReturnValueReuse;
import com.github._1c_syntax.bsl.mdo.support.ReuseSessions;
import com.github._1c_syntax.bsl.mdo.support.RoleRight;
import com.github._1c_syntax.bsl.mdo.support.ScriptVariant;
import com.github._1c_syntax.bsl.mdo.support.TemplateType;
import com.github._1c_syntax.bsl.mdo.support.TransferDirection;
import com.github._1c_syntax.bsl.mdo.support.UseMode;
import com.github._1c_syntax.bsl.mdo.support.UsePurposes;
import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.converter.EnumConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendReaderWrapper;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendStaxDriver;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.SingletonCollectionConverter;
import com.thoughtworks.xstream.converters.collections.SingletonMapConverter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.mapper.CachingMapper;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.SecurityMapper;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.HasName;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendXStream
extends XStream {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendXStream.class);

    public ExtendXStream(MDReader reader, ClassLoaderReference classLoaderReference, Mapper mapper) {
        super((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new ExtendStaxDriver(reader), classLoaderReference, mapper);
        this.init();
    }

    public ExtendXStream(MDReader reader, QNameMap qNameMap, ClassLoaderReference classLoaderReference, Mapper mapper) {
        super((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new ExtendStaxDriver(reader, qNameMap), classLoaderReference, mapper);
        this.init();
    }

    public Object fromXML(File file) {
        Object result = null;
        if (file.exists()) {
            try {
                result = super.fromXML(file);
            }
            catch (ConversionException e) {
                LOGGER.error("Can't read file '{}' - it's broken \n: ", (Object)file, (Object)e);
                throw e;
            }
            catch (CannotResolveClassException e) {
                LOGGER.debug("Can't read file '{}' - unknown class \n: ", (Object)file, (Object)e);
            }
        }
        return result;
    }

    public Class<?> getRealClass(String className) {
        return this.getMapper().realClass(className);
    }

    public static Class<?> getRealClass(HierarchicalStreamReader reader, String className) {
        return ExtendXStream.getCurrentMDReader(reader).getXstream().getRealClass(className);
    }

    public static Object read(HierarchicalStreamReader reader, Path contentPath) {
        return ExtendXStream.getCurrentMDReader(reader).read(contentPath);
    }

    public static Object read(HierarchicalStreamReader reader, Path contentPath, String fullName) {
        return ExtendXStream.getCurrentMDReader(reader).read(contentPath, fullName);
    }

    public static Path getCurrentPath(HierarchicalStreamReader reader) {
        return ((ExtendReaderWrapper)reader).getPath();
    }

    public static MDReader getCurrentMDReader(HierarchicalStreamReader reader) {
        return ((ExtendReaderWrapper)reader).getMDReader();
    }

    public static <T> T readValue(UnmarshallingContext context, Class<T> clazz) {
        return (T)context.convertAnother(null, clazz);
    }

    public static void registerConverters(ExtendXStream xStream, String convertersPackageName, Class<?> annotation) {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().acceptPackages(new String[]{convertersPackageName}).scan();){
            ClassInfoList classes = scanResult.getClassesWithAnnotation(annotation.getName());
            classes.stream().map(ExtendXStream.getObjectsFromInfoClass()).filter(Objects::nonNull).forEach(xStream::registerMDCConverter);
        }
    }

    protected void setupConverters() {
        this.registerConverter((Converter)new NullConverter(), 10000);
        this.registerConverter((SingleValueConverter)new IntConverter(), 0);
        this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
        this.registerConverter((SingleValueConverter)new StringConverter(), -10);
        this.registerConverter((Converter)new CollectionConverter(this.getMapper()));
        this.registerConverter((Converter)new ArrayConverter(this.getMapper()), 0);
        this.registerConverter((Converter)new MapConverter(this.getMapper()), 0);
        this.registerConverter((Converter)new SingletonCollectionConverter(this.getMapper()), 0);
        this.registerConverter((Converter)new SingletonMapConverter(this.getMapper()), 0);
        this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
        ExtendXStream.registerConverters(this, "com.github._1c_syntax.bsl.reader.common.converter", CommonConverter.class);
        this.registerConverter((SingleValueConverter)new EnumConverter<ApplicationRunMode>(ApplicationRunMode.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<AutoRecordType>(AutoRecordType.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<ConfigurationExtensionPurpose>(ConfigurationExtensionPurpose.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<DataLockControlMode>(DataLockControlMode.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<DataSeparation>(DataSeparation.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<FormType>(FormType.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<IndexingType>(IndexingType.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<MessageDirection>(MessageDirection.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<ObjectBelonging>(ObjectBelonging.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<ReturnValueReuse>(ReturnValueReuse.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<ReuseSessions>(ReuseSessions.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<RoleRight>(RoleRight.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<ScriptVariant>(ScriptVariant.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<TemplateType>(TemplateType.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<TransferDirection>(TransferDirection.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<UseMode>(UseMode.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<UsePurposes>(UsePurposes.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<FormElementType>(FormElementType.class));
        this.registerConverter((SingleValueConverter)new EnumConverter<InterfaceCompatibilityMode>(InterfaceCompatibilityMode.class));
    }

    private void init() {
        this.setMode(1001);
        this.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.github._1c_syntax.**"}));
        this.registerClasses();
    }

    protected void registerMDCConverter(Object converter) {
        if (converter instanceof Converter) {
            Converter simpleConverter = (Converter)converter;
            this.registerConverter(simpleConverter);
        } else if (converter instanceof SingleValueConverter) {
            SingleValueConverter singleValueConverter = (SingleValueConverter)converter;
            this.registerConverter(singleValueConverter);
        } else {
            throw new IllegalArgumentException("Unknown converter type " + String.valueOf(converter));
        }
    }

    private void registerClasses() {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().acceptPackages(new String[]{"com.github._1c_syntax.bsl.mdo"}).rejectPackages(new String[]{"com.github._1c_syntax.bsl.mdo.children"}).scan();){
            scanResult.getClassesImplementing(MD.class.getName()).filter(classInfo -> !classInfo.isInterface()).forEach(clazzInfo -> {
                Class<?> clazz = ExtendXStream.getClassFromClassInfo((HasName)clazzInfo);
                String simpleName = clazzInfo.getSimpleName();
                this.alias(simpleName, clazz);
            });
        }
        this.alias("Rights", RoleData.class);
        this.alias("package", XdtoPackageData.class);
        this.alias("DataCompositionSchema", DataCompositionSchema.class);
        this.alias("Configuration", ConfigurationTree.class);
        this.alias("ExternalDataProcessor", ExternalDataProcessor.class);
        this.alias("ExternalReport", ExternalReport.class);
    }

    @Nullable
    private static Class<?> getClassFromClassInfo(HasName classInfo) {
        try {
            return Class.forName(classInfo.getName());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot resolve class {}\n", (Object)classInfo.getName(), (Object)e);
            return null;
        }
    }

    private static Function<ClassInfo, Object> getObjectsFromInfoClass() {
        return classInfo -> {
            try {
                Class<?> clazz = Class.forName(classInfo.getName());
                return clazz.getDeclaredConstructors()[0].newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.error("Cannot resolve class {}\n", (Object)classInfo.getName(), (Object)e);
                throw new IllegalArgumentException("Cannot resolve class");
            }
        };
    }

    public static Mapper buildMapper(ClassLoaderReference classLoaderReference) {
        DefaultMapper mapper = new DefaultMapper(classLoaderReference);
        mapper = new ClassAliasingMapper((Mapper)mapper);
        mapper = new DefaultImplementationsMapper((Mapper)mapper);
        mapper = new SecurityMapper((Mapper)mapper);
        mapper = new CachingMapper((Mapper)mapper);
        return mapper;
    }
}

