/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer;

import com.github._1c_syntax.bsl.mdclasses.Configuration;
import com.github._1c_syntax.bsl.mdclasses.ExternalReport;
import com.github._1c_syntax.bsl.mdclasses.ExternalSource;
import com.github._1c_syntax.bsl.mdclasses.MDClass;
import com.github._1c_syntax.bsl.mdo.ExchangePlan;
import com.github._1c_syntax.bsl.mdo.children.AccountingFlag;
import com.github._1c_syntax.bsl.mdo.children.Dimension;
import com.github._1c_syntax.bsl.mdo.children.DocumentJournalColumn;
import com.github._1c_syntax.bsl.mdo.children.EnumValue;
import com.github._1c_syntax.bsl.mdo.children.ExtDimensionAccountingFlag;
import com.github._1c_syntax.bsl.mdo.children.ExternalDataSourceTable;
import com.github._1c_syntax.bsl.mdo.children.ExternalDataSourceTableField;
import com.github._1c_syntax.bsl.mdo.children.HTTPServiceMethod;
import com.github._1c_syntax.bsl.mdo.children.HTTPServiceURLTemplate;
import com.github._1c_syntax.bsl.mdo.children.IntegrationServiceChannel;
import com.github._1c_syntax.bsl.mdo.children.ObjectAttribute;
import com.github._1c_syntax.bsl.mdo.children.ObjectCommand;
import com.github._1c_syntax.bsl.mdo.children.ObjectForm;
import com.github._1c_syntax.bsl.mdo.children.ObjectTabularSection;
import com.github._1c_syntax.bsl.mdo.children.ObjectTemplate;
import com.github._1c_syntax.bsl.mdo.children.Recalculation;
import com.github._1c_syntax.bsl.mdo.children.Resource;
import com.github._1c_syntax.bsl.mdo.children.TaskAddressingAttribute;
import com.github._1c_syntax.bsl.mdo.children.WebServiceOperation;
import com.github._1c_syntax.bsl.mdo.children.WebServiceOperationParameter;
import com.github._1c_syntax.bsl.mdo.storage.EmptyFormData;
import com.github._1c_syntax.bsl.mdo.storage.FormData;
import com.github._1c_syntax.bsl.mdo.storage.ManagedFormData;
import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.common.context.AbstractReaderContext;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerConverter;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerRootWrapper;
import com.github._1c_syntax.bsl.reader.designer.converter.Unmarshaller;
import com.github._1c_syntax.bsl.supconf.ParseSupportData;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.mapper.Mapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesignerReader
implements MDReader {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DesignerReader.class);
    public static final String CONFIGURATION_MDO_PATH = "Configuration.xml";
    private final ExtendXStream xstream = this.createXMLMapper();
    private final Path rootPath;

    public DesignerReader(Path path, boolean skipSupport) {
        this.rootPath = path;
        if (!skipSupport) {
            ParseSupportData.readSimple((Path)this.parentConfigurationsPath());
        }
    }

    @Override
    @NonNull
    public ConfigurationSource getConfigurationSource() {
        return ConfigurationSource.DESIGNER;
    }

    @Override
    @NonNull
    public MDClass readConfiguration() {
        Optional<MDClass> mdc = Optional.ofNullable((MDClass)this.read(DesignerReader.mdoPath(this.rootPath, MDOType.CONFIGURATION, MDOType.CONFIGURATION.getName())));
        return mdc.orElse(Configuration.EMPTY);
    }

    @Override
    @NonNull
    public ExternalSource readExternalSource() {
        Object value = this.read(this.rootPath);
        if (value instanceof ExternalSource) {
            ExternalSource externalSource = (ExternalSource)value;
            return externalSource;
        }
        return ExternalReport.EMPTY;
    }

    @Override
    @Nullable
    public Object read(Path folder, String fullName) {
        int dotPosition = fullName.indexOf(46);
        Optional type = MDOType.fromValue((String)fullName.substring(0, dotPosition));
        String name = fullName.substring(dotPosition + 1);
        if (type.isPresent()) {
            Path path = this.rootPath.equals(folder) ? DesignerReader.mdoPath(folder, (MDOType)type.get(), name) : DesignerReader.mdoPath(folder, name);
            return this.read(path);
        }
        return null;
    }

    @Override
    @Nullable
    public FormData readFormData(Path currentPath, String name, MDOType mdoType) {
        Path formDataPath = Paths.get(currentPath.getParent().toString(), name, "Ext", "Form.xml");
        if (!formDataPath.toFile().exists()) {
            return EmptyFormData.EMPTY;
        }
        return (FormData)this.read(formDataPath);
    }

    @Override
    @NonNull
    public Path moduleFolder(Path mdoPath, MDOType mdoType) {
        if (mdoType == MDOType.COMMAND) {
            return DesignerReader.childrenFolder(mdoPath, mdoType);
        }
        if (!MDOType.valuesWithoutChildren().contains(mdoType)) {
            return mdoPath.getParent();
        }
        return this.mdoTypeFolderPath(mdoPath);
    }

    @Override
    @NonNull
    public Path modulePath(Path folder, String name, ModuleType moduleType) {
        String subdirectory = "Ext";
        if (moduleType == ModuleType.FormModule) {
            subdirectory = Path.of(subdirectory, "Form").toString();
        }
        if (!ModuleType.byMDOType((MDOType)MDOType.CONFIGURATION).contains(moduleType)) {
            subdirectory = Path.of(name, subdirectory).toString();
        }
        return Paths.get(folder.toString(), subdirectory, moduleType.getFileName());
    }

    @Override
    @NonNull
    public Path mdoTypeFolderPath(Path mdoPath) {
        return Paths.get(FilenameUtils.getFullPathNoEndSeparator((String)mdoPath.toString()), new String[0]);
    }

    @Override
    @NonNull
    public String subsystemsNodeName() {
        return "Subsystem";
    }

    @Override
    @NonNull
    public String configurationExtensionFilter() {
        return "(<ObjectBelonging>)";
    }

    @Override
    public void unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context, AbstractReaderContext readerContext) {
        Unmarshaller.unmarshal(reader, context, readerContext);
    }

    private ExtendXStream createXMLMapper() {
        QNameMap qNameMap = new QNameMap();
        qNameMap.registerMapping(new QName("http://v8.1c.ru/8.3/xcf/logform", "Form"), ManagedFormData.class);
        ClassLoaderReference classLoaderReference = new ClassLoaderReference((ClassLoader)new CompositeClassLoader());
        Mapper mapper = ExtendXStream.buildMapper(classLoaderReference);
        ExtendXStream xStream = new ExtendXStream(this, qNameMap, classLoaderReference, mapper);
        DesignerReader.registerClasses(xStream);
        ExtendXStream.registerConverters(xStream, "com.github._1c_syntax.bsl.reader.designer.converter", DesignerConverter.class);
        return xStream;
    }

    private static void registerClasses(XStream xStream) {
        xStream.alias("MetaDataObject", DesignerRootWrapper.class);
        xStream.alias("AccountingFlag", AccountingFlag.class);
        xStream.alias("AddressingAttribute", TaskAddressingAttribute.class);
        xStream.alias("Attribute", ObjectAttribute.class);
        xStream.alias("Dimension", Dimension.class);
        xStream.alias("EnumValue", EnumValue.class);
        xStream.alias("ExchangePlanContent", ExchangePlan.RecordContent.class);
        xStream.alias("ExtDimensionAccountingFlag", ExtDimensionAccountingFlag.class);
        xStream.alias("Column", DocumentJournalColumn.class);
        xStream.alias("Command", ObjectCommand.class);
        xStream.alias("Field", ExternalDataSourceTableField.class);
        xStream.alias("Form", ObjectForm.class);
        xStream.alias("IntegrationServiceChannel", IntegrationServiceChannel.class);
        xStream.alias("Method", HTTPServiceMethod.class);
        xStream.alias("Operation", WebServiceOperation.class);
        xStream.alias("Parameter", WebServiceOperationParameter.class);
        xStream.alias("Recalculation", Recalculation.class);
        xStream.alias("Resource", Resource.class);
        xStream.alias("Table", ExternalDataSourceTable.class);
        xStream.alias("TabularSection", ObjectTabularSection.class);
        xStream.alias("Template", ObjectTemplate.class);
        xStream.alias("URLTemplate", HTTPServiceURLTemplate.class);
    }

    private Path parentConfigurationsPath() {
        return Paths.get(this.rootPath.toString(), "Ext", "ParentConfigurations.bin");
    }

    private static Path mdoPath(Path path, MDOType type, String name) {
        return DesignerReader.mdoPath(Paths.get(path.toString(), type.getGroupName()), name);
    }

    private static Path mdoPath(Path folder, String name) {
        return Paths.get(folder.toString(), name + ".xml");
    }

    private static Path childrenFolder(Path path, MDOType type) {
        return Paths.get(path.getParent().toString(), FilenameUtils.getBaseName((String)path.toString()), type.getGroupName());
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExtendXStream getXstream() {
        return this.xstream;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getRootPath() {
        return this.rootPath;
    }
}

