/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer.converter;

import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerConverter;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

@DesignerConverter
public class MdoReferenceConverter
implements ReadConverter {
    private static final String ITEM_NODE_NAME = "Item";
    private static final String METADATA_NODE_NAME = "Metadata";
    private static final String USE_NODE_NAME = "Use";
    private static final String PICTURE_NODE_NAME = "Picture";
    private static final String REF_NODE_NAME = "Ref";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String value = "";
        value = reader.hasMoreChildren() ? MdoReferenceConverter.readValue(reader) : reader.getValue();
        if (value.isEmpty() || value.contains("-")) {
            return null;
        }
        return MdoReference.create((String)value);
    }

    public boolean canConvert(Class type) {
        return MdoReference.class.isAssignableFrom(type);
    }

    private static String readValue(HierarchicalStreamReader reader) {
        String nodeName = reader.getNodeName();
        String value = "";
        switch (nodeName) {
            case "Item": {
                value = MdoReferenceConverter.readValue(reader, METADATA_NODE_NAME, value);
                break;
            }
            case "Use": {
                reader.moveDown();
                value = reader.getValue();
                reader.moveUp();
                break;
            }
            case "Picture": {
                value = MdoReferenceConverter.readValue(reader, REF_NODE_NAME, value);
                break;
            }
            default: {
                value = reader.getValue();
            }
        }
        return value;
    }

    private static String readValue(HierarchicalStreamReader reader, String metadataNodeName, String value) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (metadataNodeName.equals(reader.getNodeName())) {
                value = reader.getValue();
                reader.moveUp();
                break;
            }
            reader.moveUp();
        }
        return value;
    }
}

