/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer.converter;

import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerConverter;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerRootWrapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DesignerConverter
public class MetaDataObjectConverter
implements ReadConverter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataObjectConverter.class);

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        String nodeName = reader.getNodeName();
        Class<?> realClass = ExtendXStream.getRealClass(reader, nodeName);
        if (realClass == null) {
            LOGGER.error("Unexpected type `{}`, path: `{}`", (Object)nodeName, (Object)ExtendXStream.getCurrentPath(reader));
            throw new IllegalStateException("Unexpected type: " + nodeName);
        }
        try {
            return ExtendXStream.readValue(context, realClass);
        }
        catch (ConversionException e) {
            LOGGER.error("Can't convert: `{}`", (Object)ExtendXStream.getCurrentPath(reader));
            throw e;
        }
    }

    public boolean canConvert(Class type) {
        return DesignerRootWrapper.class.isAssignableFrom(type);
    }
}

