/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer.converter;

import com.github._1c_syntax.bsl.mdo.CommonTemplate;
import com.github._1c_syntax.bsl.mdo.Template;
import com.github._1c_syntax.bsl.mdo.storage.EmptyTemplateData;
import com.github._1c_syntax.bsl.mdo.storage.TemplateData;
import com.github._1c_syntax.bsl.mdo.support.TemplateType;
import com.github._1c_syntax.bsl.reader.common.context.MDReaderContext;
import com.github._1c_syntax.bsl.reader.common.converter.AbstractReadConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerConverter;
import com.github._1c_syntax.bsl.types.MDOType;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;

@DesignerConverter
public class TemplateConverter
extends AbstractReadConverter {
    private static final String DATA_FIELD = "data";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object data;
        String name = reader.getNodeName();
        Class<CommonTemplate> realClass = ExtendXStream.getRealClass(reader, name);
        if (!realClass.isAssignableFrom(CommonTemplate.class)) {
            Path currentPath = ExtendXStream.getCurrentPath(reader);
            if (reader.getAttributeCount() == 0) {
                String childName = ExtendXStream.readValue(context, String.class);
                return ExtendXStream.read(reader, TemplateConverter.childDataPath(currentPath, childName));
            }
        }
        MDReaderContext readerContext = super.read(reader, context);
        TemplateData templateData = EmptyTemplateData.getEmpty();
        if (readerContext.getTemplateType() == TemplateType.DATA_COMPOSITION_SCHEME && (data = ExtendXStream.read(reader, TemplateConverter.dataPath(readerContext.getCurrentPath(), readerContext.getName()))) instanceof TemplateData) {
            TemplateData templData = (TemplateData)data;
            templateData = templData;
        }
        readerContext.setValue(DATA_FIELD, templateData);
        if (realClass.isAssignableFrom(CommonTemplate.class)) {
            return readerContext.build();
        }
        return readerContext;
    }

    public boolean canConvert(Class type) {
        return Template.class.isAssignableFrom(type);
    }

    private static Path dataPath(Path path, String name) {
        return Paths.get(path.getParent().toString(), name, "Ext", "Template.xml");
    }

    private static Path childDataPath(Path path, String childName) {
        return Paths.get(path.getParent().toString(), FilenameUtils.getBaseName((String)path.toString()), MDOType.TEMPLATE.getGroupName(), childName + ".xml");
    }
}

