/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer.converter;

import com.github._1c_syntax.bsl.mdo.support.TemplateType;
import com.github._1c_syntax.bsl.reader.common.context.AbstractReaderContext;
import com.github._1c_syntax.bsl.reader.common.context.FormElementReaderContext;
import com.github._1c_syntax.bsl.reader.common.context.MDCReaderContext;
import com.github._1c_syntax.bsl.reader.common.context.MDReaderContext;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.support.CompatibilityMode;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import lombok.Generated;

public final class Unmarshaller {
    private static final String PROPERTIES_NODE = "Properties";
    private static final String CHILD_OBJECTS_NODE = "ChildObjects";
    private static final String CHILD_ITEMS_NODE = "ChildItems";
    private static final String ITEMS_NODE = "items";
    private static final String USE_PURPOSES_NODE = "UsePurposes";
    private static final String EVENTS_NODE = "Events";
    private static final String HANDLES_NODE = "Handlers";
    private static final String ATTRIBUTES_NODE = "Attributes";
    private static final String NAME_NODE = "Name";
    private static final String TEMPLATE_TYPE_NODE = "TemplateType";
    private static final String CP_MODE_NODE = "CompatibilityMode";
    private static final String CP_EXT_MODE_NODE = "ConfigurationExtensionCompatibilityMode";

    public static void unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context, AbstractReaderContext readerContext) {
        if (readerContext instanceof MDReaderContext) {
            MDReaderContext mdReaderContext = (MDReaderContext)readerContext;
            Unmarshaller.unmarshal(reader, context, mdReaderContext);
        } else {
            Unmarshaller.unmarshal(reader, context, (MDCReaderContext)readerContext);
        }
    }

    public static void unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context, FormElementReaderContext readerContext) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if (CHILD_ITEMS_NODE.equals(name)) {
                Unmarshaller.readItemNode(reader, context, readerContext, ITEMS_NODE);
            } else if (ATTRIBUTES_NODE.equals(name)) {
                Unmarshaller.readItemNode(reader, context, readerContext, ATTRIBUTES_NODE);
            } else if (EVENTS_NODE.equals(name)) {
                Unmarshaller.readItemNode(reader, context, readerContext, HANDLES_NODE);
            } else {
                Unmarshaller.readNode(reader.getNodeName(), context, readerContext);
            }
            reader.moveUp();
        }
    }

    private static void unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context, MDReaderContext readerContext) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if (PROPERTIES_NODE.equals(name) || CHILD_OBJECTS_NODE.equals(name)) {
                Unmarshaller.readPropertiesNode(reader, context, readerContext);
            }
            reader.moveUp();
        }
    }

    private static void unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context, MDCReaderContext readerContext) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if (PROPERTIES_NODE.equals(name)) {
                Unmarshaller.readPropertiesNode(reader, context, readerContext);
            } else if (CHILD_OBJECTS_NODE.equals(name)) {
                Unmarshaller.readChildrenNames(reader, readerContext);
            }
            reader.moveUp();
        }
    }

    private static void readItemNode(HierarchicalStreamReader reader, UnmarshallingContext context, AbstractReaderContext readerContext, String nodeName) {
        Class<?> fieldClass = readerContext.fieldType(nodeName);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            readerContext.setValue(nodeName, ExtendXStream.readValue(context, fieldClass));
            reader.moveUp();
        }
    }

    private static void readNode(String name, UnmarshallingContext context, FormElementReaderContext readerContext) {
        Class<?> fieldClass = readerContext.fieldType(name);
        if (fieldClass == null) {
            return;
        }
        readerContext.setValue(name, ExtendXStream.readValue(context, fieldClass));
    }

    private static void readPropertiesNode(HierarchicalStreamReader reader, UnmarshallingContext context, AbstractReaderContext readerContext) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if (USE_PURPOSES_NODE.equals(name)) {
                Unmarshaller.readItemNode(reader, context, readerContext, USE_PURPOSES_NODE);
            } else {
                Class<?> fieldClass = readerContext.fieldType(name);
                if (fieldClass != null) {
                    Unmarshaller.readValue(reader, context, readerContext, fieldClass, name);
                }
            }
            reader.moveUp();
        }
    }

    private static void readChildrenNames(HierarchicalStreamReader reader, AbstractReaderContext readerContext) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            readerContext.setValue(name, name + "." + reader.getValue());
            reader.moveUp();
        }
    }

    private static void readValue(HierarchicalStreamReader reader, UnmarshallingContext context, AbstractReaderContext readerContext, Class<?> fieldClass, String name) {
        Object value = Unmarshaller.readValue(reader, context, fieldClass);
        if (name.equals(NAME_NODE) && value instanceof String) {
            String string = (String)value;
            readerContext.setName(string);
        }
        if (readerContext instanceof MDReaderContext) {
            MDReaderContext mdReaderContext = (MDReaderContext)readerContext;
            if (name.equals(TEMPLATE_TYPE_NODE) && value instanceof TemplateType) {
                TemplateType templateType = (TemplateType)value;
                mdReaderContext.setTemplateType(templateType);
            }
        } else {
            MDCReaderContext mdcReaderContext = (MDCReaderContext)readerContext;
            if (name.equals(CP_MODE_NODE) && value instanceof CompatibilityMode) {
                CompatibilityMode compatibilityMode = (CompatibilityMode)value;
                mdcReaderContext.setCompatibilityMode(compatibilityMode);
            } else if (name.equals(CP_EXT_MODE_NODE) && value instanceof CompatibilityMode) {
                CompatibilityMode compatibilityMode = (CompatibilityMode)value;
                mdcReaderContext.setConfigurationExtensionCompatibilityMode(compatibilityMode);
            }
        }
        readerContext.setValue(name, value);
    }

    private static Object readValue(HierarchicalStreamReader reader, UnmarshallingContext context, Class<?> fieldClass) {
        try {
            return ExtendXStream.readValue(context, fieldClass);
        }
        catch (ConversionException e) {
            ArrayList result = new ArrayList();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                result.add(ExtendXStream.readValue(context, fieldClass));
                reader.moveUp();
            }
            return result;
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Unmarshaller() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

