/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.edt.converter;

import com.github._1c_syntax.bsl.mdo.CommonTemplate;
import com.github._1c_syntax.bsl.mdo.storage.EmptyTemplateData;
import com.github._1c_syntax.bsl.mdo.storage.TemplateData;
import com.github._1c_syntax.bsl.reader.common.context.MDReaderContext;
import com.github._1c_syntax.bsl.reader.common.converter.AbstractReadConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.edt.converter.EDTConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.file.Path;

@EDTConverter
public class CommonTemplateConverter
extends AbstractReadConverter {
    private static final String DATA_FIELD = "data";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        MDReaderContext readerContext = super.read(reader, context);
        TemplateData templateData = EmptyTemplateData.getEmpty();
        Path path = CommonTemplateConverter.dataPath(readerContext.getCurrentPath());
        Object data = ExtendXStream.read(reader, path);
        if (data instanceof TemplateData) {
            TemplateData templData = (TemplateData)data;
            templateData = templData;
        }
        readerContext.setValue(DATA_FIELD, templateData);
        return readerContext.build();
    }

    public boolean canConvert(Class type) {
        return CommonTemplate.class.isAssignableFrom(type);
    }

    private static Path dataPath(Path path) {
        return Path.of(path.getParent().toString(), "Template.dcs");
    }
}

