/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.supconf;

import com.github._1c_syntax.bsl.supconf.GeneralSupportVariant;
import com.github._1c_syntax.bsl.supconf.SupportConfiguration;
import com.github._1c_syntax.bsl.support.SupportVariant;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParseSupportData {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseSupportData.class);
    private static final String REGEX = "(?:,[\\n\\r]*|\\n|^)(\"(?:(?:\"\")*[^\"]*)*\"|[^\",\\n]*|(?:\\n|$))";
    private static final Pattern patternSplit = Pattern.compile("(?:,[\\n\\r]*|\\n|^)(\"(?:(?:\"\")*[^\"]*)*\"|[^\",\\n]*|(?:\\n|$))");
    private static final int POINT_COUNT_CONFIGURATION = 2;
    private static final int SHIFT_CONFIGURATION_VERSION = 3;
    private static final int SHIFT_CONFIGURATION_PRODUCER = 4;
    private static final int SHIFT_CONFIGURATION_NAME = 5;
    private static final int SHIFT_CONFIGURATION_COUNT_OBJECT = 6;
    private static final int SHIFT_OBJECT_COUNT = 7;
    private static final int COUNT_ELEMENT_OBJECT = 4;
    private static final int CONFIGURATION_SUPPORT = 1;
    private static final int START_READ_POSITION = 3;
    private static final int SHIFT_SIZE = 2;
    private static final Map<Path, Map<String, Map<SupportConfiguration, SupportVariant>>> SUPPORT_MAPS = new ConcurrentHashMap<Path, Map<String, Map<SupportConfiguration, SupportVariant>>>();
    private static final Map<Path, Map<String, SupportVariant>> SUPPORT_SIMPLE_MAPS = new ConcurrentHashMap<Path, Map<String, SupportVariant>>();

    public static Map<String, SupportVariant> readSimple(Path path) {
        Path rootPath = ParseSupportData.getRootPathByParentConfigurations(path);
        Map<String, SupportVariant> supportMap = SUPPORT_SIMPLE_MAPS.get(rootPath);
        if (supportMap == null && path.toFile().exists()) {
            ParseSupportData.readFile(path, rootPath, false);
            supportMap = SUPPORT_SIMPLE_MAPS.get(rootPath);
        }
        if (supportMap == null) {
            return Collections.emptyMap();
        }
        return supportMap;
    }

    public static Map<String, Map<SupportConfiguration, SupportVariant>> readFull(Path path) {
        Path rootPath = ParseSupportData.getRootPathByParentConfigurations(path);
        Map<String, Map<SupportConfiguration, SupportVariant>> supportMap = SUPPORT_MAPS.get(rootPath);
        if (supportMap == null && path.toFile().exists()) {
            ParseSupportData.readFile(path, rootPath, true);
            supportMap = SUPPORT_MAPS.get(rootPath);
        }
        if (supportMap == null) {
            return Collections.emptyMap();
        }
        return supportMap;
    }

    public static SupportVariant getSupportVariantByMDO(String uuid, Path path) {
        Optional<Path> key = SUPPORT_SIMPLE_MAPS.keySet().stream().filter(path::startsWith).findFirst();
        if (key.isPresent()) {
            return SUPPORT_SIMPLE_MAPS.get(key.get()).getOrDefault(uuid, SupportVariant.NONE);
        }
        return SupportVariant.NONE;
    }

    private static void readFile(Path pathToBinFile, Path rootPath, boolean fullRead) {
        LOGGER.debug("\u0427\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0438 ParentConfigurations.bin, \u043f\u043e\u043b\u043d\u043e\u0435 \u0447\u0442\u0435\u043d\u0438\u0435 = " + fullRead);
        try {
            Map<String, Map<SupportConfiguration, SupportVariant>> supportMap = ParseSupportData.read(pathToBinFile);
            if (fullRead) {
                SUPPORT_MAPS.put(rootPath, supportMap);
            } else {
                HashMap result = new HashMap();
                supportMap.forEach((uuid, supportVariantMap) -> result.put(uuid, SupportVariant.max(supportVariantMap.values())));
                SUPPORT_SIMPLE_MAPS.put(rootPath, result);
            }
        }
        catch (FileNotFoundException | NumberFormatException exception) {
            LOGGER.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 %s", pathToBinFile.toFile()));
            LOGGER.debug("TRACE", (Throwable)exception);
        }
    }

    private static Map<String, Map<SupportConfiguration, SupportVariant>> read(Path pathToBinFile) throws FileNotFoundException {
        String[] dataStrings;
        HashMap<String, Map<SupportConfiguration, SupportVariant>> supportMap = new HashMap<String, Map<SupportConfiguration, SupportVariant>>();
        FileInputStream fileInputStream = new FileInputStream(pathToBinFile.toFile());
        try (Scanner scanner = new Scanner((InputStream)fileInputStream, StandardCharsets.UTF_8);){
            dataStrings = (String[])scanner.findAll(patternSplit).map(matchResult -> matchResult.group(1)).toArray(String[]::new);
        }
        int countConfiguration = Integer.parseInt(dataStrings[2]);
        LOGGER.debug("\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439: {}", (Object)countConfiguration);
        int startPoint = 3;
        for (int numberConfiguration = 1; numberConfiguration <= countConfiguration; ++numberConfiguration) {
            String configurationVersion = dataStrings[startPoint + 3];
            String configurationProducer = dataStrings[startPoint + 4];
            String configurationName = dataStrings[startPoint + 5];
            int countObjectsConfiguration = Integer.parseInt(dataStrings[startPoint + 6]);
            int configurationSupport = Integer.parseInt(dataStrings[1]);
            GeneralSupportVariant configurationSupportVariant = GeneralSupportVariant.valueOf(configurationSupport);
            SupportConfiguration supportConfiguration = new SupportConfiguration(configurationName, configurationProducer, configurationVersion);
            LOGGER.debug(String.format("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f: %s \u0412\u0435\u0440\u0441\u0438\u044f: %s \u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a: %s \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432: %s", configurationName, configurationVersion, configurationProducer, countObjectsConfiguration));
            int startObjectPoint = startPoint + 7;
            for (int numberObject = 0; numberObject < countObjectsConfiguration; ++numberObject) {
                int currentObjectPoint = startObjectPoint + numberObject * 4;
                int support = Integer.parseInt(dataStrings[currentObjectPoint]);
                String guidObject = dataStrings[currentObjectPoint + 2];
                SupportVariant supportVariant = configurationSupportVariant == GeneralSupportVariant.LOCKED ? SupportVariant.NOT_EDITABLE : SupportVariant.valueOf((int)support);
                Map map = supportMap.computeIfAbsent(guidObject, k -> new HashMap());
                map.put(supportConfiguration, supportVariant);
            }
            startPoint = startObjectPoint + 2 + countObjectsConfiguration * 4;
        }
        return supportMap;
    }

    private static Path getRootPathByParentConfigurations(Path mdoPath) {
        return Paths.get(FilenameUtils.getFullPathNoEndSeparator((String)FilenameUtils.getFullPathNoEndSeparator((String)mdoPath.toString())), new String[0]);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ParseSupportData() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

