/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.supconf;

public record SupportConfiguration(String name, String provider, String version) implements Comparable<SupportConfiguration>
{
    public SupportConfiguration(String name, String provider, String version) {
        this.name = SupportConfiguration.stripQuotes(name);
        this.provider = SupportConfiguration.stripQuotes(provider);
        this.version = SupportConfiguration.stripQuotes(version);
    }

    @Override
    public int compareTo(SupportConfiguration o) {
        if (this.name.compareTo(o.name) != 0) {
            return this.name.compareTo(o.name);
        }
        if (this.provider.compareTo(o.provider) != 0) {
            return this.provider.compareTo(o.provider);
        }
        return this.version.compareTo(o.version);
    }

    private static String stripQuotes(String value) {
        if (value == null || value.length() < 2) {
            return value;
        }
        String result = value;
        if (value.charAt(0) == '\"') {
            result = value.substring(1);
        }
        if (result.charAt(result.length() - 1) == '\"') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

