/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;

public final class Absolute {
    public static URI uri(@NonNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        try {
            URL url = new URL(uri);
            String decodedPath = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8);
            URI decodedUri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), decodedPath, url.getQuery(), url.getRef());
            return Absolute.checkFileAuthorityAndReturnURI(decodedUri);
        }
        catch (MalformedURLException | URISyntaxException e) {
            return Absolute.uri(URI.create(uri));
        }
    }

    public static URI uri(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        URI decodedUri = URI.create(uri.getScheme() + ":" + Absolute.encodePath(uri.getSchemeSpecificPart()));
        return Absolute.checkFileAuthorityAndReturnURI(decodedUri);
    }

    public static URI uri(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return Absolute.uri(Absolute.path(file).toUri());
    }

    public static Path path(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Absolute.path(Path.of(path, new String[0]));
    }

    public static Path path(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        return Absolute.path(Path.of(Absolute.uri(uri)));
    }

    public static Path path(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Absolute.path(path.toFile());
    }

    public static Path path(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return file.getCanonicalFile().toPath().toAbsolutePath();
    }

    private static String encodePath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return path.replace(" ", "%20").replace("#", "%23").replace("[", "%91").replace("]", "%93").replace("?", "%3F").replace("{", "%7B").replace("}", "%7D").replace(":", "%3A").replace("\"", "%22").replace("\\", "%5C");
    }

    private static URI checkFileAuthorityAndReturnURI(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if ("file".equals(uri.getScheme()) && uri.getAuthority() == null) {
            return Absolute.path(new File(uri)).toUri();
        }
        return uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Absolute() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

