/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.utils;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public final class Lazy<T> {
    private final Supplier<T> supplier;
    private final ReentrantLock lock;
    private volatile T value;

    public Lazy(Supplier<T> supplier) {
        this(supplier, new ReentrantLock());
    }

    public Lazy(Supplier<T> supplier, ReentrantLock lock) {
        this.supplier = supplier;
        this.lock = lock;
    }

    public T get() {
        return this.value;
    }

    public T getOrCompute(Supplier<T> supplier) {
        T result = this.value;
        if (result == null) {
            this.lock.lock();
            T localResult = this.maybeCompute(supplier);
            this.lock.unlock();
            return localResult;
        }
        return result;
    }

    public T getOrCompute() {
        return this.getOrCompute(this.supplier);
    }

    public boolean isPresent() {
        T result = this.value;
        return result != null;
    }

    public void clear() {
        this.value = null;
    }

    private T maybeCompute(Supplier<T> supplier) {
        if (this.value == null) {
            Objects.requireNonNull(supplier);
            this.value = Objects.requireNonNull(supplier.get());
        }
        return this.value;
    }
}

