/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.CRUDSPcontroller;

import com.visualization.cloud.quartz.jobService.IJobService;
import com.visualization.cloud.quartz.po.JobInfo;
import com.visualization.cloud.util.resp.ResultData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@CrossOrigin(origins={"${server.port}"})
@Controller
@RequestMapping(value={"/task/Select"})
@Tag(name="\u5b9a\u65f6\u4efb\u52a1\u4e2d\u7684\u67e5\u8be2\u64cd\u4f5c")
public class SelectController {
    private static final Logger log = LoggerFactory.getLogger(SelectController.class);
    @Resource
    private IJobService jobService;

    @PostMapping(value={"/jobs"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u4efb\u52a1", description="\u83b7\u53d6\u6240\u6709\u4efb\u52a1")
    public ResultData<List<JobInfo>> getAllJobs() throws SchedulerException {
        List<JobInfo> jobInfos = this.jobService.getAllJobs();
        System.out.println(jobInfos);
        if (!jobInfos.isEmpty()) {
            return ResultData.success(jobInfos);
        }
        return ResultData.fail("500", "No job");
    }

    @PostMapping(value={"/NoUseJob"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u672a\u4f7f\u7528\u7684job\u7c7b", description="\u83b7\u53d6\u6240\u6709\u672a\u4f7f\u7528\u7684job\u7c7b")
    public ResultData<List<JobInfo>> getAllNoUseJobs() {
        ResultData response = new ResultData();
        List<JobInfo> jobInfos = this.jobService.getAllNoUseJobs();
        System.out.println(jobInfos);
        if (!jobInfos.isEmpty()) {
            return ResultData.success(jobInfos);
        }
        return ResultData.fail("500", "No job");
    }

    @PostMapping(value={"/FINDjobBYgroup"})
    @ResponseBody
    @Operation(summary="\u6839\u636e\u5206\u7ec4\u83b7\u53d6job\u7c7b", description="\u6839\u636e\u5206\u7ec4\u83b7\u53d6job\u7c7b")
    public ResultData<List<JobInfo>> getJobByGroup(String group) {
        return ResultData.success(this.jobService.getJobByGroup(group));
    }

    @PostMapping(value={"/jobDetailname"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6job\u540d\u79f0", description="\u83b7\u53d6job\u540d\u79f0")
    public ResultData<List<String>> getJobDetail(String jobgroup) throws SchedulerException {
        return ResultData.success(this.jobService.getJobName(jobgroup));
    }

    @PostMapping(value={"/jobgroupall"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u7684job\u5206\u7ec4", description="\u83b7\u53d6\u6240\u6709\u7684job\u5206\u7ec4")
    public ResultData<List<String>> getJobGroupAll() {
        return ResultData.success(this.jobService.getJobGroupAll());
    }

    @PostMapping(value={"/triggers"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6trigger", description="\u83b7\u53d6\u6240\u6709\u7684trigger")
    public ResultData<List<JobInfo>> getAllTriggers(String triggergroup) {
        return ResultData.success(this.jobService.getAllTriggers(triggergroup));
    }

    @PostMapping(value={"/FINDtriBYjob"})
    @ResponseBody
    @Operation(summary="\u6839\u636ejob\u83b7\u53d6trigger\u7c7b", description="\u6839\u636ejob\u83b7\u53d6trigger\u7c7b")
    public ResultData<List<JobInfo>> getTriByJob(String jobname, String jobgroup) {
        return ResultData.success(this.jobService.getTriByJob(jobname, jobgroup));
    }

    @PostMapping(value={"/triggergroupall"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u7684trigger\u5206\u7ec4", description="\u83b7\u53d6\u6240\u6709\u7684trigger\u5206\u7ec4")
    public ResultData<List<String>> getTriggerGroupAll() {
        return ResultData.success(this.jobService.getTriggerGroupAll());
    }

    @PostMapping(value={"/Triggername"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6Trigger\u540d\u79f0", description="\u83b7\u53d6Trigger\u540d\u79f0")
    public ResultData<List<String>> getTrigger(String triggergroup) throws SchedulerException {
        return ResultData.success(this.jobService.getTriggerName(triggergroup));
    }

    @PostMapping(value={"/triggerDetail"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6trigger\u8be6\u60c5", description="\u83b7\u53d6trigger\u8be6\u60c5")
    public ResultData<JobInfo> getTriggerDetail(String triggername, String triggergroup) throws SchedulerException {
        return ResultData.success(this.jobService.getTriggerInfo(triggername, triggergroup));
    }

    @PostMapping(value={"/nextFireTime"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u65f6\u95f4\u5f00\u59cb\u7684\u4e0b\u6b21\u89e6\u53d1\u65f6\u95f4", description="\u83b7\u53d6\u6307\u5b9a\u65f6\u95f4\u5f00\u59cb\u7684\u4e0b\u6b21\u89e6\u53d1\u65f6\u95f4")
    public ResultData<String> getNextFireTime(String triggername, String triggergroup, String specifiedtime) throws SchedulerException {
        System.out.println(specifiedtime);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(specifiedtime, formatter);
        Date specifiedTime = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        System.out.println(specifiedTime);
        return ResultData.success(this.jobService.getNextFireTime(triggername, triggergroup, specifiedTime));
    }

    @PostMapping(value={"/isAllPaused"})
    @ResponseBody
    @Operation(summary="\u5224\u65ad\u662f\u5426\u5168\u90e8\u6682\u505c", description="\u5224\u65ad\u662f\u5426\u5168\u90e8\u6682\u505c")
    public ResultData<Boolean> isAllPaused() throws SchedulerException {
        return ResultData.success(this.jobService.isAllPaused());
    }
}

