/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.Function.QuartzConfigVisualization;

import com.visualization.cloud.quartz.Function.QuartzConfigVisualization.AllQuartzProperties;
import com.visualization.cloud.quartz.Function.QuartzConfigVisualization.QuartzPropertiesCreateFactor;
import com.visualization.cloud.quartz.Function.QuartzConfigVisualization.SchedulerMigrator;
import com.visualization.cloud.quartz.config.SpringContextHolder;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/quartzConfig"})
public class Controller {
    private final SchedulerMigrator schedulerMigrator = new SchedulerMigrator();
    @Autowired
    private ContextRefresher contextRefresher;
    private static AllQuartzProperties.SchedulerProperties schedulerProperties = SpringContextHolder.getBean(AllQuartzProperties.SchedulerProperties.class);
    private static AllQuartzProperties.ThreadPoolProperties threadPoolProperties = SpringContextHolder.getBean(AllQuartzProperties.ThreadPoolProperties.class);
    private static AllQuartzProperties.JobStoreProperties jobStoreProperties = SpringContextHolder.getBean(AllQuartzProperties.JobStoreProperties.class);
    private static AllQuartzProperties.DataSourceProperties dataSourceProperties = SpringContextHolder.getBean(AllQuartzProperties.DataSourceProperties.class);
    private static AllQuartzProperties.PluginProperties pluginProperties = SpringContextHolder.getBean(AllQuartzProperties.PluginProperties.class);
    private static AllQuartzProperties.TriggerListener triggerListener = SpringContextHolder.getBean(AllQuartzProperties.TriggerListener.class);
    private static AllQuartzProperties.JobListener jobListener = SpringContextHolder.getBean(AllQuartzProperties.JobListener.class);

    @GetMapping(value={"/saveQuartzProperties"})
    @ResponseBody
    public void saveQuartzProperties(HttpServletResponse response) throws IOException {
        Properties pro = QuartzPropertiesCreateFactor.createQuartzPropertiesCreate();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=quartz.properties");
        try (ServletOutputStream out = response.getOutputStream();){
            pro.store((OutputStream)out, "\u914d\u7f6e\u6587\u4ef6");
        }
    }

    @PostMapping(value={"/updateschedulerProperties"})
    @ResponseBody
    public void updateschedulerProperties(@RequestBody AllQuartzProperties.SchedulerProperties schedulerPropertiesTO) throws Exception {
        schedulerProperties.setInstanceName(schedulerPropertiesTO.getInstanceName());
        this.schedulerMigrator.hotReload("org.quartz.scheduler-", schedulerPropertiesTO);
    }

    @PostMapping(value={"/updatethreadPoolProperties"})
    @ResponseBody
    public void updatethreadPoolProperties(@RequestBody AllQuartzProperties.ThreadPoolProperties threadPoolPropertiesTO) throws Exception {
        threadPoolProperties = threadPoolPropertiesTO;
        this.schedulerMigrator.hotReload("org.quartz.threadpool-", threadPoolPropertiesTO);
    }

    @PostMapping(value={"/updatejobStoreProperties"})
    @ResponseBody
    public void updatejobStoreProperties(@RequestBody AllQuartzProperties.JobStoreProperties jobStorePropertiesTO) throws Exception {
        jobStoreProperties = jobStorePropertiesTO;
        this.schedulerMigrator.hotReload("org.quartz.jobstore-", jobStorePropertiesTO);
    }

    @PostMapping(value={"/updatedataSourceProperties"})
    @ResponseBody
    public void updatedataSourceProperties(@RequestBody AllQuartzProperties.DataSourceProperties dataSourcePropertiesTO) throws Exception {
        dataSourceProperties = dataSourcePropertiesTO;
        this.schedulerMigrator.hotReload("org.quartz.datasource-", dataSourcePropertiesTO);
    }

    @PostMapping(value={"/updatepluginProperties"})
    @ResponseBody
    public void updatepluginProperties(@RequestBody AllQuartzProperties.PluginProperties pluginPropertiesTO) throws Exception {
        pluginProperties = pluginPropertiesTO;
        this.schedulerMigrator.hotReload("org.quartz.plugin-", pluginPropertiesTO);
    }

    @PostMapping(value={"/updatetriggerListener"})
    @ResponseBody
    public void updatetriggerListener(@RequestBody AllQuartzProperties.TriggerListener triggerListenerTO) throws Exception {
        triggerListener = triggerListenerTO;
        this.schedulerMigrator.hotReload("org.quartz.triggerlistener-", triggerListenerTO);
    }

    @PostMapping(value={"/updatejobListener"})
    @ResponseBody
    public void updatejobListener(@RequestBody AllQuartzProperties.JobListener jobListenerTO) throws Exception {
        jobListener = jobListenerTO;
        this.schedulerMigrator.hotReload("org.quartz.joblistener-", jobListenerTO);
    }

    @GetMapping(value={"/schedulerProperties"})
    @ResponseBody
    public AllQuartzProperties.SchedulerProperties getschedulerProperties() {
        return schedulerProperties;
    }

    @GetMapping(value={"/threadPoolProperties"})
    @ResponseBody
    public AllQuartzProperties.ThreadPoolProperties getthreadPoolProperties() {
        return threadPoolProperties;
    }

    @GetMapping(value={"/jobStoreProperties"})
    @ResponseBody
    public AllQuartzProperties.JobStoreProperties getjobStoreProperties() {
        return jobStoreProperties;
    }

    @GetMapping(value={"/dataSourceProperties"})
    @ResponseBody
    public AllQuartzProperties.DataSourceProperties getdataSourceProperties() {
        return dataSourceProperties;
    }

    @GetMapping(value={"/pluginProperties"})
    @ResponseBody
    public AllQuartzProperties.PluginProperties getpluginProperties() {
        return pluginProperties;
    }

    @GetMapping(value={"/triggerListener"})
    @ResponseBody
    public AllQuartzProperties.TriggerListener gettriggerListener() {
        return triggerListener;
    }

    @GetMapping(value={"/jobListener"})
    @ResponseBody
    public AllQuartzProperties.JobListener getjobListener() {
        return jobListener;
    }

    @GetMapping(value={"/getgroup"})
    @ResponseBody
    public String getall() {
        return List.of("jobListener", "triggerListener", "pluginProperties", "dataSourceProperties", "jobStoreProperties", "threadPoolProperties", "schedulerProperties").toString();
    }
}

