/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.Function.QuartzConfigVisualization;

import com.visualization.cloud.quartz.Function.QuartzConfigVisualization.QuartzPropertiesCreateFactor;
import com.visualization.cloud.quartz.config.SpringContextHolder;
import java.util.Properties;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class SchedulerMigrator {
    @Autowired
    private DataSource dataSource;

    public <T> void hotReload(String prefix, T config) throws Exception {
        SchedulerFactoryBean oldFactory = SpringContextHolder.getBean(SchedulerFactoryBean.class);
        oldFactory.getScheduler().shutdown(true);
        oldFactory.destroy();
        Properties quartzProperties = QuartzPropertiesCreateFactor.createQuartzPropertiesCreate();
        SchedulerFactoryBean newFactory = new SchedulerFactoryBean();
        newFactory.setDataSource(this.dataSource);
        newFactory.setQuartzProperties(quartzProperties);
        newFactory.setOverwriteExistingJobs(true);
        newFactory.afterPropertiesSet();
        newFactory.start();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)SpringContextHolder.context.getAutowireCapableBeanFactory();
        beanFactory.destroySingleton("schedulerFactoryBean");
        beanFactory.registerSingleton("schedulerFactoryBean", (Object)newFactory);
        Scheduler scheduler = newFactory.getScheduler();
        beanFactory.destroySingleton("scheduler");
        beanFactory.registerSingleton("scheduler", (Object)scheduler);
        beanFactory.destroySingleton(prefix + config.getClass().getName());
        beanFactory.registerSingleton(prefix + config.getClass().getName(), config);
        Object config1 = SpringContextHolder.getBean(config.getClass());
        System.out.println(QuartzPropertiesCreateFactor.createQuartzPropertiesCreate());
        System.out.println(config1);
    }
}

