/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.Utilcontroller;

import com.visualization.cloud.util.resp.ResultData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@CrossOrigin(origins={"${server.port}"})
@Controller
@RequestMapping(value={"/task/Util"})
@Tag(name="\u5b9a\u65f6\u4efb\u52a1\u4e2d\u7684\u5de5\u5177\u65b9\u6cd5")
public class UtilController {
    private static final Logger log = LoggerFactory.getLogger(UtilController.class);

    @PostMapping(value={"/cron-check"})
    @ResponseBody
    @Operation(summary="\u6821\u9a8ccron\u8868\u8fbe\u5f0f", description="\u6821\u9a8ccron\u8868\u8fbe\u5f0f")
    public ResultData<Boolean> checkCron(String cron) {
        boolean valid = false;
        try {
            valid = CronExpression.isValidExpression((String)cron);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return ResultData.fail("500", "cron\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (valid) {
            return ResultData.success(true);
        }
        return ResultData.fail("500", "cron\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff01");
    }

    @PostMapping(value={"/getType"})
    @ResponseBody
    @Operation(summary="\u83b7\u53d6\u7c7b\u578b", description="\u83b7\u53d6\u7c7b\u578b")
    public ResultData<String> getType() {
        return ResultData.success("SimpleTrigger, CronTrigger, DailyTimeIntervalTrigger, CalendarIntervalTrigger");
    }
}

