/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.config;

import com.visualization.cloud.quartz.config.SpringContextHolder;
import groovy.lang.GroovyClassLoader;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.LoadingLoaderClassLoadHelper;
import org.quartz.simpl.SimpleClassLoadHelper;
import org.quartz.simpl.ThreadContextClassLoadHelper;
import org.quartz.spi.ClassLoadHelper;

public class CascadingClassLoadHelper
implements ClassLoadHelper {
    private LinkedList<ClassLoadHelper> loadHelpers;
    private ClassLoadHelper bestCandidate;
    private GroovyClassLoader groovyClassLoader;

    @PostConstruct
    public void initialize() {
        this.loadHelpers = new LinkedList();
        System.out.println("groovyClassLoader: " + String.valueOf(this.groovyClassLoader));
        this.groovyClassLoader = SpringContextHolder.getBean(GroovyClassLoader.class);
        this.loadHelpers.add(new GroovyClassLoadHelperWrapper(this.groovyClassLoader));
        this.loadHelpers.add((ClassLoadHelper)new LoadingLoaderClassLoadHelper());
        this.loadHelpers.add((ClassLoadHelper)new SimpleClassLoadHelper());
        this.loadHelpers.add((ClassLoadHelper)new ThreadContextClassLoadHelper());
        this.loadHelpers.add((ClassLoadHelper)new InitThreadContextClassLoadHelper());
        for (ClassLoadHelper loadHelper : this.loadHelpers) {
            loadHelper.initialize();
        }
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.loadClass(name);
            }
            catch (Throwable t) {
                this.bestCandidate = null;
            }
        }
        Throwable throwable = null;
        Class clazz = null;
        ClassLoadHelper loadHelper2 = null;
        for (ClassLoadHelper loadHelper2 : this.loadHelpers) {
            try {
                clazz = loadHelper2.loadClass(name);
                break;
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (clazz == null) {
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            throw new ClassNotFoundException(String.format("Unable to load class %s by any known loaders.", name), throwable);
        }
        this.bestCandidate = loadHelper2;
        return clazz;
    }

    public <T> Class<? extends T> loadClass(String name, Class<T> clazz) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    public URL getResource(String name) {
        if (this.bestCandidate != null) {
            URL result = this.bestCandidate.getResource(name);
            if (result != null) {
                return result;
            }
            this.bestCandidate = null;
        }
        ClassLoadHelper loadHelper = null;
        URL result = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResource(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public InputStream getResourceAsStream(String name) {
        if (this.bestCandidate != null) {
            InputStream result = this.bestCandidate.getResourceAsStream(name);
            if (result != null) {
                return result;
            }
            this.bestCandidate = null;
        }
        ClassLoadHelper loadHelper = null;
        InputStream result = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResourceAsStream(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.bestCandidate != null ? this.bestCandidate.getClassLoader() : this.groovyClassLoader;
    }

    private static class GroovyClassLoadHelperWrapper
    implements ClassLoadHelper {
        private final GroovyClassLoader groovyClassLoader;

        public GroovyClassLoadHelperWrapper(GroovyClassLoader loader) {
            System.out.println("loader: " + String.valueOf(loader));
            this.groovyClassLoader = loader;
        }

        public void initialize() {
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.groovyClassLoader.loadClass(name);
        }

        public <T> Class<? extends T> loadClass(String name, Class<T> clazz) throws ClassNotFoundException {
            return this.groovyClassLoader.loadClass(name).asSubclass(clazz);
        }

        public URL getResource(String name) {
            return this.groovyClassLoader.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            return this.groovyClassLoader.getResourceAsStream(name);
        }

        public ClassLoader getClassLoader() {
            return this.groovyClassLoader;
        }
    }
}

