/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.config;

import com.visualization.cloud.quartz.Function.QuartzConfigVisualization.QuartzPropertiesCreateFactor;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class SchedulerConfig {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public Scheduler scheduler() throws IOException, SchedulerException {
        return this.schedulerFactoryBean().getScheduler();
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() throws IOException {
        SchedulerFactoryBean factory = new SchedulerFactoryBean();
        factory.setSchedulerName("cluster_scheduler");
        factory.setDataSource(this.dataSource);
        factory.setApplicationContextSchedulerContextKey("applicationContextKey");
        factory.setTaskExecutor(this.schedulerThreadPool());
        factory.setResourceLoader((ResourceLoader)this.applicationContext);
        factory.setQuartzProperties(QuartzPropertiesCreateFactor.createQuartzPropertiesCreate());
        System.out.println("createQuartzPropertiesCreate()" + String.valueOf(QuartzPropertiesCreateFactor.createQuartzPropertiesCreate()));
        return factory;
    }

    @Bean
    public Executor schedulerThreadPool() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(Runtime.getRuntime().availableProcessors());
        taskExecutor.setMaxPoolSize(Runtime.getRuntime().availableProcessors());
        taskExecutor.setQueueCapacity(Runtime.getRuntime().availableProcessors());
        return taskExecutor;
    }
}

