/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.jobService;

import cn.hutool.core.util.StrUtil;
import com.visualization.cloud.quartz.Function.DelayedQueue.DelayedJob;
import com.visualization.cloud.quartz.Function.DelayedQueue.MyQuartzJobWrapper;
import com.visualization.cloud.quartz.config.SpringContextHolder;
import com.visualization.cloud.quartz.jobService.IJobService;
import com.visualization.cloud.quartz.po.CreatJobDetail;
import com.visualization.cloud.quartz.po.JobInfo;
import com.visualization.cloud.quartz.po.TriggerAbstract;
import com.visualization.cloud.scriptBuilder.datahandling.VScriptTagScervice;
import com.visualization.cloud.util.DynamicBeanOperate;
import jakarta.annotation.Resource;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.quartz.CalendarIntervalScheduleBuilder;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class JobServiceImp
implements IJobService {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImp.class);
    @Resource
    private DynamicBeanOperate dynamicBeanOperate;
    @Resource
    private VScriptTagScervice vScriptTagScervice;
    private String TRIGGER_GROUP_NAME = "DefaultJobDetail";
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private ApplicationContext applicationContext;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat sdfsfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public int isJobExist(JobKey jobKey) {
        int result = 1;
        try {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            List triggers = this.scheduler.getTriggersOfJob(jobKey);
            result = jobDetail != null && triggers.size() > 0 ? triggers.size() : -1;
        }
        catch (SchedulerException e) {
            result = -1;
            log.info("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        return result;
    }

    @Override
    public List<JobInfo> getAllJobs() throws SchedulerException {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        try {
            List groups = this.scheduler.getJobGroupNames();
            boolean i = false;
            for (String group : groups) {
                GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)group);
                Set jobKeys = this.scheduler.getJobKeys(groupMatcher);
                for (JobKey jobKey : jobKeys) {
                    System.out.println("\u5206\u9694\u7b26");
                    System.out.println(jobKey.getName());
                    System.out.println("\u5206\u5272\u7b26");
                    List list_Tri = this.scheduler.getTriggersOfJob(jobKey);
                    JobInfo jobInfo = new JobInfo();
                    JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                    jobInfo.setJobDetail(this.vScriptTagScervice.getScriptId(jobKey.getName(), jobKey.getGroup(), "JobDetail"));
                    jobInfo.setJobname(jobKey.getName());
                    jobInfo.setJobgroup(jobKey.getGroup());
                    jobInfo.setJobclassname(Arrays.stream(jobDetail.getJobClass().getName().split("\\.")).reduce((first, second) -> second).orElse("\u8fd4\u56de\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a"));
                    jobInfo.setDescription(jobDetail.getDescription());
                    jobInfo.setTriggersNumbers(list_Tri.size());
                    jobInfos.add(jobInfo);
                }
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return jobInfos;
    }

    @Override
    public List<JobInfo> getAllNoUseJobs() {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        try {
            List groups = this.scheduler.getJobGroupNames();
            System.out.println(1);
            System.out.println(this.scheduler.getCurrentlyExecutingJobs());
            boolean i = false;
            for (String group : groups) {
                GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)group);
                Set jobKeys = this.scheduler.getJobKeys(groupMatcher);
                for (JobKey jobKey : jobKeys) {
                    List list_Tri = this.scheduler.getTriggersOfJob(jobKey);
                    if (list_Tri.size() != 0) continue;
                    JobInfo jobInfo = new JobInfo();
                    JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                    jobDetail.getJobDataMap();
                    jobInfo.setJobname(jobKey.getName());
                    jobInfo.setJobgroup(jobKey.getGroup());
                    jobInfo.setJobclassname(Arrays.stream(jobDetail.getJobClass().getName().split("\\.")).reduce((first, second) -> second).orElse("\u8fd4\u56de\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a"));
                    jobInfos.add(jobInfo);
                }
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return jobInfos;
    }

    @Override
    public List<JobInfo> getJobByGroup(String jobGroup) {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        try {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobGroup);
            Set jobKeys = this.scheduler.getJobKeys(groupMatcher);
            for (JobKey jobKey : jobKeys) {
                JobInfo jobInfo = new JobInfo();
                List list_Tri = this.scheduler.getTriggersOfJob(jobKey);
                jobInfo.setTriggersNumbers(list_Tri.size());
                JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                jobInfo.setJobname(jobKey.getName());
                jobInfo.setJobgroup(jobKey.getGroup());
                jobInfo.setJobDetail(this.vScriptTagScervice.getScriptId(jobKey.getName(), jobKey.getGroup(), "JobDetail"));
                jobInfo.setJobclassname(Arrays.stream(jobDetail.getJobClass().getName().split("\\.")).reduce((first, second) -> second).orElse("\u8fd4\u56de\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a"));
                jobInfo.setDescription(jobDetail.getDescription());
                jobInfos.add(jobInfo);
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return jobInfos;
    }

    @Override
    public List<String> getJobName(String jobGroup) throws SchedulerException {
        Set jobKeys;
        ArrayList<String> jobNames = new ArrayList<String>();
        if (jobGroup == null) {
            jobKeys = this.scheduler.getJobKeys(GroupMatcher.anyGroup());
        } else {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobGroup);
            jobKeys = this.scheduler.getJobKeys(groupMatcher);
        }
        for (JobKey jobKey : jobKeys) {
            jobNames.add(jobKey.getName());
        }
        return jobNames;
    }

    @Override
    public List<String> getJobGroupAll() {
        ArrayList<String> jobGroups = new ArrayList();
        try {
            jobGroups = this.scheduler.getJobGroupNames();
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return jobGroups;
    }

    @Override
    public List<JobInfo> getTriByJob(String jobName, String jobGroup) {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            List triggers = this.scheduler.getTriggersOfJob(jobKey);
            int i = 0;
            for (Trigger trigger : triggers) {
                Trigger.TriggerState jState;
                Trigger.TriggerState tState;
                String regex = ".*resumeNow$";
                if (trigger.getKey().getName().matches(regex) && trigger.getKey().getGroup().matches(regex)) {
                    System.out.println("\u6b63\u5728\u6267\u884c");
                    continue;
                }
                JobInfo jobInfo = new JobInfo();
                JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                jobInfo.setType(Arrays.stream(trigger.getClass().getName().split("\\.")).reduce((first, second) -> second).map(str -> str.length() > 4 ? str.substring(0, str.length() - 4) : str).orElse("\u8fd4\u56de\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a"));
                jobInfo.setStartime(sdf.format(trigger.getStartTime()));
                jobInfo.setEndtime(sdf.format(trigger.getEndTime()));
                jobInfo.setTriggername(trigger.getKey().getName());
                jobInfo.setTriggergroup(trigger.getKey().getGroup());
                jobInfo.setJobDetail(jobDetail.getClass().toString());
                jobInfo.setTrigger(trigger.getClass().toString());
                jobInfo.setPriority(String.valueOf(trigger.getPriority()));
                if (trigger.getPreviousFireTime() == null) {
                    jobInfo.setPreviousFireTime(null);
                } else {
                    jobInfo.setPreviousFireTime(sdfsfs.format(trigger.getPreviousFireTime()));
                }
                if (trigger.getNextFireTime() != null) {
                    if (trigger.getNextFireTime().before(new Date(System.currentTimeMillis()))) {
                        jobInfo.setNextFireTime(null);
                    } else {
                        jobInfo.setNextFireTime(sdfsfs.format(trigger.getNextFireTime()));
                    }
                    long remainingTime = (trigger.getNextFireTime().getTime() - new Date(System.currentTimeMillis()).getTime()) / 1000L;
                    if (remainingTime < 0L) {
                        jobInfo.setRemainingTime(null);
                    } else {
                        jobInfo.setRemainingTime(String.valueOf(remainingTime));
                    }
                }
                if (trigger.getFinalFireTime() == null) {
                    jobInfo.setFinalFireTime(null);
                } else {
                    jobInfo.setFinalFireTime(sdfsfs.format(trigger.getFinalFireTime()));
                }
                jobInfo.setMisfireInstruction(String.valueOf(trigger.getMisfireInstruction()));
                jobInfo.setIsConcurrentExectionDisallowed(String.valueOf(jobDetail.isConcurrentExectionDisallowed()));
                if (trigger.getClass().equals(SimpleTriggerImpl.class)) {
                    System.out.println("SimpleTrigger");
                    SimpleTriggerImpl TriggerImpl = (SimpleTriggerImpl)trigger;
                    Trigger jobTrigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
                    Trigger.TriggerState tState2 = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
                    Trigger.TriggerState jState2 = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
                    jobInfo.setTriggers_state(tState2.name());
                    jobInfo.setJob_state(jState2.name());
                    jobInfo.setSimpletimesecond(String.valueOf(TriggerImpl.getRepeatInterval()));
                    jobInfo.setRepeatcount(String.valueOf(TriggerImpl.getRepeatCount()));
                    jobInfo.setId(i);
                    ++i;
                    jobInfos.add(jobInfo);
                    continue;
                }
                if (trigger.getClass().equals(CronTriggerImpl.class)) {
                    System.out.println("CronTriggerImpl");
                    CronTriggerImpl TriggerImpl = (CronTriggerImpl)trigger;
                    tState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
                    jState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
                    jobInfo.setTriggers_state(tState.name());
                    jobInfo.setJob_state(jState.name());
                    jobInfo.setCronexpression(TriggerImpl.getCronExpression());
                    jobInfo.setId(i);
                    ++i;
                    jobInfos.add(jobInfo);
                    continue;
                }
                if (trigger.getClass().equals(CalendarIntervalTriggerImpl.class)) {
                    System.out.println("CalendarIntervalTriggerImpl");
                    CalendarIntervalTriggerImpl TriggerImpl = (CalendarIntervalTriggerImpl)trigger;
                    tState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
                    jState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
                    jobInfo.setTriggers_state(tState.name());
                    jobInfo.setJob_state(jState.name());
                    jobInfo.setCalendartime(TriggerImpl.getRepeatIntervalUnit().name());
                    jobInfo.setCalendarnum(String.valueOf(TriggerImpl.getRepeatInterval()));
                    jobInfo.setPreserveHourOfDayAcrossDaylightSavings(String.valueOf(TriggerImpl.isPreserveHourOfDayAcrossDaylightSavings()));
                    jobInfo.setSkipDayIfHourDoesNotExist(String.valueOf(TriggerImpl.isSkipDayIfHourDoesNotExist()));
                    jobInfo.setTimezone(TriggerImpl.getTimeZone().getID());
                    jobInfo.setId(i);
                    ++i;
                    jobInfos.add(jobInfo);
                    continue;
                }
                if (trigger.getClass().equals(DailyTimeIntervalTriggerImpl.class)) {
                    System.out.println("DailyTimeIntervalTriggerImpl");
                    DailyTimeIntervalTriggerImpl TriggerImpl = (DailyTimeIntervalTriggerImpl)trigger;
                    tState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
                    jState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
                    jobInfo.setTriggers_state(tState.name());
                    jobInfo.setJob_state(jState.name());
                    jobInfo.setDailytime(TriggerImpl.getRepeatIntervalUnit().name());
                    jobInfo.setDailynum(String.valueOf(TriggerImpl.getRepeatInterval()));
                    jobInfo.setDailyrepeatcount(String.valueOf(TriggerImpl.getRepeatCount()));
                    Set daysOfWeek = TriggerImpl.getDaysOfWeek();
                    Set<String> daysOfWeekString = daysOfWeek.stream().map(String::valueOf).collect(Collectors.toSet());
                    jobInfo.setDailyworkday(daysOfWeekString);
                    jobInfo.setId(i);
                    ++i;
                    jobInfos.add(jobInfo);
                    continue;
                }
                System.out.println(triggers.getClass());
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return jobInfos;
    }

    @Override
    public List<JobInfo> getAllTriggers(String triggerGroup) {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        try {
            Set triggerKeys;
            if (triggerGroup == null) {
                triggerKeys = this.scheduler.getTriggerKeys(GroupMatcher.anyGroup());
            } else {
                GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)triggerGroup);
                triggerKeys = this.scheduler.getTriggerKeys(groupMatcher);
            }
            for (TriggerKey triggerKey : triggerKeys) {
                JobInfo jobInfo = new JobInfo();
                Trigger trigger = this.scheduler.getTrigger(triggerKey);
                jobInfo.setTriggername(triggerKey.getName());
                jobInfo.setTriggergroup(triggerKey.getGroup());
                jobInfo.setTrigger(this.vScriptTagScervice.getScriptId(triggerKey.getName(), triggerKey.getGroup(), jobInfo.getType()));
                jobInfo.setType(Arrays.stream(trigger.getClass().getName().split("\\.")).reduce((first, second) -> second).map(str -> str.length() > 4 ? str.substring(0, str.length() - 4) : str).orElse("\u8fd4\u56de\u7684\u5b57\u7b26\u4e32\u4e3a\u7a7a"));
                jobInfo.setStartime(sdf.format(trigger.getStartTime()));
                if (trigger.getEndTime() == null) {
                    jobInfo.setEndtime(null);
                } else {
                    jobInfo.setEndtime(sdf.format(trigger.getEndTime()));
                }
                jobInfo.setTriggers_state(this.scheduler.getTriggerState(triggerKey).name());
                jobInfo.setPriority(String.valueOf(trigger.getPriority()));
                jobInfos.add(jobInfo);
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return jobInfos;
    }

    @Override
    public List<String> getTriggerGroupAll() {
        ArrayList<String> triggerGroups = new ArrayList();
        try {
            triggerGroups = this.scheduler.getTriggerGroupNames();
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return triggerGroups;
    }

    @Override
    public List<JobInfo> getTriggerByGroup(String triggerGroup) {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        try {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)triggerGroup);
            Set triggerKeys = this.scheduler.getTriggerKeys(groupMatcher);
            for (TriggerKey triggerKey : triggerKeys) {
                JobInfo jobInfo = new JobInfo();
                Trigger trigger = this.scheduler.getTrigger(triggerKey);
                jobInfo.setTriggername(triggerKey.getName());
                jobInfo.setTriggergroup(triggerKey.getGroup());
                jobInfos.add(jobInfo);
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        return jobInfos;
    }

    @Override
    public List<String> getTriggerName(String triggerGroup) throws SchedulerException {
        Set triggerKeys;
        ArrayList<String> triggerNames = new ArrayList<String>();
        if (triggerGroup == null) {
            triggerKeys = this.scheduler.getTriggerKeys(GroupMatcher.anyGroup());
        } else {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)triggerGroup);
            triggerKeys = this.scheduler.getTriggerKeys(groupMatcher);
        }
        for (TriggerKey triggerKey : triggerKeys) {
            triggerNames.add(triggerKey.getName());
        }
        return triggerNames;
    }

    @Override
    public JobInfo getTriggerInfo(String triggername, String triggergroup) throws SchedulerException {
        JobInfo jobInfo = new JobInfo();
        System.out.println(jobInfo.getStartime());
        JobKey jobKey = JobKey.jobKey((String)triggername, (String)triggergroup);
        Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        if (trigger == null) {
            return null;
        }
        JobDetail jobDetail = this.scheduler.getJobDetail(trigger.getJobKey());
        if (trigger.getPreviousFireTime() == null) {
            jobInfo.setPreviousFireTime(null);
        } else {
            jobInfo.setPreviousFireTime(sdfsfs.format(trigger.getPreviousFireTime()));
        }
        jobInfo.setTrigger(this.vScriptTagScervice.getScriptId(triggername, triggergroup, jobInfo.getType()));
        if (trigger.getNextFireTime() != null) {
            if (trigger.getNextFireTime().before(new Date(System.currentTimeMillis()))) {
                jobInfo.setNextFireTime(null);
            } else {
                jobInfo.setNextFireTime(sdfsfs.format(trigger.getNextFireTime()));
            }
            long remainingTime = (trigger.getNextFireTime().getTime() - new Date(System.currentTimeMillis()).getTime()) / 1000L;
            if (remainingTime < 0L) {
                jobInfo.setRemainingTime(null);
            } else {
                jobInfo.setRemainingTime(String.valueOf(remainingTime));
            }
        }
        if (trigger.getFinalFireTime() == null) {
            System.out.println("\u6ca1\u6709\u6700\u7ec8\u89e6\u53d1\u65f6\u95f4");
            jobInfo.setFinalFireTime(null);
        } else {
            jobInfo.setFinalFireTime(sdfsfs.format(trigger.getFinalFireTime()));
        }
        jobInfo.setMisfireInstruction(String.valueOf(trigger.getMisfireInstruction()));
        jobInfo.setIsConcurrentExectionDisallowed(String.valueOf(jobDetail.isConcurrentExectionDisallowed()));
        if (trigger.getClass().equals(SimpleTriggerImpl.class)) {
            System.out.println("SimpleTrigger");
            SimpleTriggerImpl TriggerImpl = (SimpleTriggerImpl)trigger;
            Trigger jobTrigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
            Trigger.TriggerState tState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
            Trigger.TriggerState jState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
            jobInfo.setTriggers_state(tState.name());
            jobInfo.setJob_state(jState.name());
            jobInfo.setSimpletimesecond(String.valueOf(TriggerImpl.getRepeatInterval()));
            jobInfo.setRepeatcount(String.valueOf(TriggerImpl.getRepeatCount()));
        } else if (trigger.getClass().equals(CronTriggerImpl.class)) {
            System.out.println("CronTriggerImpl");
            CronTriggerImpl TriggerImpl = (CronTriggerImpl)trigger;
            Trigger.TriggerState tState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
            Trigger.TriggerState jState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
            jobInfo.setTriggers_state(tState.name());
            jobInfo.setJob_state(jState.name());
            jobInfo.setCronexpression(TriggerImpl.getCronExpression());
        } else if (trigger.getClass().equals(CalendarIntervalTriggerImpl.class)) {
            System.out.println("CalendarIntervalTriggerImpl");
            CalendarIntervalTriggerImpl TriggerImpl = (CalendarIntervalTriggerImpl)trigger;
            Trigger.TriggerState tState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
            Trigger.TriggerState jState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
            jobInfo.setCalendartime(TriggerImpl.getRepeatIntervalUnit().name());
            jobInfo.setCalendarnum(String.valueOf(TriggerImpl.getRepeatInterval()));
            jobInfo.setPreserveHourOfDayAcrossDaylightSavings(String.valueOf(TriggerImpl.isPreserveHourOfDayAcrossDaylightSavings()));
            jobInfo.setSkipDayIfHourDoesNotExist(String.valueOf(TriggerImpl.isSkipDayIfHourDoesNotExist()));
            jobInfo.setTimezone(TriggerImpl.getTimeZone().getID());
        } else if (trigger.getClass().equals(DailyTimeIntervalTriggerImpl.class)) {
            System.out.println("DailyTimeIntervalTriggerImpl");
            DailyTimeIntervalTriggerImpl TriggerImpl = (DailyTimeIntervalTriggerImpl)trigger;
            Trigger.TriggerState tState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)TriggerImpl.getName(), (String)TriggerImpl.getGroup()));
            Trigger.TriggerState jState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobKey.getName(), (String)jobKey.getGroup()));
            jobInfo.setDailystarttime(TriggerImpl.getStartTimeOfDay().getHour() + ":" + TriggerImpl.getStartTimeOfDay().getMinute() + ":" + TriggerImpl.getStartTimeOfDay().getSecond());
            jobInfo.setDailyendtime(TriggerImpl.getEndTimeOfDay().getHour() + ":" + TriggerImpl.getEndTimeOfDay().getMinute() + ":" + TriggerImpl.getEndTimeOfDay().getSecond());
            jobInfo.setDailytime(TriggerImpl.getRepeatIntervalUnit().name());
            jobInfo.setDailynum(String.valueOf(TriggerImpl.getRepeatInterval()));
            jobInfo.setDailyrepeatcount(String.valueOf(TriggerImpl.getRepeatCount()));
            Set daysOfWeek = TriggerImpl.getDaysOfWeek();
            Set<String> daysOfWeekString = daysOfWeek.stream().map(String::valueOf).collect(Collectors.toSet());
            jobInfo.setDailyworkday(daysOfWeekString);
        } else {
            System.out.println(trigger.getClass());
        }
        System.out.println(jobInfo.getStartime());
        return jobInfo;
    }

    @Override
    public String getNextFireTime(String triggername, String triggergroup, java.util.Date specifiedTime) throws SchedulerException {
        System.out.println(triggername + " " + triggergroup);
        boolean a = this.scheduler.checkExists(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        if (!a) {
            return "Trigger\u4e0d\u5b58\u5728\u6216\u8005\u5904\u4e8e\u6682\u505c\u72b6\u6001";
        }
        try {
            Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
            java.util.Date startTime = trigger.getStartTime();
            java.util.Date endTime = trigger.getEndTime();
            if (startTime.after(specifiedTime)) {
                return "\u6307\u5b9a\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4\u5f00\u59cb\u65f6\u95f4\u4e3a" + String.valueOf(startTime);
            }
            if (endTime.before(specifiedTime)) {
                return "\u6307\u5b9a\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u4e3a" + String.valueOf(endTime);
            }
            java.util.Date nextFireTime = trigger.getFireTimeAfter(specifiedTime);
            if (nextFireTime == null) {
                return "\u6ca1\u6709\u4e0b\u4e00\u6b21\u89e6\u53d1\u65f6\u95f4";
            }
            SimpleDateFormat sfm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sfm.format(nextFireTime);
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return e.getMessage();
        }
    }

    @Override
    public boolean isAllPaused() throws SchedulerException {
        Set triggerGroups = this.scheduler.getPausedTriggerGroups();
        System.out.println(triggerGroups.contains("_$_ALL_GROUPS_PAUSED_$_"));
        return triggerGroups.contains("_$_ALL_GROUPS_PAUSED_$_");
    }

    @Override
    public boolean resumeJob(String jobName, String jobGroup) throws SchedulerException {
        boolean result = true;
        boolean a = this.scheduler.checkExists(JobKey.jobKey((String)jobName, (String)jobGroup));
        if (!a) {
            return false;
        }
        try {
            this.scheduler.resumeJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            result = false;
            log.error(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean resumeTri(String triggername, String triggergroup) throws SchedulerException {
        boolean result = true;
        boolean a = this.scheduler.checkExists(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        if (!a) {
            return false;
        }
        try {
            this.scheduler.resumeTrigger(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        }
        catch (SchedulerException e) {
            result = false;
            log.error(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean resumeAllJob() {
        try {
            this.scheduler.resumeAll();
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean resumeNow(String jobName, String jobGroup) throws SchedulerException {
        boolean result = true;
        boolean a = this.scheduler.checkExists(JobKey.jobKey((String)jobName, (String)jobGroup));
        if (!a) {
            return false;
        }
        TriggerKey triggerKey = new TriggerKey(jobName + "resumeNow", jobGroup + "resumeNow");
        Trigger trigger = this.scheduler.getTrigger(triggerKey);
        if (trigger != null) {
            System.out.println("\u89e6\u53d1\u5668\u4ecd\u5b58\u5728\uff01");
            return false;
        }
        System.out.println("\u89e6\u53d1\u5668\u5df2\u81ea\u52a8\u9500\u6bc1\uff01");
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
        Trigger immediateTrigger = TriggerBuilder.newTrigger().forJob(jobKey).withIdentity(jobName + "resumeNow", jobGroup + "resumeNow").startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0)).build();
        this.scheduler.scheduleJob(immediateTrigger);
        return result;
    }

    @Override
    public boolean pauseJob(String jobName, String jobGroup) throws SchedulerException {
        boolean result = true;
        boolean a = this.scheduler.checkExists(JobKey.jobKey((String)jobName, (String)jobGroup));
        if (!a) {
            return false;
        }
        try {
            this.scheduler.pauseJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            System.out.println(e.getMessage());
            result = false;
            log.error(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean pauseTri(String triggername, String triggergroup) throws SchedulerException {
        boolean result = true;
        boolean a = this.scheduler.checkExists(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        if (!a) {
            return false;
        }
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        }
        catch (SchedulerException e) {
            System.out.println(e.getMessage());
            result = false;
            log.error(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean pauseAllJob() {
        try {
            this.scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean reScheduleJob(String triggername, String triggergroup, String cronExpression) throws SchedulerException {
        boolean result = true;
        boolean a = this.scheduler.checkExists(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        if (!a) {
            return false;
        }
        try {
            Trigger.TriggerState triggerState = this.scheduler.getTriggerState(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
            CronTrigger cronTriggerOld = (CronTrigger)this.scheduler.getTrigger(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
            if (!cronTriggerOld.getCronExpression().equals(cronExpression)) {
                CronTrigger cronTriggerNew = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggername, triggergroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
                this.scheduler.rescheduleJob(TriggerKey.triggerKey((String)triggername, (String)triggergroup), (Trigger)cronTriggerNew);
                System.out.println(triggerState.name());
                if (triggerState.name().equals("PAUSED")) {
                    this.pauseJob(triggername, triggergroup);
                }
            }
        }
        catch (SchedulerException e) {
            result = false;
            log.error(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean deleteJob(String jobName, String jobGroup) throws SchedulerException {
        String triggername = null;
        String triggergroup = null;
        boolean result = true;
        boolean a = this.scheduler.checkExists(JobKey.jobKey((String)jobName, (String)jobGroup));
        if (!a) {
            return false;
        }
        try {
            List triggers = this.scheduler.getTriggersOfJob(JobKey.jobKey((String)jobName, (String)jobGroup));
            if (triggers.size() > 0) {
                if (!"PAUSED".equals(this.scheduler.getTriggerState(TriggerKey.triggerKey((String)jobName, (String)jobGroup)).name())) {
                    triggername = ((Trigger)triggers.get(0)).getKey().getName();
                    triggergroup = ((Trigger)triggers.get(0)).getKey().getGroup();
                    this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)jobName, (String)jobGroup));
                }
                this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)jobName, (String)jobGroup));
                this.vScriptTagScervice.deleteScriptTag(triggername, triggergroup);
            }
            this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroup));
            this.vScriptTagScervice.deleteScriptTag(jobName, jobGroup);
        }
        catch (SchedulerException e) {
            result = false;
            log.error(e.getMessage());
        }
        return result;
    }

    @Override
    public int addJob(JobInfo jobInfo) throws SchedulerException {
        System.out.println(jobInfo);
        int result = 0;
        if (jobInfo.getJobname() == null || jobInfo.getJobgroup() == null || jobInfo.getJobclassname() == null) {
            log.error("\u4efb\u52a1\u540d\u79f0,\u4efb\u52a1\u5206\u7ec4,\u4efb\u52a1\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            return -5;
        }
        int isjobexist = this.isJobExist(JobKey.jobKey((String)jobInfo.getJobname(), (String)jobInfo.getJobgroup()));
        if (isjobexist == 1) {
            log.error("\u4efb\u52a1\u5df2\u5b58\u5728");
            return -1;
        }
        if (jobInfo.getIsCustomTrigger().equals("false") && this.scheduler.checkExists(TriggerKey.triggerKey((String)jobInfo.getTriggername(), (String)jobInfo.getTriggergroup()))) {
            log.error("\u8c03\u5ea6\u5668\u5df2\u5b58\u5728");
            return -2;
        }
        try {
            String type;
            CreatJobDetail instance;
            if (jobInfo.getIsCustomJobDetail() == null) {
                jobInfo.setIsCustomJobDetail("false");
            }
            if (jobInfo.getJobDetail() == null && jobInfo.getIsCustomJobDetail().equals("true")) {
                log.error("\u5f00\u542f\u81ea\u52a8\u6ce8\u5165jobDetail\u65f6,jobDetail\u4e0d\u80fd\u4e3a\u7a7a");
                return -7;
            }
            if ("false".equals(jobInfo.getIsCustomJobDetail())) {
                jobInfo.setJobDetail(this.TRIGGER_GROUP_NAME);
            } else {
                this.vScriptTagScervice.addScriptTag(jobInfo.getJobname(), jobInfo.getJobgroup(), jobInfo.getJobDetail(), "JobDetail");
            }
            System.out.println("\u5f53\u524d\u4f7f\u7528\u7684jobDetail\u662f:" + jobInfo.getJobDetail());
            if (jobInfo.getStartime() == null) {
                LocalDateTime currentDateTime = LocalDateTime.now();
                LocalDateTime newDateTime = currentDateTime.plusSeconds(1L);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                String formattedDate = newDateTime.format(formatter);
                jobInfo.setStartime(formattedDate);
            }
            if (jobInfo.getEndtime() == null) {
                jobInfo.setEndtime("2099-12-31");
            }
            if (jobInfo.getPriority() == null) {
                jobInfo.setPriority("5");
            }
            JobDetail jobDetail = null;
            Class<CreatJobDetail> c = this.applicationContext.getType(jobInfo.getJobDetail()).asSubclass(CreatJobDetail.class);
            Constructor<CreatJobDetail> constructor = c.getDeclaredConstructor(ApplicationContext.class);
            CreatJobDetail creatJobDetail = instance = constructor.newInstance(this.applicationContext);
            jobDetail = creatJobDetail.createdetail(jobInfo.getJobclassname(), jobInfo.getJobname(), jobInfo.getJobgroup(), jobInfo.getDescription());
            if (jobInfo.getType() == null) {
                log.error("\u7c7b\u578b\u4e3a\u7a7a");
                return -3;
            }
            switch (jobInfo.getType()) {
                case "SimpleTrigger": {
                    type = "SimpleTrigger";
                    break;
                }
                case "CalendarIntervalTrigger": {
                    type = "CalendarIntervalTrigger";
                    break;
                }
                case "DailyTimeIntervalTrigger": {
                    type = "DailyTimeIntervalTrigger";
                    break;
                }
                case "CronTrigger": {
                    type = "CronTrigger";
                    break;
                }
                default: {
                    log.error("\u7c7b\u578b\u9519\u8bef");
                    return -4;
                }
            }
            if (jobInfo.getIsCustomTrigger() == null) {
                jobInfo.setIsCustomTrigger("false");
            }
            if (jobInfo.getTrigger() == null && jobInfo.getIsCustomTrigger().equals("true")) {
                log.error("\u5f00\u542f\u81ea\u52a8\u6ce8\u5165trigger\u65f6,trigger\u4e0d\u80fd\u4e3a\u7a7a");
                return -6;
            }
            if (jobInfo.getIsCustomTrigger().equals("true")) {
                switch (type) {
                    case "SimpleTrigger": {
                        TriggerAbstract Simple = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        SimpleTrigger simpleTrigger = Simple.CreateSimpleTrigger(jobDetail);
                        this.scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
                        this.vScriptTagScervice.addScriptTag(simpleTrigger.getKey().getName(), simpleTrigger.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    case "CalendarIntervalTrigger": {
                        TriggerAbstract Calendar2 = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        CalendarIntervalTrigger CalendarTrigger = Calendar2.CreatCalendarIntervalTrigger(jobDetail);
                        this.scheduler.scheduleJob(jobDetail, (Trigger)CalendarTrigger);
                        this.vScriptTagScervice.addScriptTag(CalendarTrigger.getKey().getName(), CalendarTrigger.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    case "DailyTimeIntervalTrigger": {
                        TriggerAbstract Daily = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        DailyTimeIntervalTrigger DailyTrigger = Daily.CreateDailyTimeIntervalTrigger(jobDetail);
                        this.scheduler.scheduleJob(jobDetail, (Trigger)DailyTrigger);
                        this.vScriptTagScervice.addScriptTag(DailyTrigger.getKey().getName(), DailyTrigger.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    case "CronTrigger": {
                        TriggerAbstract Cron = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        CronTrigger cronTrigger = Cron.CreateCronTrigger(jobDetail);
                        this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
                        this.vScriptTagScervice.addScriptTag(cronTrigger.getKey().getName(), cronTrigger.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    default: {
                        log.error("\u7c7b\u578b\u9519\u8bef");
                        return -4;
                    }
                }
                return result;
            }
            switch (type) {
                case "SimpleTrigger": {
                    if (jobInfo.getSimpletimesecond() == null) {
                        jobInfo.setSimpletimesecond("1");
                    }
                    if (jobInfo.getRepeatcount() == null) {
                        jobInfo.setRepeatcount("0");
                    }
                    Trigger SimpleTrigger2 = TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(Integer.parseInt(jobInfo.getSimpletimesecond())).withRepeatCount(Integer.parseInt(jobInfo.getRepeatcount()))).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).forJob(jobDetail).startNow().build();
                    this.scheduler.scheduleJob(jobDetail, SimpleTrigger2);
                    break;
                }
                case "CalendarIntervalTrigger": {
                    if (jobInfo.getCalendartime() == null) {
                        jobInfo.setCalendartime("second");
                    }
                    if (jobInfo.getCalendarnum() == null) {
                        jobInfo.setCalendarnum("1");
                    }
                    if (jobInfo.getTimezone() == null) {
                        jobInfo.setTimezone("Asia/Shanghai");
                    }
                    if (jobInfo.getPreserveHourOfDayAcrossDaylightSavings() == null) {
                        jobInfo.setPreserveHourOfDayAcrossDaylightSavings("true");
                    }
                    if (jobInfo.getSkipDayIfHourDoesNotExist() == null) {
                        jobInfo.setSkipDayIfHourDoesNotExist("true");
                    }
                    DateBuilder.IntervalUnit time = null;
                    switch (jobInfo.getCalendartime()) {
                        case "second": {
                            time = DateBuilder.IntervalUnit.SECOND;
                            break;
                        }
                        case "minute": {
                            time = DateBuilder.IntervalUnit.MINUTE;
                            break;
                        }
                        case "hour": {
                            time = DateBuilder.IntervalUnit.HOUR;
                            break;
                        }
                        case "day": {
                            time = DateBuilder.IntervalUnit.DAY;
                            break;
                        }
                        case "week": {
                            time = DateBuilder.IntervalUnit.WEEK;
                            break;
                        }
                        case "month": {
                            time = DateBuilder.IntervalUnit.MONTH;
                            break;
                        }
                        case "year": {
                            time = DateBuilder.IntervalUnit.YEAR;
                        }
                    }
                    Trigger CalendarIntervalTrigger2 = TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)CalendarIntervalScheduleBuilder.calendarIntervalSchedule().preserveHourOfDayAcrossDaylightSavings("true".equals(jobInfo.getPreserveHourOfDayAcrossDaylightSavings())).skipDayIfHourDoesNotExist("true".equals(jobInfo.getSkipDayIfHourDoesNotExist())).inTimeZone(TimeZone.getTimeZone(jobInfo.getTimezone())).withInterval(Integer.parseInt(jobInfo.getCalendarnum()), time)).forJob(jobDetail).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).startNow().withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.scheduleJob(jobDetail, CalendarIntervalTrigger2);
                    break;
                }
                case "DailyTimeIntervalTrigger": {
                    if (jobInfo.getDailytime() == null) {
                        jobInfo.setDailytime("second");
                    }
                    if (jobInfo.getDailyworkday() == null) {
                        jobInfo.setDailyworkday(Set.of("all"));
                    }
                    if (jobInfo.getDailynum() == null) {
                        jobInfo.setDailynum("1");
                    }
                    if (jobInfo.getDailyrepeatcount() == null) {
                        jobInfo.setDailyrepeatcount("0");
                    }
                    int starthour = 0;
                    int startminute = 0;
                    int startsecond = 0;
                    TimeOfDay starttimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)starthour, (int)startminute, (int)startsecond);
                    if (jobInfo.getDailystarttime() != null) {
                        String[] splitstarttime = jobInfo.getDailystarttime().split(":");
                        starthour = Integer.parseInt(splitstarttime[0]);
                        startminute = Integer.parseInt(splitstarttime[1]);
                        startsecond = Integer.parseInt(splitstarttime[2]);
                        starttimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)starthour, (int)startminute, (int)startsecond);
                    }
                    int endhour = 23;
                    int endminute = 59;
                    int endsecond = 59;
                    TimeOfDay endtimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)endhour, (int)endminute, (int)endsecond);
                    if (jobInfo.getDailyendtime() != null) {
                        String[] splitendtime = jobInfo.getDailyendtime().split(":");
                        endhour = Integer.parseInt(splitendtime[0]);
                        endminute = Integer.parseInt(splitendtime[1]);
                        endsecond = Integer.parseInt(splitendtime[2]);
                        endtimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)endhour, (int)endminute, (int)endsecond);
                    }
                    DateBuilder.IntervalUnit Dailytime = switch (jobInfo.getDailytime()) {
                        case "second" -> DateBuilder.IntervalUnit.SECOND;
                        case "minute" -> DateBuilder.IntervalUnit.MINUTE;
                        case "hour" -> DateBuilder.IntervalUnit.HOUR;
                        default -> null;
                    };
                    HashSet<Integer> daysOfWeek = new HashSet<Integer>();
                    Iterator<String> iterator = jobInfo.getDailyworkday().iterator();
                    block96: while (iterator.hasNext()) {
                        String day;
                        switch (day = iterator.next()) {
                            case "1": {
                                daysOfWeek.add(1);
                                continue block96;
                            }
                            case "2": {
                                daysOfWeek.add(2);
                                continue block96;
                            }
                            case "3": {
                                daysOfWeek.add(3);
                                continue block96;
                            }
                            case "4": {
                                daysOfWeek.add(4);
                                continue block96;
                            }
                            case "5": {
                                daysOfWeek.add(5);
                                continue block96;
                            }
                            case "6": {
                                daysOfWeek.add(6);
                                continue block96;
                            }
                            case "7": {
                                daysOfWeek.add(7);
                                continue block96;
                            }
                            case "all": {
                                daysOfWeek.add(1);
                                daysOfWeek.add(2);
                                daysOfWeek.add(3);
                                daysOfWeek.add(4);
                                daysOfWeek.add(5);
                                daysOfWeek.add(6);
                                daysOfWeek.add(7);
                                continue block96;
                            }
                            case "workday": {
                                daysOfWeek.add(2);
                                daysOfWeek.add(3);
                                daysOfWeek.add(4);
                                daysOfWeek.add(5);
                                daysOfWeek.add(1);
                                continue block96;
                            }
                            case "weekend": {
                                daysOfWeek.add(6);
                                daysOfWeek.add(7);
                                continue block96;
                            }
                        }
                        log.error("\u65e5\u671f\u9519\u8bef");
                        return -6;
                    }
                    Trigger DailyTimeIntervalTrigger2 = TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().startingDailyAt(starttimeOfDay).endingDailyAt(endtimeOfDay).onDaysOfTheWeek(daysOfWeek).withInterval(Integer.parseInt(jobInfo.getDailynum()), Dailytime).withRepeatCount(Integer.parseInt(jobInfo.getDailyrepeatcount()))).forJob(jobDetail).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).startNow().endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.scheduleJob(jobDetail, DailyTimeIntervalTrigger2);
                    break;
                }
                case "CronTrigger": {
                    if (jobInfo.getCronexpression() == null) {
                        jobInfo.setCronexpression("0/1 * * * * ?");
                    }
                    if (jobInfo.getTimezone() == null) {
                        jobInfo.setTimezone("Asia/Shanghai");
                    }
                    System.out.println(jobInfo.getStartime() + " " + jobInfo.getEndtime());
                    CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobInfo.getCronexpression()).inTimeZone(TimeZone.getTimeZone(jobInfo.getTimezone()))).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).startNow().forJob(jobDetail).endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
                }
            }
        }
        catch (SchedulerException e) {
            result = 2;
            log.error("\u4efb\u52a1\u8c03\u5ea6\u5931\u8d25");
            log.error(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage());
            return 2;
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage());
            return 2;
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
            return 2;
        }
        catch (InstantiationException e) {
            log.error(e.getMessage());
            return 2;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public int jobTOtri(JobInfo jobInfo) throws SchedulerException {
        int result = 0;
        if ((jobInfo.getJobname() == null || jobInfo.getJobgroup() == null) && "true".equals(jobInfo.getIsCustomTrigger())) {
            log.error("\u4efb\u52a1\u540d\u79f0,\u4efb\u52a1\u5206\u7ec4,\u4e0d\u80fd\u4e3a\u7a7a");
            return -5;
        }
        System.out.println("name" + jobInfo.getJobname());
        System.out.println("group" + jobInfo.getJobgroup());
        System.out.println(JobKey.jobKey((String)jobInfo.getJobname(), (String)jobInfo.getJobgroup()));
        if ("false".equals(jobInfo.getIsCustomTrigger()) && this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobInfo.getTriggername(), (String)jobInfo.getTriggergroup())) != null) {
            log.error("\u89e6\u53d1\u5668\u5df2\u5b58\u5728");
            return -2;
        }
        try {
            String type;
            JobDetail jobDetail = this.scheduler.getJobDetail(JobKey.jobKey((String)jobInfo.getJobname(), (String)jobInfo.getJobgroup()));
            System.out.println("jobDetail" + String.valueOf(jobDetail));
            if (jobInfo.getStartime() == null) {
                LocalDateTime currentDateTime = LocalDateTime.now();
                LocalDateTime newDateTime = currentDateTime.plusSeconds(1L);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                String formattedDate = newDateTime.format(formatter);
                jobInfo.setStartime(formattedDate);
            }
            if (jobInfo.getEndtime() == null) {
                jobInfo.setEndtime("2099-12-31");
            }
            if (jobInfo.getPriority() == null) {
                jobInfo.setPriority("5");
            }
            if (jobInfo.getType() == null) {
                log.error("\u7c7b\u578b\u4e3a\u7a7a");
                return -3;
            }
            switch (jobInfo.getType()) {
                case "SimpleTrigger": {
                    type = "SimpleTrigger";
                    break;
                }
                case "CalendarIntervalTrigger": {
                    type = "CalendarIntervalTrigger";
                    break;
                }
                case "DailyTimeIntervalTrigger": {
                    type = "DailyTimeIntervalTrigger";
                    break;
                }
                case "CronTrigger": {
                    type = "CronTrigger";
                    break;
                }
                default: {
                    log.error("\u7c7b\u578b\u9519\u8bef");
                    return -4;
                }
            }
            if (jobInfo.getIsCustomTrigger() == null) {
                jobInfo.setIsCustomTrigger("false");
            }
            if (jobInfo.getTrigger() == null && jobInfo.getIsCustomTrigger().equals("true")) {
                log.error("\u5f00\u542f\u81ea\u52a8\u6ce8\u5165trigger\u65f6,trigger\u4e0d\u80fd\u4e3a\u7a7a");
                return -6;
            }
            if (jobInfo.getIsCustomTrigger().equals("true")) {
                switch (type) {
                    case "SimpleTrigger": {
                        TriggerAbstract Simple = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        SimpleTrigger SimpleTrigger2 = Simple.CreateSimpleTrigger(jobDetail);
                        this.scheduler.scheduleJob((Trigger)SimpleTrigger2);
                        this.vScriptTagScervice.addScriptTag(SimpleTrigger2.getKey().getName(), SimpleTrigger2.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    case "CalendarIntervalTrigger": {
                        TriggerAbstract Calendar2 = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        CalendarIntervalTrigger CalendarTrigger = Calendar2.CreatCalendarIntervalTrigger(jobDetail);
                        this.scheduler.scheduleJob((Trigger)CalendarTrigger);
                        this.vScriptTagScervice.addScriptTag(CalendarTrigger.getKey().getName(), CalendarTrigger.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    case "DailyTimeIntervalTrigger": {
                        TriggerAbstract Daily = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        DailyTimeIntervalTrigger DailyTrigger = Daily.CreateDailyTimeIntervalTrigger(jobDetail);
                        this.scheduler.scheduleJob((Trigger)DailyTrigger);
                        this.vScriptTagScervice.addScriptTag(DailyTrigger.getKey().getName(), DailyTrigger.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    case "CronTrigger": {
                        TriggerAbstract cro = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        CronTrigger cronTrigger = cro.CreateCronTrigger(jobDetail);
                        this.scheduler.scheduleJob((Trigger)cronTrigger);
                        this.vScriptTagScervice.addScriptTag(cronTrigger.getKey().getName(), cronTrigger.getKey().getGroup(), jobInfo.getTrigger(), jobInfo.getType());
                        break;
                    }
                    default: {
                        log.error("\u7c7b\u578b\u9519\u8bef");
                        return -4;
                    }
                }
                return result;
            }
            switch (type) {
                case "SimpleTrigger": {
                    if (jobInfo.getSimpletimesecond() == null) {
                        jobInfo.setSimpletimesecond("1");
                    }
                    if (jobInfo.getRepeatcount() == null) {
                        jobInfo.setRepeatcount("0");
                    }
                    Trigger SimpleTrigger3 = TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(Integer.parseInt(jobInfo.getSimpletimesecond())).withRepeatCount(Integer.parseInt(jobInfo.getRepeatcount()))).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).startNow().endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).forJob(jobDetail).build();
                    this.scheduler.scheduleJob(SimpleTrigger3);
                    break;
                }
                case "CalendarIntervalTrigger": {
                    if (jobInfo.getCalendartime() == null) {
                        jobInfo.setCalendartime("second");
                    }
                    if (jobInfo.getCalendarnum() == null) {
                        jobInfo.setCalendarnum("1");
                    }
                    if (jobInfo.getTimezone() == null) {
                        jobInfo.setTimezone("Asia/Shanghai");
                    }
                    if (jobInfo.getPreserveHourOfDayAcrossDaylightSavings() == null) {
                        jobInfo.setPreserveHourOfDayAcrossDaylightSavings("true");
                    }
                    if (jobInfo.getSkipDayIfHourDoesNotExist() == null) {
                        jobInfo.setSkipDayIfHourDoesNotExist("true");
                    }
                    DateBuilder.IntervalUnit time = null;
                    switch (jobInfo.getCalendartime()) {
                        case "second": {
                            time = DateBuilder.IntervalUnit.SECOND;
                            break;
                        }
                        case "minute": {
                            time = DateBuilder.IntervalUnit.MINUTE;
                            break;
                        }
                        case "hour": {
                            time = DateBuilder.IntervalUnit.HOUR;
                            break;
                        }
                        case "day": {
                            time = DateBuilder.IntervalUnit.DAY;
                            break;
                        }
                        case "week": {
                            time = DateBuilder.IntervalUnit.WEEK;
                            break;
                        }
                        case "month": {
                            time = DateBuilder.IntervalUnit.MONTH;
                            break;
                        }
                        case "year": {
                            time = DateBuilder.IntervalUnit.YEAR;
                        }
                    }
                    Trigger CalendarIntervalTrigger2 = TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)CalendarIntervalScheduleBuilder.calendarIntervalSchedule().preserveHourOfDayAcrossDaylightSavings("true".equals(jobInfo.getPreserveHourOfDayAcrossDaylightSavings())).skipDayIfHourDoesNotExist("true".equals(jobInfo.getSkipDayIfHourDoesNotExist())).inTimeZone(TimeZone.getTimeZone(jobInfo.getTimezone())).withInterval(Integer.parseInt(jobInfo.getCalendarnum()), time)).forJob(jobDetail).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).startNow().endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.scheduleJob(CalendarIntervalTrigger2);
                    break;
                }
                case "DailyTimeIntervalTrigger": {
                    if (jobInfo.getDailytime() == null) {
                        jobInfo.setDailytime("second");
                    }
                    if (jobInfo.getDailyworkday() == null) {
                        jobInfo.setDailyworkday(Set.of("all"));
                    }
                    if (jobInfo.getDailynum() == null) {
                        jobInfo.setDailynum("1");
                    }
                    if (jobInfo.getDailyrepeatcount() == null) {
                        jobInfo.setDailyrepeatcount("0");
                    }
                    int starthour = 0;
                    int startminute = 0;
                    int startsecond = 0;
                    TimeOfDay starttimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)starthour, (int)startminute, (int)startsecond);
                    if (jobInfo.getDailystarttime() != null) {
                        String[] splitstarttime = jobInfo.getDailystarttime().split(":");
                        starthour = Integer.parseInt(splitstarttime[0]);
                        startminute = Integer.parseInt(splitstarttime[1]);
                        startsecond = Integer.parseInt(splitstarttime[2]);
                        starttimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)starthour, (int)startminute, (int)startsecond);
                    }
                    int endhour = 23;
                    int endminute = 59;
                    int endsecond = 59;
                    TimeOfDay endtimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)endhour, (int)endminute, (int)endsecond);
                    if (jobInfo.getDailyendtime() != null) {
                        String[] splitendtime = jobInfo.getDailyendtime().split(":");
                        endhour = Integer.parseInt(splitendtime[0]);
                        endminute = Integer.parseInt(splitendtime[1]);
                        endsecond = Integer.parseInt(splitendtime[2]);
                        endtimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)endhour, (int)endminute, (int)endsecond);
                    }
                    DateBuilder.IntervalUnit Dailytime = null;
                    switch (jobInfo.getDailytime()) {
                        case "second": {
                            Dailytime = DateBuilder.IntervalUnit.SECOND;
                            break;
                        }
                        case "minute": {
                            Dailytime = DateBuilder.IntervalUnit.MINUTE;
                            break;
                        }
                        case "hour": {
                            Dailytime = DateBuilder.IntervalUnit.HOUR;
                        }
                    }
                    HashSet<Integer> daysOfWeek = new HashSet<Integer>();
                    Iterator<String> iterator = jobInfo.getDailyworkday().iterator();
                    block92: while (iterator.hasNext()) {
                        String day;
                        switch (day = iterator.next()) {
                            case "1": {
                                daysOfWeek.add(1);
                                continue block92;
                            }
                            case "2": {
                                daysOfWeek.add(2);
                                continue block92;
                            }
                            case "3": {
                                daysOfWeek.add(3);
                                continue block92;
                            }
                            case "4": {
                                daysOfWeek.add(4);
                                continue block92;
                            }
                            case "5": {
                                daysOfWeek.add(5);
                                continue block92;
                            }
                            case "6": {
                                daysOfWeek.add(6);
                                continue block92;
                            }
                            case "7": {
                                daysOfWeek.add(7);
                                continue block92;
                            }
                            case "all": {
                                daysOfWeek.add(1);
                                daysOfWeek.add(2);
                                daysOfWeek.add(3);
                                daysOfWeek.add(4);
                                daysOfWeek.add(5);
                                daysOfWeek.add(6);
                                daysOfWeek.add(7);
                                continue block92;
                            }
                            case "workday": {
                                daysOfWeek.add(2);
                                daysOfWeek.add(3);
                                daysOfWeek.add(4);
                                daysOfWeek.add(5);
                                daysOfWeek.add(1);
                                continue block92;
                            }
                            case "weekend": {
                                daysOfWeek.add(6);
                                daysOfWeek.add(7);
                                continue block92;
                            }
                        }
                        log.error("\u65e5\u671f\u9519\u8bef");
                        return -6;
                    }
                    Trigger DailyTimeIntervalTrigger2 = TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().startingDailyAt(starttimeOfDay).endingDailyAt(endtimeOfDay).onDaysOfTheWeek(daysOfWeek).withInterval(Integer.parseInt(jobInfo.getDailynum()), Dailytime).withRepeatCount(Integer.parseInt(jobInfo.getDailyrepeatcount()))).forJob(jobDetail).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).startNow().endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.scheduleJob(DailyTimeIntervalTrigger2);
                    break;
                }
                case "CronTrigger": {
                    if (jobInfo.getCronexpression() == null) {
                        jobInfo.setCronexpression("0/1 * * * * ?");
                    }
                    if (jobInfo.getTimezone() == null) {
                        jobInfo.setTimezone("Asia/Shanghai");
                    }
                    System.out.println(jobInfo.getStartime() + " " + jobInfo.getEndtime());
                    CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobInfo.getCronexpression()).inTimeZone(TimeZone.getTimeZone(jobInfo.getTimezone()))).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).startNow().forJob(jobDetail).endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.scheduleJob((Trigger)cronTrigger);
                }
            }
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            result = -2;
            log.error("\u4efb\u52a1\u8c03\u5ea6\u5931\u8d25");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public int createdetail(String jobclassname, String jobname, String jobgroup, String isCustomJobDetail, String jobDetail, String description) throws SchedulerException {
        int result = 0;
        if (jobname == null || jobgroup == null || jobclassname == null) {
            log.error("\u4efb\u52a1\u540d\u79f0,\u4efb\u52a1\u5206\u7ec4,\u4efb\u52a1\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            return -5;
        }
        if (this.scheduler.getJobDetail(JobKey.jobKey((String)jobname, (String)jobgroup)) != null) {
            log.error("\u4efb\u52a1\u5df2\u5b58\u5728");
            return -1;
        }
        try {
            CreatJobDetail instance;
            if (jobDetail == null && "true".equals(isCustomJobDetail)) {
                log.error("\u5f00\u542f\u81ea\u52a8\u6ce8\u5165jobDetail\u65f6,jobDetail\u4e0d\u80fd\u4e3a\u7a7a");
                return -7;
            }
            if (isCustomJobDetail == null) {
                isCustomJobDetail = "false";
            }
            if ("false".equals(isCustomJobDetail)) {
                jobDetail = this.TRIGGER_GROUP_NAME;
            } else {
                this.vScriptTagScervice.addScriptTag(jobname, jobgroup, jobDetail, "JobDetail");
            }
            JobDetail jobDetailimpl = null;
            Class<CreatJobDetail> c = this.applicationContext.getType(jobDetail).asSubclass(CreatJobDetail.class);
            Constructor<CreatJobDetail> constructor = c.getDeclaredConstructor(ApplicationContext.class);
            CreatJobDetail creatJobDetail = instance = constructor.newInstance(this.applicationContext);
            jobDetailimpl = creatJobDetail.createdetail(jobclassname, jobname, jobgroup, description);
            this.scheduler.addJob(jobDetailimpl, false);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SchedulerException e) {
            log.error(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public boolean updateTriggerargument(JobInfo jobInfo) throws SchedulerException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        boolean result = false;
        if (jobInfo.getTriggername() == null || jobInfo.getTriggergroup() == null) {
            log.error("\u89e6\u53d1\u5668\u540d\u79f0,\u89e6\u53d1\u5668\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobInfo.getTriggername(), (String)jobInfo.getTriggergroup())) == null) {
            log.error("\u89e6\u53d1\u5668\u4e0d\u5b58\u5728");
            return false;
        }
        try {
            String type;
            Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)jobInfo.getTriggername(), (String)jobInfo.getTriggergroup()));
            System.out.println("\u83b7\u53d6getTriggername" + jobInfo.getTriggername() + "\u83b7\u53d6getTriggername" + jobInfo.getTriggergroup());
            System.out.println("\u7b2c\u4e00\u6b21\u83b7\u53d6trigger" + String.valueOf(trigger));
            TriggerBuilder triggerBuilder = trigger.getTriggerBuilder();
            if (jobInfo.getType() == null) {
                log.error("\u7c7b\u578b\u4e3a\u7a7a");
                return false;
            }
            switch (jobInfo.getType()) {
                case "SimpleTrigger": {
                    type = "SimpleTrigger";
                    break;
                }
                case "CalendarIntervalTrigger": {
                    type = "CalendarIntervalTrigger";
                    break;
                }
                case "DailyTimeIntervalTrigger": {
                    type = "DailyTimeIntervalTrigger";
                    break;
                }
                case "CronTrigger": {
                    type = "CronTrigger";
                    break;
                }
                default: {
                    log.error("\u7c7b\u578b\u9519\u8bef");
                    return false;
                }
            }
            if (jobInfo.getIsCustomTrigger() == null) {
                jobInfo.setIsCustomTrigger("false");
            }
            if (jobInfo.getTrigger() == null && jobInfo.getIsCustomTrigger().equals("true")) {
                log.error("\u5f00\u542f\u81ea\u52a8\u6ce8\u5165trigger\u65f6,trigger\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (jobInfo.getIsCustomTrigger().equals("true")) {
                switch (type) {
                    case "SimpleTrigger": {
                        TriggerAbstract Simple = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        SimpleTrigger SimpleTrigger2 = Simple.updateSimpletrigger(triggerBuilder);
                        this.scheduler.pauseTrigger(trigger.getKey());
                        this.scheduler.rescheduleJob(trigger.getKey(), (Trigger)SimpleTrigger2);
                        this.scheduler.resumeTrigger(trigger.getKey());
                        this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                        return true;
                    }
                    case "CalendarIntervalTrigger": {
                        TriggerAbstract Calendar2 = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        CalendarIntervalTrigger CalendarTrigger = Calendar2.updateCalendarIntervalTrigger(triggerBuilder);
                        this.scheduler.pauseTrigger(trigger.getKey());
                        this.scheduler.rescheduleJob(trigger.getKey(), (Trigger)CalendarTrigger);
                        this.scheduler.resumeTrigger(trigger.getKey());
                        this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                        return true;
                    }
                    case "DailyTimeIntervalTrigger": {
                        TriggerAbstract Daily = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        DailyTimeIntervalTrigger DailyTrigger = Daily.updateDailyTimeIntervalTrigger(triggerBuilder);
                        this.scheduler.pauseTrigger(trigger.getKey());
                        this.scheduler.rescheduleJob(trigger.getKey(), (Trigger)DailyTrigger);
                        this.scheduler.resumeTrigger(trigger.getKey());
                        this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                        return true;
                    }
                    case "CronTrigger": {
                        TriggerAbstract cron = (TriggerAbstract)SpringContextHolder.getBean(jobInfo.getTrigger());
                        CronTrigger cronTrigger = cron.updateCrontrigger(triggerBuilder);
                        this.scheduler.pauseTrigger(trigger.getKey());
                        this.scheduler.rescheduleJob(trigger.getKey(), (Trigger)cronTrigger);
                        this.scheduler.resumeTrigger(trigger.getKey());
                        this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                        return true;
                    }
                }
                log.error("\u7c7b\u578b\u9519\u8bef");
                return false;
            }
            switch (type) {
                case "SimpleTrigger": {
                    SimpleTriggerImpl TriggerImpl = (SimpleTriggerImpl)trigger;
                    if (jobInfo.getSimpletimesecond() == null) {
                        jobInfo.setSimpletimesecond(String.valueOf(TriggerImpl.getRepeatInterval()));
                    }
                    if (jobInfo.getRepeatcount() == null) {
                        jobInfo.setRepeatcount(String.valueOf(TriggerImpl.getRepeatCount()));
                    }
                    if (jobInfo.getStartime() == null) {
                        jobInfo.setStartime(sdf.format(trigger.getStartTime()));
                    }
                    if (jobInfo.getEndtime() == null) {
                        jobInfo.setEndtime(sdf.format(trigger.getEndTime()));
                    }
                    if (jobInfo.getPriority() == null) {
                        jobInfo.setPriority(String.valueOf(TriggerImpl.getPriority()));
                    }
                    Trigger SimpleTrigger3 = triggerBuilder.withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(Integer.parseInt(jobInfo.getSimpletimesecond())).withRepeatCount(Integer.parseInt(jobInfo.getRepeatcount()))).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).startNow().withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.pauseTrigger(trigger.getKey());
                    this.scheduler.rescheduleJob(trigger.getKey(), SimpleTrigger3);
                    this.scheduler.resumeTrigger(trigger.getKey());
                    this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                    break;
                }
                case "CalendarIntervalTrigger": {
                    CalendarIntervalTriggerImpl CalendarIntervalTriggerImpl2 = (CalendarIntervalTriggerImpl)trigger;
                    if (jobInfo.getCalendartime() == null) {
                        jobInfo.setCalendartime(String.valueOf(CalendarIntervalTriggerImpl2.getRepeatIntervalUnit()));
                    }
                    if (jobInfo.getCalendarnum() == null) {
                        jobInfo.setCalendarnum(String.valueOf(CalendarIntervalTriggerImpl2.getRepeatInterval()));
                    }
                    if (jobInfo.getTimezone() == null) {
                        jobInfo.setTimezone(String.valueOf(CalendarIntervalTriggerImpl2.getTimeZone()));
                    }
                    if (jobInfo.getPreserveHourOfDayAcrossDaylightSavings() == null) {
                        jobInfo.setPreserveHourOfDayAcrossDaylightSavings(String.valueOf(CalendarIntervalTriggerImpl2.isPreserveHourOfDayAcrossDaylightSavings()));
                    }
                    if (jobInfo.getSkipDayIfHourDoesNotExist() == null) {
                        jobInfo.setSkipDayIfHourDoesNotExist(String.valueOf(CalendarIntervalTriggerImpl2.isSkipDayIfHourDoesNotExist()));
                    }
                    if (jobInfo.getStartime() == null) {
                        jobInfo.setStartime(sdf.format(trigger.getStartTime()));
                    }
                    if (jobInfo.getEndtime() == null) {
                        jobInfo.setEndtime(sdf.format(trigger.getEndTime()));
                    }
                    if (jobInfo.getPriority() == null) {
                        jobInfo.setPriority(String.valueOf(CalendarIntervalTriggerImpl2.getPriority()));
                    }
                    DateBuilder.IntervalUnit time = null;
                    switch (jobInfo.getCalendartime()) {
                        case "second": {
                            time = DateBuilder.IntervalUnit.SECOND;
                            break;
                        }
                        case "minute": {
                            time = DateBuilder.IntervalUnit.MINUTE;
                            break;
                        }
                        case "hour": {
                            time = DateBuilder.IntervalUnit.HOUR;
                            break;
                        }
                        case "day": {
                            time = DateBuilder.IntervalUnit.DAY;
                            break;
                        }
                        case "week": {
                            time = DateBuilder.IntervalUnit.WEEK;
                            break;
                        }
                        case "month": {
                            time = DateBuilder.IntervalUnit.MONTH;
                            break;
                        }
                        case "year": {
                            time = DateBuilder.IntervalUnit.YEAR;
                        }
                    }
                    Trigger CalendarIntervalTrigger2 = triggerBuilder.withSchedule((ScheduleBuilder)CalendarIntervalScheduleBuilder.calendarIntervalSchedule().preserveHourOfDayAcrossDaylightSavings("true".equals(jobInfo.getPreserveHourOfDayAcrossDaylightSavings())).skipDayIfHourDoesNotExist("true".equals(jobInfo.getSkipDayIfHourDoesNotExist())).inTimeZone(TimeZone.getTimeZone(jobInfo.getTimezone())).withInterval(Integer.parseInt(jobInfo.getCalendarnum()), time)).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).startNow().withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.pauseTrigger(trigger.getKey());
                    this.scheduler.rescheduleJob(trigger.getKey(), CalendarIntervalTrigger2);
                    this.scheduler.resumeTrigger(trigger.getKey());
                    this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                    break;
                }
                case "DailyTimeIntervalTrigger": {
                    DailyTimeIntervalTriggerImpl DailyTimeIntervalTriggerImpl2 = (DailyTimeIntervalTriggerImpl)trigger;
                    if (jobInfo.getDailytime() == null) {
                        jobInfo.setDailytime(String.valueOf(DailyTimeIntervalTriggerImpl2.getRepeatIntervalUnit()));
                    }
                    if (jobInfo.getDailyworkday() == null) {
                        Set daysOfWeek = DailyTimeIntervalTriggerImpl2.getDaysOfWeek();
                        Set<String> daysOfWeekString = daysOfWeek.stream().map(String::valueOf).collect(Collectors.toSet());
                        jobInfo.setDailyworkday(daysOfWeekString);
                    }
                    if (jobInfo.getDailynum() == null) {
                        jobInfo.setDailynum(String.valueOf(DailyTimeIntervalTriggerImpl2.getRepeatInterval()));
                    }
                    if (jobInfo.getDailyrepeatcount() == null) {
                        jobInfo.setDailyrepeatcount(String.valueOf(DailyTimeIntervalTriggerImpl2.getRepeatCount()));
                    }
                    if (jobInfo.getStartime() == null) {
                        jobInfo.setStartime(sdf.format(trigger.getStartTime()));
                    }
                    if (jobInfo.getEndtime() == null) {
                        jobInfo.setEndtime(sdf.format(trigger.getEndTime()));
                    }
                    if (jobInfo.getPriority() == null) {
                        jobInfo.setPriority(String.valueOf(DailyTimeIntervalTriggerImpl2.getPriority()));
                    }
                    TimeOfDay startTimeOfDay = DailyTimeIntervalTriggerImpl2.getStartTimeOfDay();
                    TimeOfDay endTimeOfDay = DailyTimeIntervalTriggerImpl2.getEndTimeOfDay();
                    if (jobInfo.getDailystarttime() != null) {
                        String[] splitstarttime = jobInfo.getDailystarttime().split(":");
                        int starthour = Integer.parseInt(splitstarttime[0]);
                        int startminute = Integer.parseInt(splitstarttime[1]);
                        int startsecond = Integer.parseInt(splitstarttime[2]);
                        startTimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)starthour, (int)startminute, (int)startsecond);
                    }
                    if (jobInfo.getDailyendtime() != null) {
                        String[] splitendtime = jobInfo.getDailyendtime().split(":");
                        int endhour = Integer.parseInt(splitendtime[0]);
                        int endminute = Integer.parseInt(splitendtime[1]);
                        int endsecond = Integer.parseInt(splitendtime[2]);
                        endTimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay((int)endhour, (int)endminute, (int)endsecond);
                    }
                    DateBuilder.IntervalUnit Dailytime = null;
                    switch (jobInfo.getDailytime()) {
                        case "second": {
                            Dailytime = DateBuilder.IntervalUnit.SECOND;
                            break;
                        }
                        case "minute": {
                            Dailytime = DateBuilder.IntervalUnit.MINUTE;
                            break;
                        }
                        case "hour": {
                            Dailytime = DateBuilder.IntervalUnit.HOUR;
                        }
                    }
                    HashSet<Integer> daysOfWeek = new HashSet<Integer>();
                    Iterator<String> endminute = jobInfo.getDailyworkday().iterator();
                    block90: while (endminute.hasNext()) {
                        String day;
                        switch (day = endminute.next()) {
                            case "1": {
                                daysOfWeek.add(1);
                                continue block90;
                            }
                            case "2": {
                                daysOfWeek.add(2);
                                continue block90;
                            }
                            case "3": {
                                daysOfWeek.add(3);
                                continue block90;
                            }
                            case "4": {
                                daysOfWeek.add(4);
                                continue block90;
                            }
                            case "5": {
                                daysOfWeek.add(5);
                                continue block90;
                            }
                            case "6": {
                                daysOfWeek.add(6);
                                continue block90;
                            }
                            case "7": {
                                daysOfWeek.add(7);
                                continue block90;
                            }
                            case "all": {
                                daysOfWeek.add(1);
                                daysOfWeek.add(2);
                                daysOfWeek.add(3);
                                daysOfWeek.add(4);
                                daysOfWeek.add(5);
                                daysOfWeek.add(6);
                                daysOfWeek.add(7);
                                continue block90;
                            }
                            case "workday": {
                                daysOfWeek.add(2);
                                daysOfWeek.add(3);
                                daysOfWeek.add(4);
                                daysOfWeek.add(5);
                                daysOfWeek.add(1);
                                continue block90;
                            }
                            case "weekend": {
                                daysOfWeek.add(6);
                                daysOfWeek.add(7);
                                continue block90;
                            }
                        }
                        log.error("\u65e5\u671f\u9519\u8bef");
                        return false;
                    }
                    Trigger DailyTimeIntervalTrigger2 = TriggerBuilder.newTrigger().withIdentity(jobInfo.getTriggername(), jobInfo.getTriggergroup()).withSchedule((ScheduleBuilder)DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().startingDailyAt(startTimeOfDay).endingDailyAt(endTimeOfDay).onDaysOfTheWeek(daysOfWeek).withInterval(Integer.parseInt(jobInfo.getDailynum()), Dailytime).withRepeatCount(Integer.parseInt(jobInfo.getDailyrepeatcount()))).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).startNow().endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).build();
                    this.scheduler.pauseTrigger(trigger.getKey());
                    this.scheduler.rescheduleJob(trigger.getKey(), DailyTimeIntervalTrigger2);
                    this.scheduler.resumeTrigger(trigger.getKey());
                    this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                    break;
                }
                case "CronTrigger": {
                    CronTriggerImpl CronTriggerImpl2 = (CronTriggerImpl)trigger;
                    if (jobInfo.getCronexpression() == null) {
                        jobInfo.setCronexpression(String.valueOf(CronTriggerImpl2.getCronExpression()));
                    }
                    if (jobInfo.getStartime() == null) {
                        jobInfo.setStartime(sdf.format(trigger.getStartTime()));
                    }
                    if (jobInfo.getEndtime() == null) {
                        jobInfo.setEndtime(sdf.format(trigger.getEndTime()));
                    }
                    if (jobInfo.getTimezone() == null) {
                        jobInfo.setTimezone(String.valueOf(CronTriggerImpl2.getTimeZone()));
                    }
                    if (jobInfo.getPriority() == null) {
                        jobInfo.setPriority(String.valueOf(CronTriggerImpl2.getPriority()));
                    }
                    System.out.println(jobInfo.getStartime() + " " + jobInfo.getEndtime());
                    CronTrigger cronTrigger = (CronTrigger)triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)jobInfo.getCronexpression()).inTimeZone(TimeZone.getTimeZone(jobInfo.getTimezone()))).startAt((java.util.Date)Date.valueOf(jobInfo.getStartime())).endAt((java.util.Date)Date.valueOf(jobInfo.getEndtime())).withPriority(Integer.parseInt(jobInfo.getPriority())).startNow().build();
                    this.scheduler.pauseTrigger(trigger.getKey());
                    System.out.println(trigger.getKey());
                    this.scheduler.rescheduleJob(trigger.getKey(), (Trigger)cronTrigger);
                    this.scheduler.resumeTrigger(trigger.getKey());
                    this.vScriptTagScervice.deleteScriptTag(jobInfo.getTriggername(), jobInfo.getTriggergroup());
                }
            }
        }
        catch (SchedulerException e) {
            log.error("\u4efb\u52a1\u8c03\u5ea6\u5931\u8d25");
            return false;
        }
        return true;
    }

    @Override
    public boolean updateTrigger(String oldtriggername, String oldtriggergroup, JobInfo jobinfo) throws SchedulerException {
        System.out.println("oldname:" + oldtriggername + " oldgergroup:" + oldtriggergroup);
        if (this.scheduler.getTrigger(TriggerKey.triggerKey((String)oldtriggername, (String)oldtriggergroup)) == null) {
            log.error("\u89e6\u53d1\u5668\u4e0d\u5b58\u5728");
            return false;
        }
        System.out.println("oldname:" + oldtriggername + " oldgergroup" + oldtriggergroup);
        Trigger trigger = this.scheduler.getTrigger(TriggerKey.triggerKey((String)oldtriggername, (String)oldtriggergroup));
        System.out.println("\u89e6\u53d1\u5668" + String.valueOf(trigger));
        JobDetail jobDetail = this.scheduler.getJobDetail(trigger.getJobKey());
        jobinfo.setJobname(trigger.getJobKey().getName());
        jobinfo.setJobgroup(trigger.getJobKey().getGroup());
        jobinfo.setJobclassname(jobDetail.getJobClass().getName());
        jobinfo.setDescription(jobDetail.getDescription());
        this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)oldtriggername, (String)oldtriggergroup));
        this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)oldtriggername, (String)oldtriggergroup));
        System.out.println(jobinfo);
        this.vScriptTagScervice.deleteScriptTag(oldtriggername, oldtriggergroup);
        return this.jobTOtri(jobinfo) == 0;
    }

    @Override
    public int updateJob(String jobclassname, String jobname, String jobgroup, String isCustomJobDetail, String jobDetail, String description) throws SchedulerException {
        int result = 0;
        if (jobname == null || jobgroup == null || jobclassname == null) {
            log.error("\u4efb\u52a1\u540d\u79f0,\u4efb\u52a1\u5206\u7ec4,\u4efb\u52a1\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            return -5;
        }
        System.out.println("jobname:" + jobname + " jobgroup:" + jobgroup + " jobclassname:" + jobclassname);
        if (this.scheduler.getJobDetail(JobKey.jobKey((String)jobname, (String)jobgroup)) == null) {
            log.error("\u4efb\u52a1\u4e0d\u5b58\u5728");
            return -1;
        }
        try {
            CreatJobDetail instance;
            if (jobDetail == null && "true".equals(isCustomJobDetail)) {
                log.error("\u5f00\u542f\u81ea\u52a8\u6ce8\u5165jobDetail\u65f6,jobDetail\u4e0d\u80fd\u4e3a\u7a7a");
                return -7;
            }
            if (isCustomJobDetail == null) {
                isCustomJobDetail = "false";
            }
            if ("false".equals(isCustomJobDetail)) {
                jobDetail = this.TRIGGER_GROUP_NAME;
                this.vScriptTagScervice.deleteScriptTag(jobname, jobgroup);
            } else {
                this.vScriptTagScervice.addScriptTag(jobname, jobgroup, jobDetail, "JobDetail");
            }
            JobDetail oldJobDetail = this.scheduler.getJobDetail(JobKey.jobKey((String)jobname, (String)jobgroup));
            if (StrUtil.isBlank((CharSequence)description)) {
                description = oldJobDetail.getDescription();
            }
            if (StrUtil.isBlank((CharSequence)jobclassname)) {
                jobclassname = oldJobDetail.getJobClass().getName();
            }
            JobDetail jobDetailimpl = null;
            Class<CreatJobDetail> c = this.applicationContext.getType(jobDetail).asSubclass(CreatJobDetail.class);
            Constructor<CreatJobDetail> constructor = c.getDeclaredConstructor(ApplicationContext.class);
            CreatJobDetail creatJobDetail = instance = constructor.newInstance(this.applicationContext);
            jobDetailimpl = creatJobDetail.createdetail(jobclassname, jobname, jobgroup, description);
            this.pauseJob(jobname, jobgroup);
            this.scheduler.addJob(jobDetailimpl, true);
        }
        catch (InvocationTargetException e) {
            log.error(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage());
        }
        catch (InstantiationException e) {
            log.error(e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public Boolean deleteAllJob() {
        String jobname = null;
        String jobgroup = null;
        String triggername = null;
        String triggergroup = null;
        try {
            List triigergroups = this.scheduler.getTriggerGroupNames();
            for (String triigergroup : triigergroups) {
                Set triggerKeys = this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)triigergroup));
                for (TriggerKey triggerKey : triggerKeys) {
                    triggername = triggerKey.getName();
                    triggergroup = triggerKey.getGroup();
                    this.scheduler.unscheduleJob(triggerKey);
                    this.vScriptTagScervice.deleteScriptTag(triggername, triggergroup);
                }
            }
            List groups = this.scheduler.getJobGroupNames();
            for (String group : groups) {
                Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)group));
                for (JobKey jobKey : jobKeys) {
                    jobname = jobKey.getName();
                    jobgroup = jobKey.getGroup();
                    this.scheduler.deleteJob(jobKey);
                    this.vScriptTagScervice.deleteScriptTag(jobname, jobgroup);
                }
            }
            return true;
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean jobUNtri(String triggername, String triggergroup) throws SchedulerException {
        boolean result = true;
        boolean a = this.scheduler.checkExists(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        if (!a) {
            return false;
        }
        this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)triggername, (String)triggergroup));
        this.vScriptTagScervice.deleteScriptTag(triggername, triggergroup);
        return result;
    }

    @Override
    public boolean shutdown(boolean iswait) {
        try {
            this.scheduler.shutdown(iswait);
            return true;
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean standby() {
        try {
            this.scheduler.standby();
            return true;
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean start() {
        try {
            this.scheduler.start();
            return true;
        }
        catch (SchedulerException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public <T> void createDelayedQueue(DelayedJob job, T parameter, String ID, Long time) throws SchedulerException {
        this.dynamicBeanOperate.registerBeanByPro(ID, job.getClass(), parameter);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(ID, "DelayedQueue").startAt((java.util.Date)new Date(System.currentTimeMillis() + time)).build();
        this.scheduler.scheduleJob(JobBuilder.newJob(MyQuartzJobWrapper.class).usingJobData("targetBeanName", ID).withIdentity(ID, "DelayedQueue").storeDurably().build(), trigger);
    }

    @Override
    public <T> void createDelayedQueue(DelayedJob job, T parameter, String ID, Trigger trigger) throws SchedulerException {
        this.dynamicBeanOperate.registerBeanByPro(ID, job.getClass(), parameter);
        this.scheduler.scheduleJob(JobBuilder.newJob(MyQuartzJobWrapper.class).usingJobData("targetBeanName", ID).withIdentity(ID, "DelayedQueue").storeDurably().build(), trigger);
    }

    @Override
    public <T> void createDelayedQueue(DelayedJob job, T parameter, String ID, LocalDateTime time) throws SchedulerException {
        this.dynamicBeanOperate.registerBeanByPro(ID, job.getClass(), parameter);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(ID, "DelayedQueue").startAt(Date.from(time.atZone(ZoneId.systemDefault()).toInstant())).build();
        this.scheduler.scheduleJob(JobBuilder.newJob(MyQuartzJobWrapper.class).usingJobData("targetBeanName", ID).withIdentity(ID, "DelayedQueue").storeDurably().build(), trigger);
    }
}

