/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.quartz.po;

import com.visualization.cloud.sse.SSEUtil;
import java.util.Map;
import java.util.Objects;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValues;

public abstract class QuartzJobBeanAbstract
implements Job {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobBeanAbstract.class);
    private static final ThreadLocal<SsePayload> currentPayload = new ThreadLocal();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)this);
            MutablePropertyValues pvs = new MutablePropertyValues();
            pvs.addPropertyValues((Map)context.getScheduler().getContext());
            pvs.addPropertyValues((Map)context.getMergedJobDataMap());
            bw.setPropertyValues((PropertyValues)pvs, true);
        }
        catch (SchedulerException ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        this.executeInternal(context);
        if (Objects.nonNull(currentPayload.get())) {
            SSEUtil.MessageSender.sendMessage(QuartzJobBeanAbstract.currentPayload.get().key, QuartzJobBeanAbstract.currentPayload.get().data);
        }
    }

    protected abstract void executeInternal(JobExecutionContext var1) throws JobExecutionException;

    protected final void setSseData(String key, String data) {
        currentPayload.set(new SsePayload(key, data));
    }

    private record SsePayload(String key, String data) {
    }
}

