/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.scriptBuilder;

import com.visualization.cloud.scriptBuilder.beanhandling.IGroovyBeanService;
import com.visualization.cloud.scriptBuilder.beanhandling.entity.DTO.SelectGroovyBeanInfoConditionDTO;
import com.visualization.cloud.scriptBuilder.beanhandling.entity.GroovyBeanInfo;
import com.visualization.cloud.scriptBuilder.beanhandling.impl.GroovyBeanServiceImpl;
import com.visualization.cloud.util.resp.ResultData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"${server.port}"})
@RestController
@RequestMapping(value={"/groovyBean"})
public class GroovyBeanController {
    private static final Logger log = LoggerFactory.getLogger(GroovyBeanController.class);
    private final IGroovyBeanService groovyBeanService;

    @Autowired
    private GroovyBeanController(GroovyBeanServiceImpl groovyBeanService) {
        this.groovyBeanService = groovyBeanService;
    }

    @PostMapping(value={"/loadGroovyBean"})
    @Operation(summary="\u5b89\u88c5GroovyBean")
    @Tag(name="\u5b89\u88c5")
    @ResponseBody
    public ResultData<String> loadGroovyBean(@RequestParam String className) throws SchedulerException, ClassNotFoundException {
        this.groovyBeanService.loadGroovyBean(className);
        return ResultData.success("\u5b89\u88c5\u6210\u529f");
    }

    @PostMapping(value={"/unloadGroovyBean"})
    @Operation(summary="\u5378\u8f7dGroovyBean")
    @Tag(name="\u5378\u8f7d")
    @ResponseBody
    public ResultData<String> unloadGroovyBean(@RequestParam String className) throws SchedulerException {
        this.groovyBeanService.unloadGroovyBean(className);
        return ResultData.success("\u5378\u8f7d\u6210\u529f");
    }

    @PostMapping(value={"/selectAllLoadGroovyBean"})
    @Operation(summary="\u67e5\u8be2\u6240\u6709\u5df2\u542f\u52a8Bean")
    @Tag(name="\u67e5\u8be2\u6240\u6709")
    @ResponseBody
    public ResultData<List<GroovyBeanInfo>> selectAllLoadGroovyBean(@RequestBody SelectGroovyBeanInfoConditionDTO selectGroovyBeanInfoConditionDTO) throws SchedulerException {
        return ResultData.success(this.groovyBeanService.selectAllLoadedGroovyBean(selectGroovyBeanInfoConditionDTO));
    }

    @PostMapping(value={"/selectAllUnloadGroovyBean"})
    @Operation(summary="\u67e5\u8be2\u6240\u6709\u672a\u542f\u52a8Bean")
    @Tag(name="\u67e5\u8be2\u6240\u6709")
    @ResponseBody
    public ResultData<List<GroovyBeanInfo>> selectAllUnloadGroovyBean(@RequestBody SelectGroovyBeanInfoConditionDTO selectGroovyBeanInfoConditionDTO) throws SchedulerException {
        return ResultData.success(this.groovyBeanService.selectAllUnLoadGroovyBean(selectGroovyBeanInfoConditionDTO));
    }

    @PostMapping(value={"/selectAllGroovyBean"})
    @Operation(summary="\u67e5\u8be2\u6240\u6709Bean")
    @Tag(name="\u67e5\u8be2\u6240\u6709")
    @ResponseBody
    public ResultData<List<GroovyBeanInfo>> selectAllGroovyBean(@RequestBody SelectGroovyBeanInfoConditionDTO selectGroovyBeanInfoConditionDTO) {
        List<GroovyBeanInfo> list = this.groovyBeanService.selectAllGroovyBean(selectGroovyBeanInfoConditionDTO);
        return ResultData.success(list);
    }

    @PostMapping(value={"/selectGroovyBean"})
    @Operation(summary="\u67e5\u8be2Bean\u8be6\u60c5")
    @Tag(name="\u67e5\u8be2Bean\u8be6\u60c5")
    @ResponseBody
    public ResultData<GroovyBeanInfo> selectGroovyBean(@RequestParam String className) {
        return ResultData.success(this.groovyBeanService.selectGroovyBean(className));
    }
}

