/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.scriptBuilder;

import com.visualization.cloud.scriptBuilder.DAO.entity.JobCodeEntity;
import com.visualization.cloud.scriptBuilder.DAO.entity.ScriptTypeEnums;
import com.visualization.cloud.scriptBuilder.DAO.entity.VQrtzScript;
import com.visualization.cloud.scriptBuilder.DAO.entity.po.UpdateScriptPO;
import com.visualization.cloud.scriptBuilder.datahandling.IDatabaseScript;
import com.visualization.cloud.scriptBuilder.datahandling.entity.DTO.SelectScriptInfoConditionDTO;
import com.visualization.cloud.util.resp.ResultData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"${server.port}"})
@RestController
@RequestMapping(value={"/scriptBuilder"})
public class JobBuilderController {
    private static final Logger log = LoggerFactory.getLogger(JobBuilderController.class);
    @Resource
    private IDatabaseScript databaseScript;

    @PostMapping(value={"/saveJobToDB"})
    @Operation(summary="\u4fdd\u5b58job\u5230\u6570\u636e\u5e93")
    @Tag(name="\u4fdd\u5b58")
    @ResponseBody
    public ResultData<String> saveJobToDB(@RequestBody JobCodeEntity jobCodeEntity) {
        this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.JOB);
        return ResultData.success("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveJobDetailToDB"})
    @Operation(summary="\u4fdd\u5b58JobDetail\u5230\u6570\u636e\u5e93")
    @Tag(name="\u4fdd\u5b58")
    @ResponseBody
    public ResultData<String> saveJobDetailToDB(@RequestBody JobCodeEntity jobCodeEntity) {
        this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.JOB_DETAIL);
        return ResultData.success("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveTriggerToDB"})
    @Operation(summary="\u4fdd\u5b58trigger\u5230\u6570\u636e\u5e93")
    @Tag(name="\u4fdd\u5b58")
    @ResponseBody
    public ResultData<String> saveTriggerToDB(@RequestBody JobCodeEntity jobCodeEntity, String Type2) {
        switch (Type2) {
            case "SimpleTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.SIMPLE_TRIGGER);
                break;
            }
            case "CalendarIntervalTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.CALENDAR_INTERVAL_TRIGGER);
                break;
            }
            case "DailyTimeIntervalTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.DAILY_TIME_INTERVAL_TRIGGER);
                break;
            }
            case "CronTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.CRON_TRIGGER);
                break;
            }
            default: {
                return ResultData.fail("500", "\u7c7b\u578b\u9519\u8bef");
            }
        }
        return ResultData.success("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/saveUpdateTriggerToDB"})
    @Operation(summary="\u4fdd\u5b58updateTrigger\u5230\u6570\u636e\u5e93")
    @Tag(name="\u4fdd\u5b58")
    @ResponseBody
    public ResultData<String> saveUpdateTriggerToDB(@RequestBody JobCodeEntity jobCodeEntity, String Type2) {
        switch (Type2) {
            case "SimpleUpdateTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.SIMPLE_UPDATE_TRIGGER);
                break;
            }
            case "CalendarUpdateIntervalTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.CALENDAR_UPDATE_INTERVAL_TRIGGER);
                break;
            }
            case "DailyUpdateTimeIntervalTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.DAILY_UPDATE_TIME_INTERVAL_TRIGGER);
                break;
            }
            case "CronUpdateTrigger": {
                this.databaseScript.recorder(jobCodeEntity.getCode(), ScriptTypeEnums.CRON_UPDATE_TRIGGER);
                break;
            }
            default: {
                return ResultData.fail("500", "\u7c7b\u578b\u9519\u8bef");
            }
        }
        return ResultData.success("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/deleteScript"})
    @Operation(summary="\u5220\u9664\u811a\u672c")
    @Tag(name="\u5220\u9664")
    @ResponseBody
    public ResultData<String> deleteScript(@RequestParam Integer id) throws SchedulerException {
        this.databaseScript.delete(id);
        return ResultData.success("\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/updateScript"})
    @Operation(summary="\u66f4\u65b0\u811a\u672c:\u4ec5\u66f4\u65b0\u811a\u672c\u5185\u5bb9\u800c\u4e0d\u66f4\u65b0\u811a\u672c\u5173\u7cfb")
    @Tag(name="\u66f4\u65b0")
    @ResponseBody
    public ResultData<String> updateScript(@RequestBody UpdateScriptPO updateScriptPO) throws SchedulerException {
        this.databaseScript.update(updateScriptPO.getId(), updateScriptPO.getScript());
        return ResultData.success("\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/selectAllScript"})
    @Operation(summary="\u67e5\u8be2\u6240\u6709\u811a\u672c:\u4f20\u5165\u7c7b\u578b,\u6216\u8005\u4e0d\u4f20-->\u67e5\u6240\u6709")
    @Tag(name="\u67e5\u8be2")
    @ResponseBody
    public ResultData<List<VQrtzScript>> selectAllScript(SelectScriptInfoConditionDTO selectScriptInfoConditionDTO) throws SchedulerException {
        return ResultData.success(this.databaseScript.selectAll(selectScriptInfoConditionDTO));
    }

    @PostMapping(value={"/selectScript"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e2a\u811a\u672c")
    @Tag(name="\u67e5\u8be2")
    @ResponseBody
    public ResultData<VQrtzScript> selectScript(@RequestParam Integer id) throws SchedulerException {
        return ResultData.success(this.databaseScript.select(id));
    }

    @PostMapping(value={"/selectFilterCriteria"})
    @Operation(summary="\u67e5\u8be2\u811a\u672c\u7684\u6240\u6709\u7c7b\u578b:\u6570\u636e\u5b57\u5178")
    @Tag(name="\u67e5\u8be2")
    @ResponseBody
    public ResultData<List<String>> selectFilterCriteria() {
        return ResultData.success(this.databaseScript.selectFilterCriteria());
    }

    @PostMapping(value={"/loadFromDB"})
    @Operation(summary="\u52a0\u8f7d\u811a\u672c\u4ece\u6570\u636e\u5e93\u4e2d")
    @Tag(name="\u52a0\u8f7d")
    @ResponseBody
    public ResultData<String> loadJobFromDB() {
        this.databaseScript.load();
        return ResultData.success("\u52a0\u8f7d\u6210\u529f");
    }
}

