/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.scriptBuilder.beanhandling.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.visualization.cloud.quartz.config.GroovyClassLoaderKillClassEnhance;
import com.visualization.cloud.scriptBuilder.DAO.entity.VQrtzScript;
import com.visualization.cloud.scriptBuilder.DAO.mapper.VQrtzScriptMapper;
import com.visualization.cloud.scriptBuilder.beanhandling.IGroovyBeanService;
import com.visualization.cloud.scriptBuilder.beanhandling.entity.DTO.SelectGroovyBeanInfoConditionDTO;
import com.visualization.cloud.scriptBuilder.beanhandling.entity.GroovyBeanInfo;
import com.visualization.cloud.util.DynamicBeanOperate;
import com.visualization.cloud.util.exception.errCode.GroovyBeanExceptionCodeMsg;
import com.visualization.cloud.util.exception.exception.GroovyBeanException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GroovyBeanServiceImpl
implements IGroovyBeanService {
    private final DynamicBeanOperate dynamicBeanRegistrar;
    private final GroovyClassLoaderKillClassEnhance classLoader;
    private final VQrtzScriptMapper vQrtzScriptMapper;
    private final ApplicationContext applicationContext;
    private final Scheduler scheduler;

    @Autowired
    public GroovyBeanServiceImpl(DynamicBeanOperate dynamicBeanRegistrar, GroovyClassLoaderKillClassEnhance classLoader, VQrtzScriptMapper vQrtzScriptMapper, ApplicationContext applicationContext, Scheduler scheduler) {
        this.dynamicBeanRegistrar = dynamicBeanRegistrar;
        this.classLoader = classLoader;
        this.vQrtzScriptMapper = vQrtzScriptMapper;
        this.applicationContext = applicationContext;
        this.scheduler = scheduler;
    }

    @Override
    public void loadGroovyBean(String className) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CLASS_NAME", (Object)className);
        VQrtzScript vQrtzScript = (VQrtzScript)this.vQrtzScriptMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(vQrtzScript)) {
            throw new GroovyBeanException(GroovyBeanExceptionCodeMsg.BEAN_NO_EXIST_IN_DB);
        }
        if (this.applicationContext.containsBean(this.getBeanName(className))) {
            throw new GroovyBeanException(GroovyBeanExceptionCodeMsg.BEAN_EXIST);
        }
        Class clazz = this.classLoader.parseClass(vQrtzScript.getScript());
        this.dynamicBeanRegistrar.registerBean(this.getBeanName(className), clazz);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"CLASS_NAME", (Object)className)).set((Object)"BEAN_STATE", (Object)true);
        this.vQrtzScriptMapper.update((Wrapper)updateWrapper);
    }

    @Override
    public void unloadGroovyBean(String className) throws SchedulerException {
        String beanName = this.getBeanName(className);
        boolean exists = this.applicationContext.containsBean(beanName);
        if (!exists) {
            throw new GroovyBeanException(GroovyBeanExceptionCodeMsg.BEAN_NO_EXIST_IN_CONTEXT);
        }
        Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.anyJobGroup());
        for (JobKey jobKey : jobKeys) {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (!jobDetail.getJobClass().getSimpleName().equals(beanName)) continue;
            this.scheduler.deleteJob(jobKey);
        }
        this.classLoader.KillClass(this.getFullClassNameByBeanName(beanName));
        this.dynamicBeanRegistrar.unregisterBean(beanName);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"CLASS_NAME", (Object)className)).set((Object)"BEAN_STATE", (Object)false);
        this.vQrtzScriptMapper.update((Wrapper)updateWrapper);
    }

    @Override
    public List<GroovyBeanInfo> selectAllLoadedGroovyBean(SelectGroovyBeanInfoConditionDTO selectGroovyBeanInfoConditionDTO) {
        List vQrtzScriptList = this.vQrtzScriptMapper.selectList((Wrapper)this.getQueryWrapper(selectGroovyBeanInfoConditionDTO, true));
        ArrayList<GroovyBeanInfo> groovyBeanInfoList = new ArrayList<GroovyBeanInfo>();
        for (VQrtzScript vQrtzScript : vQrtzScriptList) {
            String className = vQrtzScript.getClassName();
            String beanName = this.getBeanName(className);
            GroovyBeanInfo groovyBeanInfo = new GroovyBeanInfo();
            boolean exists = this.applicationContext.containsBean(beanName);
            if (!exists) continue;
            groovyBeanInfo.setExists(exists);
            groovyBeanInfo.setScriptType(vQrtzScript.getScriptType());
            groovyBeanInfo.setClassName(vQrtzScript.getClassName());
            groovyBeanInfoList.add(groovyBeanInfo);
        }
        return groovyBeanInfoList;
    }

    @Override
    public List<GroovyBeanInfo> selectAllUnLoadGroovyBean(SelectGroovyBeanInfoConditionDTO selectGroovyBeanInfoConditionDTO) {
        List vQrtzScriptList = this.vQrtzScriptMapper.selectList((Wrapper)this.getQueryWrapper(selectGroovyBeanInfoConditionDTO, false));
        ArrayList<GroovyBeanInfo> groovyBeanInfoList = new ArrayList<GroovyBeanInfo>();
        for (VQrtzScript vQrtzScript : vQrtzScriptList) {
            String className = vQrtzScript.getClassName();
            String beanName = this.getBeanName(className);
            GroovyBeanInfo groovyBeanInfo = new GroovyBeanInfo();
            boolean exists = this.applicationContext.containsBean(beanName);
            if (exists) continue;
            groovyBeanInfo.setExists(exists);
            groovyBeanInfo.setScriptType(vQrtzScript.getScriptType());
            groovyBeanInfo.setClassName(vQrtzScript.getClassName());
            groovyBeanInfoList.add(groovyBeanInfo);
        }
        return groovyBeanInfoList;
    }

    @Override
    public List<GroovyBeanInfo> selectAllGroovyBean(SelectGroovyBeanInfoConditionDTO selectGroovyBeanInfoConditionDTO) {
        List vQrtzScriptList = this.vQrtzScriptMapper.selectList((Wrapper)this.getQueryWrapper(selectGroovyBeanInfoConditionDTO, null));
        ArrayList<GroovyBeanInfo> groovyBeanInfoList = new ArrayList<GroovyBeanInfo>();
        for (VQrtzScript vQrtzScript : vQrtzScriptList) {
            String className = vQrtzScript.getClassName();
            GroovyBeanInfo groovyBeanInfo = new GroovyBeanInfo();
            String beanName = this.getBeanName(className);
            boolean exists = this.applicationContext.containsBean(beanName);
            groovyBeanInfo.setExists(exists);
            groovyBeanInfo.setScriptType(vQrtzScript.getScriptType());
            groovyBeanInfo.setClassName(vQrtzScript.getClassName());
            groovyBeanInfoList.add(groovyBeanInfo);
        }
        return groovyBeanInfoList;
    }

    @Override
    public GroovyBeanInfo selectGroovyBean(String className) {
        String beanName = this.getBeanName(className);
        GroovyBeanInfo groovyBeanInfo = new GroovyBeanInfo();
        boolean exists = this.applicationContext.containsBean(beanName);
        groovyBeanInfo.setExists(exists);
        groovyBeanInfo.setClassName(className);
        return groovyBeanInfo;
    }

    private String getBeanName(String className) {
        return className;
    }

    private String getFullClassNameByBeanName(String beanName) {
        Object o = this.applicationContext.getBean(beanName);
        return o.getClass().getName();
    }

    private QueryWrapper<VQrtzScript> getQueryWrapper(SelectGroovyBeanInfoConditionDTO selectGroovyBeanInfoConditionDTO, Boolean flag) {
        String getKeywords = selectGroovyBeanInfoConditionDTO.getKeywords();
        String filterCriteria = selectGroovyBeanInfoConditionDTO.getFilterCriteria();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (Objects.nonNull(flag)) {
            queryWrapper.eq((Object)"BEAN_STATE", (Object)flag);
        }
        if (StrUtil.isNotBlank((CharSequence)getKeywords)) {
            queryWrapper.like((Object)"CLASS_NAME", (Object)getKeywords);
        }
        if (StrUtil.isNotBlank((CharSequence)filterCriteria)) {
            queryWrapper.eq((Object)"SCRIPT_TYPE", (Object)filterCriteria);
        }
        return queryWrapper;
    }
}

