/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.scriptBuilder.datahandling.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.visualization.cloud.quartz.config.GroovyClassLoaderKillClassEnhance;
import com.visualization.cloud.quartz.jobService.JobServiceImp;
import com.visualization.cloud.quartz.po.JobInfo;
import com.visualization.cloud.scriptBuilder.DAO.entity.ScriptTypeEnums;
import com.visualization.cloud.scriptBuilder.DAO.entity.VQrtzScript;
import com.visualization.cloud.scriptBuilder.DAO.entity.VScriptTag;
import com.visualization.cloud.scriptBuilder.DAO.mapper.VQrtzScriptMapper;
import com.visualization.cloud.scriptBuilder.DAO.mapper.VScriptTagMapper;
import com.visualization.cloud.scriptBuilder.datahandling.IDatabaseScript;
import com.visualization.cloud.scriptBuilder.datahandling.VScriptTagScervice;
import com.visualization.cloud.scriptBuilder.datahandling.entity.DTO.SelectScriptInfoConditionDTO;
import com.visualization.cloud.util.DynamicBeanOperate;
import com.visualization.cloud.util.exception.errCode.JobBuilderExceptionCodeMsg;
import com.visualization.cloud.util.exception.exception.JobBuilderException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DatabaseScriptImpl
implements IDatabaseScript {
    private static final Logger log = LoggerFactory.getLogger(DatabaseScriptImpl.class);
    private final VQrtzScriptMapper vQrtzJobScriptMapper;
    private final GroovyClassLoaderKillClassEnhance classLoader;
    private final DynamicBeanOperate dynamicBeanRegistrar;
    private final ApplicationContext applicationContext;
    private final Scheduler scheduler;
    private final VScriptTagScervice vScriptTagScervice;
    private final JobServiceImp jobServiceImp;
    private static String classPattern = "(class\\s+)(\\w+)(\\s+implements\\s+Job\\s*\\{)";

    public DatabaseScriptImpl(VQrtzScriptMapper vQrtzJobScriptMapper, GroovyClassLoaderKillClassEnhance classLoader, DynamicBeanOperate dynamicBeanRegistrar, ApplicationContext applicationContext, VScriptTagMapper vScriptTagMapper, JobServiceImp jobServiceImp, VScriptTagScervice vScriptTagScervice, Scheduler scheduler) {
        this.vQrtzJobScriptMapper = vQrtzJobScriptMapper;
        this.classLoader = classLoader;
        this.dynamicBeanRegistrar = dynamicBeanRegistrar;
        this.applicationContext = applicationContext;
        this.scheduler = scheduler;
        this.vScriptTagScervice = vScriptTagScervice;
        this.jobServiceImp = jobServiceImp;
    }

    @Override
    public void load() {
        List vQrtzJobScriptList = this.vQrtzJobScriptMapper.selectList(null);
        for (VQrtzScript script : vQrtzJobScriptList) {
            this.loadJobClass(script.getScript());
        }
    }

    private void loadJobClass(String code) {
        Class clazz = this.classLoader.parseClass(code);
    }

    @Override
    public void recorder(String script, ScriptTypeEnums type) {
        Class clazz = this.classLoader.parseClass(script);
        String className = clazz.getSimpleName();
        String beanName = this.getBeanName(className);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollUtil.isNotEmpty((Collection)this.vQrtzJobScriptMapper.selectList((Wrapper)queryWrapper.eq((Object)"CLASS_NAME", (Object)className)))) {
            throw new JobBuilderException(JobBuilderExceptionCodeMsg.JOB_SCRIPT_EXISTS);
        }
        this.dynamicBeanRegistrar.registerBean(beanName, clazz);
        VQrtzScript vQrtzScript = new VQrtzScript().setScript(script).setClassName(className).setScriptType(type.getType()).setBeanState(true);
        this.vQrtzJobScriptMapper.insert(vQrtzScript);
    }

    @Override
    public void delete(Integer scriptId) throws SchedulerException {
        VQrtzScript vQrtzScript = (VQrtzScript)this.vQrtzJobScriptMapper.selectById(scriptId);
        String scriptType = vQrtzScript.getScriptType();
        String jobClassName = vQrtzScript.getClassName();
        String beanName = this.getBeanName(jobClassName);
        boolean bean_exists = this.applicationContext.containsBean(beanName);
        if (bean_exists) {
            if (scriptType.equals(ScriptTypeEnums.JOB.getType())) {
                Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.anyJobGroup());
                for (JobKey jobKey : jobKeys) {
                    JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
                    if (!jobDetail.getJobClass().getSimpleName().equals(jobClassName)) continue;
                    this.scheduler.deleteJob(jobKey);
                }
            }
            System.out.println("before" + Arrays.toString(this.classLoader.getLoadedClasses()));
            this.classLoader.KillClass(this.getFullClassNameByBeanName(beanName));
            System.out.println("after" + Arrays.toString(this.classLoader.getLoadedClasses()));
            this.dynamicBeanRegistrar.unregisterBean(beanName);
        }
        this.vQrtzJobScriptMapper.deleteById(scriptId);
        this.vScriptTagScervice.deleteScriptTag(jobClassName);
    }

    @Override
    public void update(Integer id, String script) throws SchedulerException {
        block6: {
            String newScriptClassName;
            VQrtzScript vQrtzScript = (VQrtzScript)this.vQrtzJobScriptMapper.selectById(id);
            String className = vQrtzScript.getClassName();
            if (!className.equals(newScriptClassName = this.extractClassName(script))) {
                throw new RuntimeException("\u811a\u672c\u7c7b\u540d\u5fc5\u987b\u76f8\u540c");
            }
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"ID", (Object)id)).set((Object)"SCRIPT", (Object)script);
            this.vQrtzJobScriptMapper.update((Wrapper)updateWrapper);
            Class clazz = this.classLoader.parseClass(script);
            boolean bean_exists = this.applicationContext.containsBean(this.getBeanName(className));
            if (bean_exists) {
                this.dynamicBeanRegistrar.unregisterBean(this.getBeanName(className));
            }
            this.dynamicBeanRegistrar.registerBean(newScriptClassName, clazz);
            String scriptType = vQrtzScript.getScriptType();
            if (Objects.equals(scriptType, "job")) break block6;
            if ("job_detail".equals(scriptType)) {
                List<VScriptTag> vScriptTags = this.vScriptTagScervice.getScriptTag(null, null, className, "job_detail");
                for (VScriptTag vScriptTag : vScriptTags) {
                    this.jobServiceImp.updateJob(null, vScriptTag.getNameTag(), vScriptTag.getGroupTag(), "true", className, null);
                }
            } else {
                List<VScriptTag> vScriptTags = this.vScriptTagScervice.getScriptTag(null, null, className, vQrtzScript.getScriptType());
                JobInfo jobInfo = new JobInfo();
                for (VScriptTag vScriptTag : vScriptTags) {
                    jobInfo.setTriggername(vScriptTag.getNameTag());
                    jobInfo.setTriggergroup(vScriptTag.getGroupTag());
                    jobInfo.setTrigger(className);
                    jobInfo.setIsCustomTrigger("true");
                    this.jobServiceImp.jobTOtri(jobInfo);
                }
            }
        }
    }

    @Override
    public List<VQrtzScript> selectAll(SelectScriptInfoConditionDTO selectScriptInfoConditionDTO) {
        String type = selectScriptInfoConditionDTO.getType();
        String className = selectScriptInfoConditionDTO.getClassName();
        Boolean beanState = selectScriptInfoConditionDTO.getBeanState();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StrUtil.isNotBlank((CharSequence)type), VQrtzScript::getScriptType, (Object)type)).like(StrUtil.isNotBlank((CharSequence)className), VQrtzScript::getClassName, (Object)className)).eq(Objects.nonNull(beanState), VQrtzScript::getBeanState, (Object)beanState);
        return this.vQrtzJobScriptMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public VQrtzScript select(Integer id) {
        return (VQrtzScript)this.vQrtzJobScriptMapper.selectById(id);
    }

    @Override
    public List<String> selectFilterCriteria() {
        return ScriptTypeEnums.getAllTypes();
    }

    private String getBeanName(String className) {
        return className;
    }

    private String extractClassName(String script) {
        CompilationUnit unit = new CompilationUnit();
        unit.addSource("script.groovy", script);
        unit.compile(3);
        List classes = unit.getAST().getClasses();
        if (classes.isEmpty()) {
            throw new RuntimeException("\u811a\u672c\u4e2d\u6ca1\u6709\u5b9a\u4e49\u7c7b");
        }
        return ((ClassNode)classes.get(0)).getNameWithoutPackage();
    }

    private String getFullClassNameByBeanName(String beanName) {
        Object o = this.applicationContext.getBean(beanName);
        return o.getClass().getName();
    }
}

