/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.sse;

import com.visualization.cloud.sse.listener.manager.ListenerEventManager;
import com.visualization.cloud.sse.listener.manager.ListenerManager;
import com.visualization.cloud.util.resp.ResultData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import org.quartz.SchedulerException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sse/config"})
@Tag(name="\u76d1\u542c\u5668\u7ba1\u7406")
public class ListenerConfigController {
    private final ListenerManager listenerManager;
    private final ListenerEventManager listenerEventManager;

    public ListenerConfigController(ListenerManager listenerManager, ListenerEventManager listenerEventManager) {
        this.listenerManager = listenerManager;
        this.listenerEventManager = listenerEventManager;
    }

    @GetMapping(value={"/getListenerStates"})
    @Operation(description="\u83b7\u53d6\u76d1\u542c\u5668\u72b6\u6001")
    public ResultData<Map<String, Boolean>> getListenerStates() {
        return ResultData.success(this.listenerManager.getListenerStates());
    }

    @PostMapping(value={"/getListenerEventStates"})
    @Operation(description="\u83b7\u5f97\u4e0d\u540c\u76d1\u542c\u5668\u76d1\u542c\u7684\u76d1\u542c\u7684\u4e8b\u4ef6\u72b6\u6001")
    public ResultData<Map<String, Boolean>> getListenerEventStates(@RequestParam @Schema(description="job|trigger|scheduler") String listener) {
        return ResultData.success(this.listenerEventManager.getListenerEvent(listener));
    }

    @PostMapping(value={"/toggleListenerState"})
    @Operation(description="\u5207\u6362\u76d1\u542c\u5668\u7684\u72b6\u6001")
    public ResultData<String> toggleListener(@RequestParam @Schema(description="job|trigger|scheduler") String listener, @RequestParam @Schema(description="true|false") boolean enabled) throws SchedulerException {
        this.listenerManager.toggleListener(listener, enabled);
        return ResultData.success("\u5207\u6362\u6210\u529f");
    }

    @PostMapping(value={"/toggleListenerEventState"})
    @Operation(description="\u5207\u6362\u76d1\u542c\u5668\u4e2d\u6307\u5b9a\u4e8b\u4ef6\u7684\u72b6\u6001")
    public ResultData<String> toggleListenerEventState(@RequestParam @Schema(description="job|trigger|scheduler") String listener, @RequestParam @Schema(description="\u4f7f\u7528/sse/config/getListenerEventStates\u83b7\u5f97\u7684\u503c") String event, @RequestParam @Schema(description="true|false") boolean state) {
        this.listenerEventManager.setListenerEvent(listener, event, state);
        return ResultData.success("\u66f4\u65b0\u6210\u529f");
    }
}

