/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.sse;

import com.visualization.cloud.scriptBuilder.DAO.mapper.VSseSendInfoMapper;
import com.visualization.cloud.sse.SSEUtil;
import com.visualization.cloud.util.resp.ResultData;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(path={"sse/"})
@Tag(name="sse\u8fde\u63a5")
public class SSEController {
    @Resource
    private SSEUtil sseUtil;
    @Resource
    private VSseSendInfoMapper vSseSendInfoMapper;

    @Operation(description="\u521b\u5efa\u81ea\u5b9a\u4e49\u4efb\u52a1\u8fde\u63a5")
    @GetMapping(path={"/definedJobSubscribe"}, produces={"text/event-stream"})
    public SseEmitter definedJobSubscribe(@RequestParam @Schema(description="\u8fde\u63a5\u7684key") String cacheKey) throws IOException {
        return SSEUtil.SSEEmitterManager.sseEmitterBuilder(cacheKey, 30000L, 30000L);
    }

    @Operation(description="\u5386\u53f2\u8bb0\u5f55\u6062\u590d")
    @GetMapping(path={"/restoreSSEInfoHistory"})
    public ResultData<List<String>> restoreSSEInfoHistory(@RequestParam @Schema(description="\u8fde\u63a5\u7684key") String cacheKey, @RequestParam @Schema(description="\u67e5\u8be2\u65f6\u95f4") LocalDate recordDate) throws IOException {
        return ResultData.success(SSEUtil.SSEHistoryDataRecovery(cacheKey, recordDate));
    }

    @Operation(description="\u83b7\u53d6\u5f53\u524d\u7684\u7f13\u5b58\u8fde\u63a5")
    @PostMapping(path={"/getLinkingCache"})
    public ResultData<List<String>> getLinkingCache() {
        return ResultData.success(SSEUtil.getLinkingFromDB());
    }

    @Operation(description="\u83b7\u53d6\u7684\u7f13\u5b58\u8fde\u63a5\u7684\u8bb0\u5f55\u65e5\u671f")
    @PostMapping(path={"/getLinkRecordDateFromDB"})
    public ResultData<List<LocalDate>> getLinkRecordDateFromDB(@RequestParam @Schema(description="\u5f85\u67e5\u8be2\u7684key") String key) {
        return ResultData.success(SSEUtil.getLinkRecordDateFromDB(key));
    }

    @PostMapping(path={"/send_test"})
    public void send_test() {
        ConcurrentHashMap messageBuffers = new ConcurrentHashMap();
        int a = messageBuffers.keySet().size();
        System.out.println(a);
    }
}

