/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.sse.listener;

import com.visualization.cloud.sse.SSEUtil;
import com.visualization.cloud.sse.listener.manager.ListenerEventManager;
import com.visualization.cloud.util.DynamicBeanOperate;
import jakarta.annotation.Resource;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobListener
implements org.quartz.JobListener {
    private static final Logger log = LoggerFactory.getLogger(JobListener.class);
    private final Map<String, Boolean> EventListenerState;
    @Resource
    private Scheduler scheduler;
    @Resource
    private DynamicBeanOperate dynamicBeanOperate;

    @Autowired
    public JobListener(ListenerEventManager listenerEventManager) {
        this.EventListenerState = listenerEventManager.getListenerEvent("job");
    }

    public String getName() {
        return "DynamicJobListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (this.EventListenerState.get("jobToBeExecuted").booleanValue()) {
            this.subEventInfo(context, "\u4efb\u52a1\u5373\u5c06\u6267\u884c...");
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        System.out.println("\u4efb\u52a1\u5df2\u6267\u884c\u5b8c\u6210...");
        JobKey jobKey = context.getJobDetail().getKey();
        String groupName = jobKey.getGroup();
        if ("DelayedQueue".equals(groupName)) {
            try {
                this.scheduler.deleteJob(jobKey);
                this.dynamicBeanOperate.unregisterBean(jobKey.getName());
            }
            catch (SchedulerException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.EventListenerState.get("jobWasExecuted").booleanValue()) {
            this.subEventInfo(context, "\u4efb\u52a1\u5df2\u6267\u884c\u5b8c\u6210...");
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        if (this.EventListenerState.get("jobExecutionVetoed").booleanValue()) {
            this.subEventInfo(context, "\u4efb\u52a1\u6267\u884c\u88ab\u5426\u51b3...");
        }
    }

    private void subEventInfo(JobExecutionContext context, Object data) {
        JobKey jobKey = context.getJobDetail().getKey();
        SSEUtil.simpleBroadcastEvent("job", data.toString());
        SSEUtil.simpleBroadcastEvent("job:" + jobKey.getGroup(), data.toString());
        SSEUtil.simpleBroadcastEvent("job:" + String.valueOf(jobKey), data.toString());
    }
}

