/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.sse.listener;

import com.visualization.cloud.sse.SSEUtil;
import com.visualization.cloud.sse.listener.manager.ListenerEventManager;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.listeners.TriggerListenerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TriggerListener
extends TriggerListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(TriggerListener.class);
    private final Map<String, Boolean> EventListenerState;

    @Autowired
    public TriggerListener(ListenerEventManager listenerEventManager) {
        this.EventListenerState = listenerEventManager.getListenerEvent("trigger");
    }

    public String getName() {
        return "DynamicTriggerListener";
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        if (this.EventListenerState.get("triggerFired").booleanValue()) {
            log.info("\u89e6\u53d1\u5668\u5373\u5c06\u89e6\u53d1");
            System.out.println("\u89e6\u53d1\u5668\u5373\u5c06\u89e6\u53d1...");
            this.subEventInfo(trigger, "\u89e6\u53d1\u5668\u5373\u5c06\u89e6\u53d1...");
        }
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        if (this.EventListenerState.get("triggerComplete").booleanValue()) {
            System.out.println("\u4efb\u52a1\u6267\u884c\u5b8c\u6210...");
            this.subEventInfo(trigger, "\u89e6\u53d1\u5668\u5df2\u89e6\u53d1...");
        }
    }

    private void subEventInfo(Trigger trigger, Object data) {
        TriggerKey triggerKey = trigger.getKey();
        SSEUtil.simpleBroadcastEvent("trigger", data.toString());
        SSEUtil.simpleBroadcastEvent("trigger:" + triggerKey.getGroup(), data.toString());
        SSEUtil.simpleBroadcastEvent("trigger:" + String.valueOf(triggerKey), data.toString());
    }
}

