/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.sse.listener.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class ListenerEventManager {
    private Map<String, Map<String, Boolean>> listenerEvents = new ConcurrentHashMap<String, Map<String, Boolean>>();

    public ListenerEventManager() {
        this.listenerEvents.put("job", (Map<String, Boolean>)new ConcurrentHashMap<String, Boolean>(){
            {
                this.put("jobToBeExecuted", false);
                this.put("jobWasExecuted", false);
                this.put("jobExecutionVetoed", false);
            }
        });
        this.listenerEvents.put("trigger", (Map<String, Boolean>)new ConcurrentHashMap<String, Boolean>(){
            {
                this.put("triggerComplete", false);
                this.put("triggerFired", false);
            }
        });
        HashMap<String, Boolean> schedulerEvents = new HashMap<String, Boolean>();
        schedulerEvents.put("schedulerStarting", false);
        schedulerEvents.put("schedulerStarted", false);
        schedulerEvents.put("schedulerInStandbyMode", false);
        schedulerEvents.put("schedulerShuttingdown", false);
        schedulerEvents.put("schedulerShutdown", false);
        schedulerEvents.put("schedulingDataCleared", false);
        schedulerEvents.put("schedulerError", false);
        schedulerEvents.put("jobScheduled", false);
        schedulerEvents.put("jobUnscheduled", false);
        schedulerEvents.put("jobAdded", false);
        schedulerEvents.put("jobDeleted", false);
        schedulerEvents.put("jobPaused", false);
        schedulerEvents.put("jobsPaused", false);
        schedulerEvents.put("jobResumed", false);
        schedulerEvents.put("jobsResumed", false);
        schedulerEvents.put("triggerFinalized", false);
        schedulerEvents.put("triggerPaused", false);
        schedulerEvents.put("triggersPaused", false);
        schedulerEvents.put("triggerResumed", false);
        schedulerEvents.put("triggersResumed", false);
        this.listenerEvents.put("scheduler", schedulerEvents);
    }

    public Map<String, Boolean> getListenerEvent(String type) {
        return this.listenerEvents.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListenerEvent(String type, String event, Boolean state) {
        Map<String, Boolean> events;
        Map<String, Boolean> map = events = this.listenerEvents.get(type);
        synchronized (map) {
            events.put(event, state);
        }
    }
}

