/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.sse.listener.manager;

import com.visualization.cloud.sse.listener.JobListener;
import com.visualization.cloud.sse.listener.SchedulerListener;
import com.visualization.cloud.sse.listener.TriggerListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.stereotype.Component;

@Component
public class ListenerManager {
    private final Scheduler scheduler;
    private final JobListener jobListener;
    private final TriggerListener triggerListener;
    private final SchedulerListener schedulerListener;
    private final Map<String, Boolean> listenerStates = new ConcurrentHashMap<String, Boolean>();

    public ListenerManager(Scheduler scheduler, JobListener jobListener, TriggerListener triggerListener, SchedulerListener schedulerListener) throws SchedulerException {
        this.scheduler = scheduler;
        this.jobListener = jobListener;
        this.triggerListener = triggerListener;
        this.schedulerListener = schedulerListener;
        this.initDefaultStates();
    }

    private void initDefaultStates() throws SchedulerException {
        this.listenerStates.put("job", true);
        this.listenerStates.put("trigger", true);
        this.listenerStates.put("scheduler", true);
        this.scheduler.getListenerManager().addJobListener((org.quartz.JobListener)this.jobListener);
        this.scheduler.getListenerManager().addTriggerListener((org.quartz.TriggerListener)this.triggerListener);
        this.scheduler.getListenerManager().addSchedulerListener((org.quartz.SchedulerListener)this.schedulerListener);
    }

    public void toggleListener(String listenerType, boolean enabled) throws SchedulerException {
        switch (listenerType) {
            case "job": {
                if (enabled) {
                    this.scheduler.getListenerManager().addJobListener((org.quartz.JobListener)this.jobListener);
                    break;
                }
                this.scheduler.getListenerManager().removeJobListener(this.jobListener.getName());
                break;
            }
            case "trigger": {
                if (enabled) {
                    this.scheduler.getListenerManager().addTriggerListener((org.quartz.TriggerListener)this.triggerListener);
                    break;
                }
                this.scheduler.getListenerManager().removeTriggerListener(this.triggerListener.getName());
                break;
            }
            case "scheduler": {
                if (enabled) {
                    this.scheduler.getListenerManager().addSchedulerListener((org.quartz.SchedulerListener)this.schedulerListener);
                    break;
                }
                this.scheduler.getListenerManager().removeSchedulerListener((org.quartz.SchedulerListener)this.schedulerListener);
            }
        }
        this.listenerStates.put(listenerType.toUpperCase(), enabled);
    }

    public Map<String, Boolean> getListenerStates() {
        return this.listenerStates;
    }
}

