/*
 * Decompiled with CFR 0.152.
 */
package com.visualization.cloud.util.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.visualization.cloud.util.exception.exception.GroovyBeanException;
import com.visualization.cloud.util.exception.exception.JobBuilderException;
import com.visualization.cloud.util.resp.ResultData;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public <T> Object exceptionHandler(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isSseRequest = this.isSseRequest(request);
        if (isSseRequest) {
            return this.handleSseException(e, request, response);
        }
        if (e instanceof GroovyBeanException) {
            return ResultData.fail(((GroovyBeanException)e).getCode().toString(), e.getMessage());
        }
        return this.handleNormalException(e);
    }

    private boolean isSseRequest(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        boolean isAcceptSse = acceptHeader != null && acceptHeader.contains("text/event-stream");
        boolean isUrlSse = request.getRequestURI().contains("/sse/");
        return isAcceptSse || isUrlSse;
    }

    private <T> ResultData<T> handleNormalException(Exception e) {
        if (e instanceof JobBuilderException) {
            JobBuilderException appException = (JobBuilderException)e;
            return ResultData.fail(appException.getCode().toString(), appException.getMessage());
        }
        log.error("e: ", (Throwable)e);
        return ResultData.fail("500", "\u670d\u52a1\u5668\u5f02\u5e38:" + String.valueOf(e));
    }

    private <T> ResponseEntity<Void> handleSseException(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResultData resultData;
        if (response.isCommitted()) {
            return null;
        }
        response.setContentType("text/event-stream");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (e instanceof JobBuilderException) {
            JobBuilderException appException = (JobBuilderException)e;
            resultData = ResultData.fail(appException.getCode().toString(), appException.getMessage());
        } else {
            log.error("e: ", (Throwable)e);
            resultData = ResultData.fail("500", "\u670d\u52a1\u5668\u5f02\u5e38:" + String.valueOf(e));
        }
        String sseData = "data: " + new ObjectMapper().writeValueAsString(resultData) + "\n\n";
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(sseData.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

