/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.vpacketevents.api.register;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;

public final class PacketRegistration<P extends MinecraftPacket> {
    @NotNull
    private final @NotNull Class<@NotNull P> packetClass;
    private @MonotonicNonNull Supplier<@NotNull P> packetSupplier;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @MonotonicNonNull ProtocolUtils.Direction direction;
    private @MonotonicNonNull StateRegistry stateRegistry;
    private final List<StateRegistry.PacketMapping> mappings = new ArrayList<StateRegistry.PacketMapping>();
    private static final MethodHandle STATE_REGISTRY$clientBound;
    private static final MethodHandle STATE_REGISTRY$serverBound;
    private static final MethodHandle PACKET_REGISTRY$register;
    private static final MethodHandle PACKET_MAPPING$map;
    private static final MethodHandle PACKET_MAPPING$mapLast;

    public PacketRegistration<P> packetSupplier(@NotNull @NotNull Supplier<@NotNull P> packetSupplier) {
        Objects.requireNonNull(packetSupplier, "packet supplier cannot be null");
        this.packetSupplier = packetSupplier;
        return this;
    }

    public PacketRegistration<P> direction(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ProtocolUtils.Direction direction) {
        Objects.requireNonNull(direction, "direction cannot be null");
        this.direction = direction;
        return this;
    }

    public PacketRegistration<P> stateRegistry(@NotNull StateRegistry stateRegistry) {
        Objects.requireNonNull(stateRegistry, "state registry cannot be null");
        this.stateRegistry = stateRegistry;
        return this;
    }

    public PacketRegistration<P> mapping(int id, @NotNull ProtocolVersion version, @NotNull ProtocolVersion lastValidProtocolVersion, boolean encodeOnly) {
        Objects.requireNonNull(version, "protocol version cannot be null");
        Objects.requireNonNull(lastValidProtocolVersion, "last valid protocol version cannot be null");
        try {
            StateRegistry.PacketMapping mapping = PACKET_MAPPING$mapLast.invoke(id, version, lastValidProtocolVersion, encodeOnly);
            this.mappings.add(mapping);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return this;
    }

    public PacketRegistration<P> mapping(int id, @NotNull ProtocolVersion version, boolean encodeOnly) {
        Objects.requireNonNull(version, "protocol version cannot be null");
        try {
            StateRegistry.PacketMapping mapping = PACKET_MAPPING$map.invoke(id, version, encodeOnly);
            this.mappings.add(mapping);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return this;
    }

    public void register() {
        Objects.requireNonNull(this.direction, "packet direction has not been assigned");
        Objects.requireNonNull(this.packetSupplier, "packet supplier has not been assigned");
        Objects.requireNonNull(this.stateRegistry, "state registry has not been assigned");
        if (this.mappings.isEmpty()) {
            throw new IllegalStateException("You must provide at least one packet mapping");
        }
        try {
            StateRegistry.PacketRegistry packetRegistry = this.direction == ProtocolUtils.Direction.CLIENTBOUND ? STATE_REGISTRY$clientBound.invoke(this.stateRegistry) : STATE_REGISTRY$serverBound.invoke(this.stateRegistry);
            PACKET_REGISTRY$register.invoke(packetRegistry, this.packetClass, this.packetSupplier, (StateRegistry.PacketMapping[])this.mappings.toArray(StateRegistry.PacketMapping[]::new));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <P extends MinecraftPacket> PacketRegistration<P> of(Class<P> packetClass) {
        return new PacketRegistration<P>(packetClass);
    }

    private PacketRegistration(@NotNull Class<P> packetClass) {
        this.packetClass = packetClass;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandles.Lookup stateRegistryLookup = MethodHandles.privateLookupIn(StateRegistry.class, lookup);
            STATE_REGISTRY$clientBound = stateRegistryLookup.findGetter(StateRegistry.class, "clientbound", StateRegistry.PacketRegistry.class);
            STATE_REGISTRY$serverBound = stateRegistryLookup.findGetter(StateRegistry.class, "serverbound", StateRegistry.PacketRegistry.class);
            MethodType mapType = MethodType.methodType(StateRegistry.PacketMapping.class, Integer.TYPE, ProtocolVersion.class, Boolean.TYPE);
            PACKET_MAPPING$map = stateRegistryLookup.findStatic(StateRegistry.class, "map", mapType);
            MethodType mapLastType = MethodType.methodType(StateRegistry.PacketMapping.class, Integer.TYPE, ProtocolVersion.class, ProtocolVersion.class, Boolean.TYPE);
            PACKET_MAPPING$mapLast = stateRegistryLookup.findStatic(StateRegistry.class, "map", mapLastType);
            MethodHandles.Lookup packetRegistryLookup = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.class, lookup);
            MethodType registerType = MethodType.methodType(Void.TYPE, Class.class, Supplier.class, StateRegistry.PacketMapping[].class);
            PACKET_REGISTRY$register = packetRegistryLookup.findVirtual(StateRegistry.PacketRegistry.class, "register", registerType);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

