package com.flyjingfish.android_aop_plugin.utils

object CutInfoHtml {
     fun getHtml(json:String):String{
          return "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n   <meta charset=\"UTF-8\">\n   <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n   <title>AndroidAOP Result Viewer</title>\n   <style>\n       body {\n           font-family: Arial, sans-serif;\n           margin: 0;\n           padding: 20px;\n           background-color: #f5f5f5;\n       }\n       .container {\n           max-width: 1200px;\n           margin: 0 auto;\n           background-color: white;\n           border-radius: 8px;\n           box-shadow: 0 2px 10px rgba(0,0,0,0.1);\n           padding: 20px;\n       }\n       h1 {\n           color: #333;\n           text-align: center;\n           margin-bottom: 30px;\n       }\n       .tabs {\n           display: flex;\n           margin-bottom: 20px;\n           border-bottom: 1px solid #ddd;\n       }\n       .tab {\n           padding: 10px 20px;\n           cursor: pointer;\n           background-color: #f1f1f1;\n           border: 1px solid #ddd;\n           border-bottom: none;\n           border-radius: 5px 5px 0 0;\n           margin-right: 5px;\n           transition: background-color 0.3s;\n       }\n       .tab:hover {\n           background-color: #ddd;\n       }\n       .tab.active {\n           background-color: #4CAF50;\n           color: white;\n           border-color: #4CAF50;\n       }\n       .tab-content {\n           display: none;\n           padding: 20px;\n           border: 1px solid #ddd;\n           border-radius: 0 0 5px 5px;\n           background-color: white;\n       }\n       .tab-content.active {\n           display: block;\n       }\n       .aspect-item {\n           margin-bottom: 20px;\n           padding: 15px;\n           background-color: #f9f9f9;\n           border-radius: 5px;\n           border-left: 4px solid #4CAF50;\n       }\n       .aspect-header {\n           font-weight: bold;\n           margin-bottom: 10px;\n           color: #333;\n           font-size: 1.1em;\n       }\n       .class-item {\n           margin-left: 20px;\n           margin-bottom: 15px;\n           padding: 10px;\n           background-color: #e9e9e9;\n           border-radius: 4px;\n       }\n       .method-item {\n           margin-left: 40px;\n           padding: 5px;\n           background-color: #f0f0f0;\n           border-radius: 3px;\n           margin-bottom: 5px;\n       }\n       .replace-method {\n           margin-left: 20px;\n           padding: 10px;\n           background-color: #e6f7ff;\n           border-radius: 4px;\n           margin-bottom: 10px;\n       }\n       .location-item {\n           margin-left: 40px;\n           padding: 5px;\n           background-color: #fff2e6;\n           border-radius: 3px;\n           margin-bottom: 5px;\n       }\n       .modified-class {\n           margin-left: 20px;\n           padding: 8px;\n           background-color: #fff2e6;\n           border-radius: 4px;\n           margin-bottom: 8px;\n       }\n       .collect-method {\n           margin-left: 20px;\n           padding: 10px;\n           background-color: #fff2e6;\n           border-radius: 4px;\n           margin-bottom: 10px;\n       }\n       .collect-class {\n           margin-left: 40px;\n           padding: 5px;\n           background-color: #f0fff0;\n           border-radius: 3px;\n           margin-bottom: 5px;\n       }\n       .count-badge {\n           display: inline-block;\n           padding: 2px 6px;\n           background-color: #4CAF50;\n           color: white;\n           border-radius: 10px;\n           font-size: 0.8em;\n           margin-left: 5px;\n       }\n       .type-count {\n           float: right;\n           background-color: #2196F3;\n           color: white;\n           padding: 2px 8px;\n           border-radius: 10px;\n           font-size: 0.9em;\n       }\n   </style>\n</head>\n<body>\n<div class=\"container\">\n   <h1>AndroidAOP Result Viewer</h1>\n\n   <div class=\"tabs\">\n       <div class=\"tab active\" onclick=\"openTab('annotation')\">注解切面 <span class=\"type-count\" id=\"annotation-count\">0</span></div>\n       <div class=\"tab\" onclick=\"openTab('matching')\">匹配切面 <span class=\"type-count\" id=\"matching-count\">0</span></div>\n       <div class=\"tab\" onclick=\"openTab('replacement')\">替换切面 <span class=\"type-count\" id=\"replacement-count\">0</span></div>\n       <div class=\"tab\" onclick=\"openTab('inheritance')\">修改继承类 <span class=\"type-count\" id=\"inheritance-count\">0</span></div>\n       <div class=\"tab\" onclick=\"openTab('collection')\">收集切面 <span class=\"type-count\" id=\"collection-count\">0</span></div>\n   </div>\n\n   <div id=\"annotation\" class=\"tab-content active\">\n       <h2>注解切面数据</h2>\n       <div id=\"annotation-content\"></div>\n   </div>\n\n   <div id=\"matching\" class=\"tab-content\">\n       <h2>匹配切面数据</h2>\n       <div id=\"matching-content\"></div>\n   </div>\n\n   <div id=\"replacement\" class=\"tab-content\">\n       <h2>替换切面数据</h2>\n       <div id=\"replacement-content\"></div>\n   </div>\n\n   <div id=\"inheritance\" class=\"tab-content\">\n       <h2>修改继承类数据</h2>\n       <div id=\"inheritance-content\"></div>\n   </div>\n\n   <div id=\"collection\" class=\"tab-content\">\n       <h2>收集切面数据</h2>\n       <div id=\"collection-content\"></div>\n   </div>\n</div>\n\n<script>\n       const data = $json;\n\n       function openTab(tabName) {\n           const tabs = document.getElementsByClassName('tab');\n           for (let i = 0; i < tabs.length; i++) {\n               tabs[i].classList.remove('active');\n           }\n\n           const tabContents = document.getElementsByClassName('tab-content');\n           for (let i = 0; i < tabContents.length; i++) {\n               tabContents[i].classList.remove('active');\n           }\n\n           document.querySelector(`.tab[onclick=\"openTab('\${tabName}')\"]`).classList.add('active');\n           document.getElementById(tabName).classList.add('active');\n       }\n\n       function renderAnnotationAspect() {\n           const annotationData = data.filter(item => item.type === \"注解切面\");\n           const container = document.getElementById('annotation-content');\n           document.getElementById('annotation-count').textContent = annotationData.length;\n\n           let html = '';\n\n           annotationData.forEach(aspect => {\n               html += `\n                   <div class=\"aspect-item\">\n                       <div class=\"aspect-header\">\n                           注解类: \${aspect.className}\n                           <span class=\"count-badge\">影响方法数: \${aspect.cutCount}</span>\n                       </div>\n               `;\n\n               aspect.cutClasses.forEach(cutClass => {\n                   html += `\n                       <div class=\"class-item\">\n                           <div>类名: \${cutClass.className} <span class=\"count-badge\">方法数: \${cutClass.methodCount}</span></div>\n                   `;\n\n                   cutClass.method.forEach(method => {\n                       html += `\n                           <div class=\"method-item\">\n                               方法: \${method.method} <br>\n                               Lambda: \${method.lambda ? '是' : '否'}\n                           </div>\n                       `;\n                   });\n\n                   html += `</div>`;\n               });\n\n               html += `</div>`;\n           });\n\n           container.innerHTML = html;\n       }\n\n       function renderMatchingAspect() {\n           const matchingData = data.filter(item => item.type === \"匹配切面\");\n           const container = document.getElementById('matching-content');\n           document.getElementById('matching-count').textContent = matchingData.length;\n\n           let html = '';\n\n           matchingData.forEach(aspect => {\n               html += `\n                   <div class=\"aspect-item\">\n                       <div class=\"aspect-header\">\n                           匹配类: \${aspect.className}\n                           <span class=\"count-badge\">影响方法数: \${aspect.cutCount}</span>\n                       </div>\n               `;\n\n               aspect.cutClasses.forEach(cutClass => {\n                   html += `\n                       <div class=\"class-item\">\n                           <div>类名: \${cutClass.className} <span class=\"count-badge\">方法数: \${cutClass.methodCount}</span></div>\n                   `;\n\n                   cutClass.method.forEach(method => {\n                       html += `\n                           <div class=\"method-item\">\n                               方法: \${method.method} <br>\n                               Lambda: \${method.lambda ? '是' : '否'}\n                           </div>\n                       `;\n                   });\n\n                   html += `</div>`;\n               });\n\n               html += `</div>`;\n           });\n\n           container.innerHTML = html;\n       }\n\n       function renderReplacementAspect() {\n           const replacementData = data.filter(item => item.type === \"替换切面\");\n           const container = document.getElementById('replacement-content');\n           document.getElementById('replacement-count').textContent = replacementData.length;\n\n           let html = '';\n\n           replacementData.forEach(aspect => {\n               html += `\n                   <div class=\"aspect-item\">\n                       <div class=\"aspect-header\">\n                           替换类: \${aspect.replaceClassName}\n                       </div>\n               `;\n\n               aspect.method.forEach(method => {\n                   html += `\n                       <div class=\"replace-method\">\n                           <div><strong>替换方法:</strong> \${method.replaceMethod}</div>\n                           <div><strong>目标类:</strong> \${method.targetClassName}</div>\n                           <div><strong>目标方法:</strong> \${method.targetMethod.replace(/</g, '&lt;').replace(/>/g, '&gt;')}</div>\n                           <div><strong>影响位置数:</strong> \${method.locationCount}</div>\n                           <div><strong>影响位置:</strong></div>\n                   `;\n\n                   method.locations.forEach(location => {\n                       html += `\n                           <div class=\"location-item\">\n                               <div>类名: \${location.className}</div>\n                               <div>方法: \${location.method}</div>\n                           </div>\n                       `;\n                   });\n\n                   html += `</div>`;\n               });\n\n               html += `</div>`;\n           });\n\n           container.innerHTML = html;\n       }\n\n       function renderInheritanceAspect() {\n           const inheritanceData = data.filter(item => item.type === \"修改继承类\");\n           const container = document.getElementById('inheritance-content');\n           document.getElementById('inheritance-count').textContent = inheritanceData.length;\n\n           let html = '';\n\n           inheritanceData.forEach(aspect => {\n               html += `\n                   <div class=\"aspect-item\">\n                       <div class=\"aspect-header\">\n                           目标类: \${aspect.targetClassName}\n                           <span class=\"count-badge\">修改类数: \${aspect.modifiedCount}</span>\n                       </div>\n                       <div>继承类: \${aspect.extendsClassName}</div>\n                       <div><strong>修改的类:</strong></div>\n               `;\n\n               aspect.modified.forEach(modifiedClass => {\n                   html += `\n                       <div class=\"modified-class\">\${modifiedClass}</div>\n                   `;\n               });\n\n               html += `</div>`;\n           });\n\n           container.innerHTML = html;\n       }\n\n       function renderCollectionAspect() {\n           const collectionData = data.filter(item => item.type === \"收集切面\");\n           const container = document.getElementById('collection-content');\n           document.getElementById('collection-count').textContent = collectionData.length;\n\n           let html = '';\n\n           collectionData.forEach(aspect => {\n               html += `\n                   <div class=\"aspect-item\">\n                       <div class=\"aspect-header\">\n                           收集类: \${aspect.collectClass}\n                       </div>\n               `;\n\n               aspect.collectMethod.forEach(method => {\n                   html += `\n                       <div class=\"collect-method\">\n                           <div><strong>收集方法:</strong> \${method.method.replace(/</g, '&lt;').replace(/>/g, '&gt;')}</div>\n                           <div><strong>收集类型:</strong> \${method.collectType}</div>\n                           <div><strong>正则表达式:</strong> \${method.regex || '无'}</div>\n                           <div><strong>收集类数:</strong> \${method.classCount}</div>\n                           <div><strong>收集的类:</strong></div>\n                   `;\n\n                   method.classes.forEach(cls => {\n                       html += `\n                           <div class=\"collect-class\">\${cls}</div>\n                       `;\n                   });\n\n                   html += `</div>`;\n               });\n\n               html += `</div>`;\n           });\n\n           container.innerHTML = html;\n       }\n\n       // Initialize the page\n       document.addEventListener('DOMContentLoaded', function() {\n           renderAnnotationAspect();\n           renderMatchingAspect();\n           renderReplacementAspect();\n           renderInheritanceAspect();\n           renderCollectionAspect();\n       });\n   </script>\n</body>\n</html>"
     }
}