/*
 * Decompiled with CFR 0.152.
 */
package com.flyjingfish.android_aop_processor;

import com.flyjingfish.android_aop_annotation.anno.AndroidAopCollectMethod;
import com.flyjingfish.android_aop_annotation.anno.AndroidAopMatchClassMethod;
import com.flyjingfish.android_aop_annotation.anno.AndroidAopModifyExtendsClass;
import com.flyjingfish.android_aop_annotation.anno.AndroidAopPointCut;
import com.flyjingfish.android_aop_annotation.anno.AndroidAopReplaceClass;
import com.flyjingfish.android_aop_annotation.anno.AndroidAopReplaceMethod;
import com.flyjingfish.android_aop_annotation.anno.AndroidAopReplaceNew;
import com.flyjingfish.android_aop_annotation.aop_anno.AopClass;
import com.flyjingfish.android_aop_annotation.aop_anno.AopCollectMethod;
import com.flyjingfish.android_aop_annotation.aop_anno.AopMatchClassMethod;
import com.flyjingfish.android_aop_annotation.aop_anno.AopModifyExtendsClass;
import com.flyjingfish.android_aop_annotation.aop_anno.AopPointCut;
import com.flyjingfish.android_aop_annotation.aop_anno.AopReplaceMethod;
import com.flyjingfish.android_aop_annotation.base.BasePointCut;
import com.flyjingfish.android_aop_annotation.base.BasePointCutCreator;
import com.flyjingfish.android_aop_annotation.base.MatchClassMethod;
import com.flyjingfish.android_aop_annotation.base.MatchClassMethodCreator;
import com.flyjingfish.android_aop_annotation.enums.MatchType;
import com.flyjingfish.android_aop_processor.CollectMethod;
import com.google.gson.Gson;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AndroidAopProcessor
extends AbstractProcessor {
    Filer mFiler;
    private TypeMirror matchClassMethodType;
    private Types types;
    private static final String AOP_METHOD_NAME = "aopConfigMethod";
    private Elements elementUtils;
    private static final Gson mGson = new Gson();
    private static final Pattern classnamePattern = Pattern.compile("<\\? extends .*?>");
    private static final Pattern classnamePattern1 = Pattern.compile("<\\? extends .*?");
    private static final Pattern classnamePattern2 = Pattern.compile("<\\? super .*?>");

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(AndroidAopPointCut.class.getCanonicalName());
        set.add(AndroidAopMatchClassMethod.class.getCanonicalName());
        set.add(AndroidAopReplaceClass.class.getCanonicalName());
        set.add(AndroidAopReplaceMethod.class.getCanonicalName());
        set.add(AndroidAopReplaceNew.class.getCanonicalName());
        set.add(AndroidAopModifyExtendsClass.class.getCanonicalName());
        set.add(AndroidAopCollectMethod.class.getCanonicalName());
        return set;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Set<?> set) {
        return set == null || set.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !AndroidAopProcessor.isEmpty(map);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mFiler = this.processingEnv.getFiler();
        this.elementUtils = this.processingEnv.getElementUtils();
        this.matchClassMethodType = this.elementUtils.getTypeElement(MatchClassMethod.class.getName()).asType();
        this.types = this.processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (AndroidAopProcessor.isEmpty(set)) {
            return false;
        }
        this.processPointCut(set, roundEnvironment);
        this.processMatch(set, roundEnvironment);
        this.processReplaceMethod(set, roundEnvironment, AndroidAopReplaceMethod.class);
        this.processReplaceMethod(set, roundEnvironment, AndroidAopReplaceNew.class);
        this.processReplace(set, roundEnvironment);
        this.processModifyExtendsClass(set, roundEnvironment);
        this.processCollectMethod(set, roundEnvironment);
        return false;
    }

    public void processPointCut(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(AndroidAopPointCut.class);
        for (Element element : elements) {
            String className;
            Name name1 = element.getSimpleName();
            AndroidAopPointCut cut = element.getAnnotation(AndroidAopPointCut.class);
            Target target = element.getAnnotation(Target.class);
            Retention retention = element.getAnnotation(Retention.class);
            if (target == null) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a\u8bf7\u7ed9 " + name1 + " \u8bbe\u7f6e @Target \u4e3aElementType.METHOD ");
            }
            ElementType[] elementTypes = target.value();
            if (elementTypes.length > 1) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a" + name1 + "\u53ea\u53ef\u4ee5\u8bbe\u7f6e @Target \u4e3a ElementType.METHOD \u8fd9\u4e00\u79cd");
            }
            if (elementTypes.length == 1) {
                if (elementTypes[0] != ElementType.METHOD) {
                    throw new IllegalArgumentException("\u6ce8\u610f\uff1a\u8bf7\u7ed9 " + name1 + " \u8bbe\u7f6e @Target \u4e3a ElementType.METHOD ");
                }
            } else {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a\u8bf7\u7ed9 " + name1 + " \u8bbe\u7f6e @Target \u4e3a ElementType.METHOD ");
            }
            if (retention == null) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a\u8bf7\u7ed9 " + name1 + " \u8bbe\u7f6e @Retention \u4e3a RetentionPolicy.RUNTIME ");
            }
            RetentionPolicy retentionPolicy = retention.value();
            if (retentionPolicy == null) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a\u8bf7\u7ed9 " + name1 + " \u8bbe\u7f6e @Retention \u4e3a RetentionPolicy.RUNTIME ");
            }
            if (retentionPolicy != RetentionPolicy.RUNTIME) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a\u5fc5\u987b\u7ed9 " + name1 + " \u8bbe\u7f6e @Retention \u4e3a RetentionPolicy.RUNTIME ");
            }
            try {
                className = cut.value().getName();
            }
            catch (MirroredTypeException mirroredTypeException) {
                String errorMessage = mirroredTypeException.getLocalizedMessage();
                className = errorMessage.substring(errorMessage.lastIndexOf(" ") + 1);
            }
            ClassName superinterface = ClassName.bestGuess((String)BasePointCutCreator.class.getName());
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)(name1 + "$$AndroidAopClass")).addAnnotation(AopClass.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)superinterface);
            String elementClassName = element.toString();
            String packageName = elementClassName.substring(0, elementClassName.lastIndexOf("."));
            String cutClassPackageName = className.substring(0, className.lastIndexOf("."));
            ClassName implementClassName = ClassName.get((String)packageName, (String)element.getSimpleName().toString(), (String[])new String[0]);
            ClassName bindClassName = ClassName.bestGuess((String)BasePointCut.class.getName());
            ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)bindClassName, (TypeName[])new TypeName[]{implementClassName});
            MethodSpec.Builder whatsMyName2 = AndroidAopProcessor.whatsMyName("newInstance").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.FINAL}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)returnType).addStatement("return new $T()", new Object[]{ClassName.bestGuess((String)className)}).addAnnotation(AnnotationSpec.builder(AopPointCut.class).addMember("value", "$S", new Object[]{"@" + element}).addMember("pointCutClassName", "$S", new Object[]{className}).build());
            typeBuilder.addMethod(whatsMyName2.build());
            TypeSpec typeSpec = typeBuilder.build();
            JavaFile javaFile = JavaFile.builder((String)cutClassPackageName, (TypeSpec)typeSpec).build();
            try {
                javaFile.writeTo(this.mFiler);
            }
            catch (IOException iOException) {}
        }
    }

    public void processMatch(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(AndroidAopMatchClassMethod.class);
        for (Element element : elements) {
            boolean matchAll;
            if (!this.types.isSubtype(element.asType(), this.matchClassMethodType)) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a" + element + " \u5fc5\u987b\u5b9e\u73b0 MatchClassMethod \u63a5\u53e3");
            }
            Name name1 = element.getSimpleName();
            AndroidAopMatchClassMethod cut = element.getAnnotation(AndroidAopMatchClassMethod.class);
            String className = cut.targetClassName();
            String[] methodNames = cut.methodName();
            String[] excludeClasses = cut.excludeClasses();
            MatchType matchType = cut.type();
            boolean overrideMethod = cut.overrideMethod();
            StringBuilder methodNamesBuilder = new StringBuilder();
            boolean hasMethodStar = false;
            for (int i = 0; i < methodNames.length; ++i) {
                if ("*".equals(methodNames[i])) {
                    hasMethodStar = true;
                }
                methodNamesBuilder.append(methodNames[i]);
                if (i == methodNames.length - 1) continue;
                methodNamesBuilder.append("-");
            }
            if (hasMethodStar && methodNames.length > 1) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a" + element + " \u5339\u914d\u6240\u6709\u65b9\u6cd5\u65f6\u4e0d\u53ef\u4ee5\u518d\u8bbe\u7f6e\u5176\u4ed6\u65b9\u6cd5\u540d\u4e86");
            }
            StringBuilder excludeClassesBuilder = new StringBuilder();
            for (int i = 0; i < excludeClasses.length; ++i) {
                excludeClassesBuilder.append(excludeClasses[i]);
                if (i == excludeClasses.length - 1) continue;
                excludeClassesBuilder.append("-");
            }
            boolean bl = matchAll = "*".equals(methodNamesBuilder.toString()) || className.contains("*");
            if (matchAll && overrideMethod) {
                throw new IllegalArgumentException("\u6ce8\u610f\uff1a" + element + " \u5339\u914d\u6240\u6709\u65b9\u6cd5\u6216\u5339\u914d\u5305\u540d\u65f6\u4e0d\u53ef\u4ee5\u8bbe\u7f6e overrideMethod \u4e3a true");
            }
            ClassName superinterface = ClassName.bestGuess((String)MatchClassMethodCreator.class.getName());
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)(name1 + "$$AndroidAopClass")).addAnnotation(AopClass.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)superinterface);
            ClassName bindClassName = ClassName.bestGuess((String)MatchClassMethod.class.getName());
            MethodSpec.Builder whatsMyName2 = AndroidAopProcessor.whatsMyName("newInstance").addModifiers(new Modifier[]{Modifier.FINAL}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)bindClassName).addStatement("return new $T()", new Object[]{ClassName.bestGuess((String)element.toString())}).addAnnotation(AnnotationSpec.builder(AopMatchClassMethod.class).addMember("baseClassName", "$S", new Object[]{className}).addMember("methodNames", "$S", new Object[]{mGson.toJson((Object)methodNames)}).addMember("pointCutClassName", "$S", new Object[]{element}).addMember("matchType", "$S", new Object[]{matchType.name()}).addMember("excludeClasses", "$S", new Object[]{mGson.toJson((Object)excludeClasses)}).addMember("overrideMethod", "$L", new Object[]{overrideMethod}).build());
            typeBuilder.addMethod(whatsMyName2.build());
            TypeSpec typeSpec = typeBuilder.build();
            String elementClassName = element.toString();
            String packageName = elementClassName.substring(0, elementClassName.lastIndexOf("."));
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
            try {
                javaFile.writeTo(this.mFiler);
            }
            catch (IOException iOException) {}
        }
    }

    private void processReplace(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(AndroidAopReplaceClass.class);
        for (Element element : elements) {
            Name name1 = element.getSimpleName();
            AndroidAopReplaceClass cut = element.getAnnotation(AndroidAopReplaceClass.class);
            String className = cut.value();
            String[] excludeClasses = cut.excludeClasses();
            MatchType matchType = cut.type();
            StringBuilder excludeClassesBuilder = new StringBuilder();
            for (int i = 0; i < excludeClasses.length; ++i) {
                excludeClassesBuilder.append(excludeClasses[i]);
                if (i == excludeClasses.length - 1) continue;
                excludeClassesBuilder.append("-");
            }
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)(name1 + "$$AndroidAopClass")).addAnnotation(AopClass.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder whatsMyName1 = AndroidAopProcessor.whatsMyName(AOP_METHOD_NAME).addAnnotation(AnnotationSpec.builder(AopReplaceMethod.class).addMember("targetClassName", "$S", new Object[]{className}).addMember("invokeClassName", "$S", new Object[]{element}).addMember("matchType", "$S", new Object[]{matchType.name()}).addMember("excludeClasses", "$S", new Object[]{mGson.toJson((Object)excludeClasses)}).build());
            typeBuilder.addMethod(whatsMyName1.build());
            TypeSpec typeSpec = typeBuilder.build();
            String elementClassName = element.toString();
            String packageName = elementClassName.substring(0, elementClassName.lastIndexOf("."));
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
            try {
                javaFile.writeTo(this.mFiler);
            }
            catch (IOException iOException) {}
        }
    }

    private void processModifyExtendsClass(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(AndroidAopModifyExtendsClass.class);
        for (Element element : elements) {
            Name name1 = element.getSimpleName();
            AndroidAopModifyExtendsClass cut = element.getAnnotation(AndroidAopModifyExtendsClass.class);
            String className = cut.value();
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)(name1 + "$$AndroidAopClass")).addAnnotation(AopClass.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder whatsMyName1 = AndroidAopProcessor.whatsMyName(AOP_METHOD_NAME).addAnnotation(AnnotationSpec.builder(AopModifyExtendsClass.class).addMember("targetClassName", "$S", new Object[]{className}).addMember("extendsClassName", "$S", new Object[]{element}).build());
            typeBuilder.addMethod(whatsMyName1.build());
            TypeSpec typeSpec = typeBuilder.build();
            String elementClassName = element.toString();
            String packageName = elementClassName.substring(0, elementClassName.lastIndexOf("."));
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
            try {
                javaFile.writeTo(this.mFiler);
            }
            catch (IOException iOException) {}
        }
    }

    private void processReplaceMethod(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment, Class<? extends Annotation> var1) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(var1);
        for (Element element : elements) {
            Name name1 = element.getSimpleName();
            boolean isStatic = false;
            Set<Modifier> modifiers = element.getModifiers();
            for (Modifier modifier : modifiers) {
                if (!"static".equals(modifier.toString())) continue;
                isStatic = true;
            }
            if (isStatic) continue;
            throw new IllegalArgumentException("\u6ce8\u610f\uff1a\u65b9\u6cd5 " + element.getEnclosingElement() + "." + name1 + " \u5fc5\u987b\u662f\u9759\u6001\u65b9\u6cd5 ");
        }
    }

    private void processCollectMethod(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(AndroidAopCollectMethod.class);
        HashMap<String, List> funMap = new HashMap<String, List>();
        for (Element element : elements) {
            Name name1 = element.getSimpleName();
            AndroidAopCollectMethod cut = element.getAnnotation(AndroidAopCollectMethod.class);
            String regex = cut.regex();
            String collectType = cut.collectType().name();
            if (regex == null) {
                regex = "";
            }
            boolean isStatic = false;
            boolean isPublic = false;
            Set<Modifier> modifiers = element.getModifiers();
            for (Modifier modifier : modifiers) {
                if ("static".equals(modifier.toString())) {
                    isStatic = true;
                }
                if (!"public".equals(modifier.toString())) continue;
                isPublic = true;
            }
            String exceptionJavaHintPreText = "\u6ce8\u610f\uff1a\u65b9\u6cd5 " + element.getEnclosingElement() + "." + name1;
            if (!isPublic) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u5fc5\u987b\u662fpublic\u516c\u5171\u65b9\u6cd5 ");
            }
            if (!isStatic) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u5fc5\u987b\u662f\u9759\u6001\u65b9\u6cd5 ");
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            String returnType = executableElement.getReturnType().toString();
            if (!"void".equals(returnType)) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u53ea\u53ef\u4ee5\u8bbe\u7f6e void \u4f5c\u4e3a\u8fd4\u56de\u7c7b\u578b");
            }
            if (executableElement.getParameters().isEmpty()) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u5fc5\u987b\u8bbe\u7f6e\u60a8\u60f3\u6536\u96c6\u7684\u7c7b\u4f5c\u4e3a\u53c2\u6570");
            }
            if (executableElement.getParameters().size() != 1) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u53c2\u6570\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a");
            }
            VariableElement variableElement = executableElement.getParameters().get(0);
            TypeMirror asType = variableElement.asType();
            Element typeElement = this.types.asElement(asType);
            if (typeElement == null) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u53c2\u6570\u7684\u7c7b\u578b\u4e0d\u53ef\u4ee5\u8bbe\u7f6e\u4e3a" + asType);
            }
            String collectClassName = typeElement.toString();
            boolean isClazz = "java.lang.Class".equals(collectClassName);
            boolean regexIsEmpty = "".equals(regex);
            if (!regexIsEmpty && regex.replaceAll(" ", "").isEmpty()) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u7684 regex \u5fc5\u987b\u5305\u542b\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u53ea\u6709\u7a7a\u683c");
            }
            if (isClazz) {
                String checkType = variableElement.asType().toString();
                String type = AndroidAopProcessor.getType(checkType);
                if (regexIsEmpty) {
                    if (type == null) {
                        throw new IllegalArgumentException(exceptionJavaHintPreText + " \u53c2\u6570\u7684\u6cdb\u578b\u8bbe\u7f6e\u7684\u4e0d\u5bf9");
                    }
                    collectClassName = type;
                } else {
                    if (AndroidAopProcessor.checkType(checkType)) {
                        throw new IllegalArgumentException(exceptionJavaHintPreText + " \u53c2\u6570\u7684\u6cdb\u578b\u8bbe\u7f6e\u7684\u4e0d\u5bf9");
                    }
                    collectClassName = type == null ? "java.lang.Object" : type;
                }
            }
            if ("kotlin.reflect.KClass".equals(collectClassName)) {
                throw new IllegalArgumentException(exceptionJavaHintPreText + " \u53c2\u6570\u4e0d\u53ef\u4ee5\u8bbe\u5b9a\u4e3a " + collectClassName);
            }
            if ("kotlin.Any".equals(collectClassName) || "java.lang.Object".equals(collectClassName)) {
                if (regexIsEmpty) {
                    throw new IllegalArgumentException(exceptionJavaHintPreText + " \u53c2\u6570\u4e0d\u53ef\u4ee5\u8bbe\u5b9a\u4e3a " + collectClassName);
                }
                collectClassName = "java.lang.Object";
            }
            List list = funMap.computeIfAbsent(element.getEnclosingElement().toString(), k -> new ArrayList());
            list.add(new CollectMethod(collectClassName, element.getEnclosingElement().toString(), name1.toString(), "" + isClazz, regex, collectType));
        }
        Set keySet = funMap.keySet();
        for (String s : keySet) {
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)(this.getClassName(s) + "$$AndroidAopClass")).addAnnotation(AopClass.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            List collectMethods = (List)funMap.get(s);
            String elementClassName = null;
            for (int i = 0; i < collectMethods.size(); ++i) {
                CollectMethod collectMethod = (CollectMethod)collectMethods.get(i);
                MethodSpec.Builder whatsMyName1 = AndroidAopProcessor.whatsMyName(AOP_METHOD_NAME + i).addAnnotation(AnnotationSpec.builder(AopCollectMethod.class).addMember("collectClass", "$T.class", new Object[]{ClassName.bestGuess((String)collectMethod.collectClassName)}).addMember("invokeClass", "$T.class", new Object[]{ClassName.bestGuess((String)collectMethod.invokeClassName)}).addMember("invokeMethod", "$S", new Object[]{collectMethod.invokeMethod}).addMember("isClazz", "$L", new Object[]{"true".equals(collectMethod.isClazz)}).addMember("regex", "$S", new Object[]{collectMethod.regex}).addMember("collectType", "$S", new Object[]{collectMethod.collectType}).build());
                typeBuilder.addMethod(whatsMyName1.build());
                elementClassName = collectMethod.invokeClassName;
            }
            if (elementClassName == null) continue;
            TypeSpec typeSpec = typeBuilder.build();
            String packageName = elementClassName.substring(0, elementClassName.lastIndexOf("."));
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
            try {
                javaFile.writeTo(this.mFiler);
            }
            catch (IOException iOException) {}
        }
    }

    String getClassName(String str) {
        if (str.contains(".")) {
            return str.substring(str.lastIndexOf(".") + 1);
        }
        return str;
    }

    public static String getType(String type) {
        String type2;
        Matcher matcher1;
        Matcher matcher = classnamePattern.matcher(type);
        if (matcher.find() && (matcher1 = classnamePattern1.matcher(type2 = matcher.group())).find()) {
            String realType = matcher1.replaceFirst("");
            Matcher realMatcher = classnamePattern.matcher(realType);
            String realTypeClass = realMatcher.find() ? realMatcher.replaceFirst("") : realType.replaceAll(">", "");
            return realTypeClass;
        }
        return null;
    }

    public static boolean checkType(String type) {
        Matcher matcher = classnamePattern2.matcher(type);
        return matcher.find();
    }

    private static String computeMD5(String message) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(message.getBytes());
        return AndroidAopProcessor.bytesToHex(digest);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static MethodSpec.Builder whatsMyName(String name) {
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }
}

