/*
 * Decompiled with CFR 0.152.
 */
package com.flyjingfish.shapeimageviewlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.flyjingfish.shapeimageviewlib.R;
import com.flyjingfish.shapeimageviewlib.ViewUtils;

public class AlmightyShapeImageView
extends AppCompatImageView {
    private Drawable mShapeResource;
    private final Paint mShapePaint;
    private ShapeScaleType mShapeScaleType;
    private boolean isDrawShapeClear;

    public AlmightyShapeImageView(@NonNull Context context) {
        this(context, null);
    }

    public AlmightyShapeImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AlmightyShapeImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AlmightyShapeImageView);
        this.mShapeResource = a.getDrawable(R.styleable.AlmightyShapeImageView_FlyJFish_almighty_shape_resource);
        this.mShapeScaleType = ShapeScaleType.getType(a.getInt(R.styleable.AlmightyShapeImageView_FlyJFish_almighty_shape_scaleType, 0));
        a.recycle();
        this.mShapePaint = new Paint();
        this.mShapePaint.setColor(-1);
        this.mShapePaint.setAntiAlias(true);
        this.mShapePaint.setStyle(Paint.Style.FILL);
    }

    protected void drawableStateChanged() {
        int[] drawableState;
        boolean inval;
        super.drawableStateChanged();
        if (this.mShapeResource != null && (inval = this.mShapeResource.setState(drawableState = this.getDrawableState()))) {
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mShapeResource != null) {
            this.preDrawShaper(canvas);
            this.drawShape(canvas);
            super.onDraw(canvas);
            canvas.restore();
        } else {
            super.onDraw(canvas);
        }
    }

    private void preDrawShaper(Canvas canvas) {
        float pictureHeight;
        float pictureWidth;
        float transY;
        float transX;
        if (this.mShapeScaleType != ShapeScaleType.ALWAYS_FIX_XY) {
            return;
        }
        int height = this.getHeight();
        int width = this.getWidth();
        int paddingLeft = ViewUtils.getViewPaddingLeft((View)this);
        int paddingRight = ViewUtils.getViewPaddingRight((View)this);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        Drawable drawable = this.getDrawable();
        Matrix matrix = this.getImageMatrix();
        if (drawable == null || matrix == null) {
            return;
        }
        float[] matrixValues = new float[9];
        matrix.getValues(matrixValues);
        int drawableWidth = drawable.getIntrinsicWidth();
        int drawableHeight = drawable.getIntrinsicHeight();
        ImageView.ScaleType scaleType = this.getScaleType();
        if (scaleType == ImageView.ScaleType.FIT_XY || scaleType == ImageView.ScaleType.CENTER_CROP) {
            transX = paddingLeft;
            transY = paddingTop;
            pictureWidth = width - paddingLeft - paddingRight;
            pictureHeight = height - paddingTop - paddingBottom;
        } else if (scaleType == ImageView.ScaleType.CENTER) {
            if (drawableWidth < width || drawableHeight < height) {
                pictureWidth = drawableWidth < width ? (float)drawableWidth : (float)width;
                pictureHeight = drawableHeight < height ? (float)drawableHeight : (float)height;
                transX = ((float)width - pictureWidth) / 2.0f;
                transY = ((float)height - pictureHeight) / 2.0f;
            } else {
                transX = paddingLeft;
                transY = paddingTop;
                pictureWidth = width - paddingLeft - paddingRight;
                pictureHeight = height - paddingTop - paddingBottom;
            }
        } else {
            transX = (int)matrixValues[2] + paddingLeft;
            transY = (int)matrixValues[5] + paddingTop;
            pictureWidth = (float)drawableWidth * matrixValues[0];
            pictureHeight = (float)drawableHeight * matrixValues[4];
        }
        int left = (int)transX;
        int top = (int)transY;
        int right = (int)(pictureWidth + transX);
        int bottom = (int)(pictureHeight + transY);
        this.mShapePaint.setXfermode(null);
        canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), this.mShapePaint, 31);
        canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mShapePaint);
        this.mShapePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), this.mShapePaint, 31);
        this.mShapeResource.setBounds(paddingLeft, paddingTop, width - paddingRight, height - paddingBottom);
        if (this.mShapeResource instanceof PictureDrawable) {
            float scaleX = (float)this.mShapeResource.getBounds().width() * 1.0f / (float)this.mShapeResource.getIntrinsicWidth();
            float scaleY = (float)this.mShapeResource.getBounds().height() * 1.0f / (float)this.mShapeResource.getIntrinsicHeight();
            canvas.translate((float)this.mShapeResource.getBounds().left, (float)this.mShapeResource.getBounds().top);
            canvas.scale(scaleX, scaleY);
            canvas.drawPicture(((PictureDrawable)this.mShapeResource).getPicture());
            canvas.scale(1.0f / scaleX, 1.0f / scaleY);
            canvas.translate((float)(-this.mShapeResource.getBounds().left), (float)(-this.mShapeResource.getBounds().top));
        } else {
            this.mShapeResource.draw(canvas);
        }
        this.isDrawShapeClear = true;
    }

    private void drawShape(Canvas canvas) {
        int bottom;
        int right;
        int top;
        int left;
        int height = this.getHeight();
        int width = this.getWidth();
        int paddingLeft = ViewUtils.getViewPaddingLeft((View)this);
        int paddingRight = ViewUtils.getViewPaddingRight((View)this);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        Matrix matrix = this.getImageMatrix();
        if (matrix == null || this.mShapeScaleType == ShapeScaleType.ALWAYS_FIX_XY) {
            left = paddingLeft;
            top = paddingTop;
            right = width - paddingRight;
            bottom = height - paddingBottom;
        } else {
            float shapeHeight;
            float shapeWidth;
            float pictureHeight;
            float pictureWidth;
            float transY;
            float transX;
            float[] matrixValues = new float[9];
            matrix.getValues(matrixValues);
            int drawableWidth = drawable.getIntrinsicWidth();
            int drawableHeight = drawable.getIntrinsicHeight();
            float drawHWScale = (float)drawableHeight * 1.0f / (float)drawableWidth;
            int shapeResourceWidth = this.mShapeResource.getIntrinsicWidth();
            int shapeResourceHeight = this.mShapeResource.getIntrinsicHeight();
            float shapeHWScale = (float)shapeResourceHeight * 1.0f / (float)shapeResourceWidth;
            float viewHWScale = (float)height * 1.0f / (float)width;
            ImageView.ScaleType scaleType = this.getScaleType();
            if (scaleType == ImageView.ScaleType.FIT_XY || scaleType == ImageView.ScaleType.CENTER_CROP) {
                transX = paddingLeft;
                transY = paddingTop;
                pictureWidth = width - paddingLeft - paddingRight;
                pictureHeight = height - paddingTop - paddingBottom;
                if (viewHWScale > shapeHWScale) {
                    shapeWidth = pictureWidth;
                    shapeHeight = shapeWidth * shapeHWScale;
                } else {
                    shapeHeight = pictureHeight;
                    shapeWidth = shapeHeight / shapeHWScale;
                }
            } else if (scaleType == ImageView.ScaleType.CENTER) {
                if (drawableWidth < width || drawableHeight < height) {
                    pictureHeight = drawableHeight < height ? (float)drawableHeight : (float)height;
                    float pictureHWScale = pictureHeight / (pictureWidth = drawableWidth < width ? (float)drawableWidth : (float)width);
                    if (pictureHWScale > shapeHWScale) {
                        shapeWidth = pictureWidth;
                        shapeHeight = shapeWidth * shapeHWScale;
                    } else {
                        shapeHeight = pictureHeight;
                        shapeWidth = shapeHeight / shapeHWScale;
                    }
                    transX = ((float)width - pictureWidth) / 2.0f;
                    transY = ((float)height - pictureHeight) / 2.0f;
                } else {
                    transX = paddingLeft;
                    transY = paddingTop;
                    pictureWidth = width - paddingLeft - paddingRight;
                    pictureHeight = height - paddingTop - paddingBottom;
                    if (viewHWScale > shapeHWScale) {
                        shapeWidth = pictureWidth;
                        shapeHeight = shapeWidth * shapeHWScale;
                    } else {
                        shapeHeight = pictureHeight;
                        shapeWidth = shapeHeight / shapeHWScale;
                    }
                }
            } else {
                transX = (int)matrixValues[2] + paddingLeft;
                transY = (int)matrixValues[5] + paddingTop;
                pictureWidth = (float)drawableWidth * matrixValues[0];
                pictureHeight = (float)drawableHeight * matrixValues[4];
                if (drawHWScale > shapeHWScale) {
                    shapeWidth = pictureWidth;
                    shapeHeight = shapeWidth * shapeHWScale;
                } else {
                    shapeHeight = pictureHeight;
                    shapeWidth = shapeHeight / shapeHWScale;
                }
            }
            if (this.mShapeScaleType == ShapeScaleType.FOLLOW_IMAGEVIEW_FULL_IMAGE) {
                shapeWidth = pictureWidth;
                shapeHeight = pictureHeight;
            }
            left = (int)(transX + (pictureWidth - shapeWidth) / 2.0f);
            top = (int)(transY + (pictureHeight - shapeHeight) / 2.0f);
            right = (int)(shapeWidth + transX + (pictureWidth - shapeWidth) / 2.0f);
            bottom = (int)(shapeHeight + transY + (pictureHeight - shapeHeight) / 2.0f);
        }
        if (!this.isDrawShapeClear) {
            this.mShapePaint.setXfermode(null);
            canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), this.mShapePaint, 31);
            this.mShapeResource.setBounds(left, top, right, bottom);
            if (this.mShapeResource instanceof PictureDrawable) {
                float scaleX = (float)this.mShapeResource.getBounds().width() * 1.0f / (float)this.mShapeResource.getIntrinsicWidth();
                float scaleY = (float)this.mShapeResource.getBounds().height() * 1.0f / (float)this.mShapeResource.getIntrinsicHeight();
                canvas.translate((float)this.mShapeResource.getBounds().left, (float)this.mShapeResource.getBounds().top);
                canvas.scale(scaleX, scaleY);
                canvas.drawPicture(((PictureDrawable)this.mShapeResource).getPicture());
                canvas.scale(1.0f / scaleX, 1.0f / scaleY);
                canvas.translate((float)(-this.mShapeResource.getBounds().left), (float)(-this.mShapeResource.getBounds().top));
            } else {
                this.mShapeResource.draw(canvas);
            }
        }
        this.mShapePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), this.mShapePaint, 31);
        this.isDrawShapeClear = false;
    }

    public Drawable getShapeDrawable() {
        return this.mShapeResource;
    }

    public void setShapeResource(Drawable shapeResource) {
        this.mShapeResource = shapeResource;
        this.invalidate();
    }

    public void setShapeResource(@DrawableRes int shapeResourceRes) {
        this.setShapeResource(this.getResources().getDrawable(shapeResourceRes));
    }

    public ShapeScaleType getShapeScaleType() {
        return this.mShapeScaleType;
    }

    public void setShapeScaleType(ShapeScaleType shapeScaleType) {
        this.mShapeScaleType = shapeScaleType;
        this.invalidate();
    }

    public static enum ShapeScaleType {
        FOLLOW_IMAGEVIEW_KEEP_RESOURCE_SCALE(0),
        FOLLOW_IMAGEVIEW_FULL_IMAGE(1),
        ALWAYS_FIX_XY(2);

        final int type;

        private ShapeScaleType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static ShapeScaleType getType(int type) {
            if (type == 2) {
                return ALWAYS_FIX_XY;
            }
            if (type == 1) {
                return FOLLOW_IMAGEVIEW_FULL_IMAGE;
            }
            return FOLLOW_IMAGEVIEW_KEEP_RESOURCE_SCALE;
        }
    }
}

