/*
 * Decompiled with CFR 0.152.
 */
package com.flyjingfish.shapeimageviewlib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.text.TextUtilsCompat;
import com.flyjingfish.shapeimageviewlib.R;
import com.flyjingfish.shapeimageviewlib.ShapeImageViewAttacher;
import com.flyjingfish.shapeimageviewlib.ViewUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ShapeImageView
extends AppCompatImageView {
    private ShapeImageViewAttacher mAttacher;
    private ShapeScaleType mPendingScaleType;
    private final List<ColorStateList> gradientColorStates = new ArrayList<ColorStateList>();
    private float mAutoCropHeightWidthRatio;
    private float leftTopRadius;
    private float leftBottomRadius;
    private float rightTopRadius;
    private float rightBottomRadius;
    private final Paint mImagePaint;
    private final Paint mRoundPaint;
    private ShapeType shapeType;
    private final Paint mBgPaint;
    private final float mBgPaintWidth;
    private ShapeType bgShapeType;
    private int[] gradientColors;
    private float gradientAngle;
    private boolean gradientRtlAngle;
    private boolean isGradient;
    private float bgLeftTopRadius;
    private float bgLeftBottomRadius;
    private float bgRightTopRadius;
    private float bgRightBottomRadius;
    private float[] gradientPositions;
    private boolean isRtl = false;
    private float startTopRadius;
    private float startBottomRadius;
    private float endTopRadius;
    private float endBottomRadius;
    private float bgStartTopRadius;
    private float bgStartBottomRadius;
    private float bgEndTopRadius;
    private float bgEndBottomRadius;
    private ColorStateList bgShapeColor;
    private int curBgShapeColor;

    public ShapeImageView(Context context) {
        this(context, null);
    }

    public ShapeImageView(Context context, AttributeSet attr) {
        this(context, attr, 0);
    }

    public ShapeImageView(Context context, AttributeSet attr, int defStyle) {
        super(context, attr, defStyle);
        if (Build.VERSION.SDK_INT >= 19) {
            this.isRtl = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
        }
        TypedArray a = context.obtainStyledAttributes(attr, R.styleable.ShapeImageView);
        this.mPendingScaleType = ShapeScaleType.getType(a.getInt(R.styleable.ShapeImageView_FlyJFish_shapeScaleType, 0));
        this.mAutoCropHeightWidthRatio = a.getFloat(R.styleable.ShapeImageView_FlyJFish_autoCrop_height_width_ratio, 2.0f);
        float radius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_radius, 0.0f);
        this.leftTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_left_top_radius, radius);
        this.leftBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_left_bottom_radius, radius);
        this.rightTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_right_top_radius, radius);
        this.rightBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_right_bottom_radius, radius);
        this.startTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_start_top_radius, radius);
        this.startBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_start_bottom_radius, radius);
        this.endTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_end_top_radius, radius);
        this.endBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_end_bottom_radius, radius);
        this.shapeType = ShapeType.getType(a.getInt(R.styleable.ShapeImageView_FlyJFish_shape, 1));
        this.bgShapeType = ShapeType.getType(a.getInt(R.styleable.ShapeImageView_FlyJFish_shape_border, 0));
        ColorStateList startColor = a.getColorStateList(R.styleable.ShapeImageView_FlyJFish_shape_border_startColor);
        ColorStateList centerColor = a.getColorStateList(R.styleable.ShapeImageView_FlyJFish_shape_border_centerColor);
        ColorStateList endColor = a.getColorStateList(R.styleable.ShapeImageView_FlyJFish_shape_border_endColor);
        this.bgShapeColor = a.getColorStateList(R.styleable.ShapeImageView_FlyJFish_shape_border_color);
        this.gradientAngle = a.getFloat(R.styleable.ShapeImageView_FlyJFish_shape_border_angle, 0.0f);
        this.gradientRtlAngle = a.getBoolean(R.styleable.ShapeImageView_FlyJFish_shape_border_rtl_angle, false);
        this.isGradient = a.getBoolean(R.styleable.ShapeImageView_FlyJFish_shape_border_gradient, false);
        this.mBgPaintWidth = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_width, 1.0f);
        float bgRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_radius, 0.0f);
        this.bgLeftTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_left_top_radius, bgRadius);
        this.bgLeftBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_left_bottom_radius, bgRadius);
        this.bgRightTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_right_top_radius, bgRadius);
        this.bgRightBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_right_bottom_radius, bgRadius);
        this.bgStartTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_start_top_radius, bgRadius);
        this.bgStartBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_start_bottom_radius, bgRadius);
        this.bgEndTopRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_end_top_radius, bgRadius);
        this.bgEndBottomRadius = a.getDimension(R.styleable.ShapeImageView_FlyJFish_shape_border_end_bottom_radius, bgRadius);
        a.recycle();
        if (startColor != null) {
            this.gradientColorStates.add(startColor);
        }
        if (centerColor != null) {
            this.gradientColorStates.add(centerColor);
        }
        if (endColor != null) {
            this.gradientColorStates.add(endColor);
        }
        if (this.gradientColorStates.size() == 1) {
            this.gradientColorStates.add(ColorStateList.valueOf((int)0));
        }
        if (this.bgShapeColor == null) {
            this.bgShapeColor = ColorStateList.valueOf((int)-16777216);
        }
        this.updateColors();
        this.mBgPaint = new Paint();
        this.mBgPaint.setColor(this.curBgShapeColor);
        this.mBgPaint.setAntiAlias(true);
        this.mBgPaint.setStrokeWidth(this.mBgPaintWidth);
        this.mBgPaint.setStyle(Paint.Style.STROKE);
        this.mImagePaint = new Paint();
        this.mImagePaint.setXfermode(null);
        this.mRoundPaint = new Paint();
        this.mRoundPaint.setColor(-1);
        this.mRoundPaint.setAntiAlias(true);
        this.mRoundPaint.setStyle(Paint.Style.FILL);
        this.mRoundPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        this.init();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateColors();
    }

    private boolean updateColors() {
        boolean inval = false;
        int[] drawableState = this.getDrawableState();
        int color = this.bgShapeColor.getColorForState(drawableState, 0);
        if (color != this.curBgShapeColor) {
            this.curBgShapeColor = color;
            inval = true;
            if (this.mBgPaint != null) {
                this.mBgPaint.setColor(this.curBgShapeColor);
            }
        }
        if (this.gradientColorStates != null && this.gradientColorStates.size() > 0) {
            int[] gradientCls = new int[this.gradientColorStates.size()];
            for (int i = 0; i < this.gradientColorStates.size(); ++i) {
                int gradientColor;
                gradientCls[i] = gradientColor = this.gradientColorStates.get(i).getColorForState(drawableState, 0);
            }
            if (this.gradientColors == null) {
                this.gradientColors = gradientCls;
                inval = true;
            } else if (this.gradientColors.length != gradientCls.length) {
                this.gradientColors = gradientCls;
                inval = true;
            } else {
                boolean equals = true;
                for (int i = 0; i < this.gradientColors.length; ++i) {
                    if (this.gradientColors[i] == gradientCls[i]) continue;
                    equals = false;
                    break;
                }
                if (!equals) {
                    this.gradientColors = gradientCls;
                    inval = true;
                }
            }
        }
        if (inval) {
            this.invalidate();
        }
        return inval;
    }

    private void init() {
        this.mAttacher = new ShapeImageViewAttacher(this);
        this.mAttacher.setAutoCropHeightWidthRatio(this.mAutoCropHeightWidthRatio);
        if (this.mPendingScaleType != null) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
            this.setShapeScaleType(this.mPendingScaleType);
            this.mPendingScaleType = null;
        } else {
            this.setShapeScaleType(ShapeScaleType.getType(this.getScaleType()));
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
    }

    public Matrix getImageMatrix() {
        return this.mAttacher.getImageMatrix();
    }

    public void setShapeScaleType(ShapeScaleType scaleType) {
        if (this.mAttacher == null) {
            this.mPendingScaleType = scaleType;
        } else {
            this.mAttacher.setScaleType(scaleType);
        }
    }

    public float getAutoCropHeightWidthRatio() {
        return this.mAutoCropHeightWidthRatio;
    }

    public void setAutoCropHeightWidthRatio(float autoCropHeightWidthRatio) {
        this.mAutoCropHeightWidthRatio = autoCropHeightWidthRatio;
        if (this.mAttacher != null) {
            this.mAttacher.setAutoCropHeightWidthRatio(autoCropHeightWidthRatio);
            this.mAttacher.update();
        }
    }

    public ShapeScaleType getShapeScaleType() {
        return this.mAttacher.getShapeScaleType();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        if (this.mAttacher != null) {
            this.mAttacher.update();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        if (this.mAttacher != null) {
            this.mAttacher.update();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        if (this.mAttacher != null) {
            this.mAttacher.update();
        }
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        if (changed) {
            this.mAttacher.update();
        }
        return changed;
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        this.drawBgShape(canvas);
        this.clipPadding(canvas);
        if (this.shapeType == ShapeType.OVAL) {
            canvas.saveLayer(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), this.mImagePaint, 31);
            super.onDraw(canvas);
            this.drawOval(canvas);
            canvas.restore();
        } else if (this.shapeType == ShapeType.RECTANGLE) {
            canvas.saveLayer(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), this.mImagePaint, 31);
            super.onDraw(canvas);
            this.drawRectangle(canvas);
            canvas.restore();
        } else {
            super.onDraw(canvas);
        }
    }

    private void drawBgShape(Canvas canvas) {
        if (this.bgShapeType == null || this.bgShapeType == ShapeType.NONE) {
            return;
        }
        int saveCount = canvas.getSaveCount();
        canvas.save();
        int height = this.getHeight();
        int width = this.getWidth();
        RectF rectF = new RectF(this.mBgPaintWidth / 2.0f, this.mBgPaintWidth / 2.0f, (float)width - this.mBgPaintWidth / 2.0f, (float)height - this.mBgPaintWidth / 2.0f);
        if (this.isGradient && this.gradientColors != null) {
            float y0;
            float x0;
            float percent;
            float angle;
            float currentAngle = this.gradientAngle;
            if (this.gradientRtlAngle && this.isRtl) {
                currentAngle = -this.gradientAngle;
            }
            if ((angle = currentAngle % 360.0f) < 0.0f) {
                angle = 360.0f + angle;
            }
            if (angle >= 0.0f && angle <= 45.0f) {
                percent = angle / 45.0f;
                x0 = (float)(width / 2) + (float)(width / 2) * percent;
                y0 = 0.0f;
            } else if (angle <= 90.0f) {
                percent = (angle - 45.0f) / 45.0f;
                x0 = width;
                y0 = (float)(height / 2) * percent;
            } else if (angle <= 135.0f) {
                percent = (angle - 90.0f) / 45.0f;
                x0 = width;
                y0 = (float)(height / 2) * percent + (float)(height / 2);
            } else if (angle <= 180.0f) {
                percent = (angle - 135.0f) / 45.0f;
                x0 = (float)(width / 2) + (float)(width / 2) * (1.0f - percent);
                y0 = height;
            } else if (angle <= 225.0f) {
                percent = (angle - 180.0f) / 45.0f;
                x0 = (float)(width / 2) - (float)(width / 2) * percent;
                y0 = height;
            } else if (angle <= 270.0f) {
                percent = (angle - 225.0f) / 45.0f;
                x0 = 0.0f;
                y0 = (float)height - (float)(height / 2) * percent;
            } else if (angle <= 315.0f) {
                percent = (angle - 270.0f) / 45.0f;
                x0 = 0.0f;
                y0 = (float)(height / 2) - (float)(height / 2) * percent;
            } else {
                percent = (angle - 315.0f) / 45.0f;
                x0 = (float)(width / 2) * percent;
                y0 = 0.0f;
            }
            float x1 = (float)width - x0;
            float y1 = (float)height - y0;
            LinearGradient linearGradient = new LinearGradient(x0, y0, x1, y1, this.gradientColors, this.gradientPositions, Shader.TileMode.CLAMP);
            this.mBgPaint.setShader((Shader)linearGradient);
        }
        if (this.bgShapeType == ShapeType.OVAL) {
            canvas.drawArc(rectF, 0.0f, 360.0f, true, this.mBgPaint);
        } else if (this.is4BgRadiusEquals()) {
            canvas.drawRoundRect(rectF, this.bgLeftTopRadius, this.bgLeftTopRadius, this.mBgPaint);
        } else {
            float bgLeftTopRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgEndTopRadius : this.bgStartTopRadius, this.bgLeftTopRadius);
            float bgLeftBottomRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgEndBottomRadius : this.bgStartBottomRadius, this.bgLeftBottomRadius);
            float bgRightTopRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgStartTopRadius : this.bgEndTopRadius, this.bgRightTopRadius);
            float bgRightBottomRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgStartBottomRadius : this.bgEndBottomRadius, this.bgRightBottomRadius);
            RectF leftTopRectF = new RectF(this.mBgPaintWidth / 2.0f, this.mBgPaintWidth / 2.0f, bgLeftTopRadius * 2.0f + this.mBgPaintWidth / 2.0f, bgLeftTopRadius * 2.0f + this.mBgPaintWidth / 2.0f);
            RectF rightTopRectF = new RectF((float)width - bgRightTopRadius * 2.0f - this.mBgPaintWidth / 2.0f, this.mBgPaintWidth / 2.0f, (float)width - this.mBgPaintWidth / 2.0f, bgRightTopRadius * 2.0f + this.mBgPaintWidth / 2.0f);
            RectF rightBottomRectF = new RectF((float)width - bgRightBottomRadius * 2.0f - this.mBgPaintWidth / 2.0f, (float)height - bgRightBottomRadius * 2.0f - this.mBgPaintWidth / 2.0f, (float)width - this.mBgPaintWidth / 2.0f, (float)height - this.mBgPaintWidth / 2.0f);
            RectF leftBottomRectF = new RectF(this.mBgPaintWidth / 2.0f, (float)height - bgLeftBottomRadius * 2.0f - this.mBgPaintWidth / 2.0f, bgLeftBottomRadius * 2.0f + this.mBgPaintWidth / 2.0f, (float)height - this.mBgPaintWidth / 2.0f);
            canvas.drawArc(leftTopRectF, -90.0f, -90.0f, false, this.mBgPaint);
            canvas.drawArc(rightTopRectF, 0.0f, -90.0f, false, this.mBgPaint);
            canvas.drawArc(rightBottomRectF, 0.0f, 90.0f, false, this.mBgPaint);
            canvas.drawArc(leftBottomRectF, 90.0f, 90.0f, false, this.mBgPaint);
            float[] pts = new float[]{this.mBgPaintWidth / 2.0f, bgLeftTopRadius + this.mBgPaintWidth / 2.0f, this.mBgPaintWidth / 2.0f, (float)height - bgLeftBottomRadius - this.mBgPaintWidth / 2.0f, this.mBgPaintWidth / 2.0f + bgLeftTopRadius, this.mBgPaintWidth / 2.0f, (float)width - this.mBgPaintWidth / 2.0f - bgRightTopRadius, this.mBgPaintWidth / 2.0f, (float)width - this.mBgPaintWidth / 2.0f, this.mBgPaintWidth / 2.0f + bgRightTopRadius, (float)width - this.mBgPaintWidth / 2.0f, (float)height - bgRightBottomRadius - this.mBgPaintWidth / 2.0f, this.mBgPaintWidth / 2.0f + bgLeftBottomRadius, (float)height - this.mBgPaintWidth / 2.0f, (float)width - this.mBgPaintWidth / 2.0f - bgRightBottomRadius, (float)height - this.mBgPaintWidth / 2.0f};
            canvas.drawLines(pts, this.mBgPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    private void clipPadding(Canvas canvas) {
        ShapeScaleType shapeScaleType = this.mAttacher.getShapeScaleType();
        boolean isShapeCrop = shapeScaleType == ShapeScaleType.START_CROP || shapeScaleType == ShapeScaleType.END_CROP || shapeScaleType == ShapeScaleType.AUTO_START_CENTER_CROP || shapeScaleType == ShapeScaleType.AUTO_END_CENTER_CROP || this.getScaleType() == ImageView.ScaleType.CENTER || this.getScaleType() == ImageView.ScaleType.CENTER_CROP;
        int paddingLeft = ViewUtils.getViewPaddingLeft((View)this);
        int paddingRight = ViewUtils.getViewPaddingRight((View)this);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        if (isShapeCrop && (paddingLeft > 0 || paddingRight > 0 || paddingTop > 0 || paddingBottom > 0)) {
            int height = this.getHeight();
            int width = this.getWidth();
            canvas.clipRect(new RectF((float)paddingLeft, (float)paddingTop, (float)(width - paddingRight), (float)(height - paddingBottom)));
        }
    }

    private void drawOval(Canvas canvas) {
        this.drawTopLeft(canvas);
        this.drawTopRight(canvas);
        this.drawBottomLeft(canvas);
        this.drawBottomRight(canvas);
    }

    private void drawRectangle(Canvas canvas) {
        float f = this.isRtl ? this.endTopRadius : this.startTopRadius;
        if (ViewUtils.getRtlValue(f, this.leftTopRadius) > 0.0f) {
            this.drawTopLeft(canvas);
        }
        float f2 = this.isRtl ? this.startTopRadius : this.endTopRadius;
        if (ViewUtils.getRtlValue(f2, this.rightTopRadius) > 0.0f) {
            this.drawTopRight(canvas);
        }
        float f3 = this.isRtl ? this.endBottomRadius : this.startBottomRadius;
        if (ViewUtils.getRtlValue(f3, this.leftBottomRadius) > 0.0f) {
            this.drawBottomLeft(canvas);
        }
        float f4 = this.isRtl ? this.startBottomRadius : this.endBottomRadius;
        if (ViewUtils.getRtlValue(f4, this.rightBottomRadius) > 0.0f) {
            this.drawBottomRight(canvas);
        }
    }

    private void drawTopLeft(Canvas canvas) {
        Path path = new Path();
        int paddingLeft = ViewUtils.getViewPaddingLeft((View)this);
        int paddingRight = ViewUtils.getViewPaddingRight((View)this);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        if (this.shapeType == ShapeType.OVAL) {
            int height = this.getHeight();
            int width = this.getWidth();
            path.moveTo((float)paddingLeft, (float)((height - paddingTop - paddingBottom) / 2 + paddingTop));
            path.lineTo((float)paddingLeft, (float)paddingTop);
            path.lineTo((float)((width - paddingLeft - paddingRight) / 2 + paddingLeft), (float)paddingTop);
            path.arcTo(new RectF((float)paddingLeft, (float)paddingTop, (float)(width - paddingRight), (float)(height - paddingBottom)), -90.0f, -90.0f);
        } else {
            float leftTopRadius = ViewUtils.getRtlValue(this.isRtl ? this.endTopRadius : this.startTopRadius, this.leftTopRadius);
            path.moveTo((float)paddingLeft, (float)paddingTop + leftTopRadius);
            path.lineTo((float)paddingLeft, (float)paddingTop);
            path.lineTo((float)paddingLeft + leftTopRadius, (float)paddingTop);
            path.arcTo(new RectF((float)paddingLeft, (float)paddingTop, (float)paddingLeft + leftTopRadius * 2.0f, (float)paddingTop + leftTopRadius * 2.0f), -90.0f, -90.0f);
        }
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    private void drawTopRight(Canvas canvas) {
        int width = this.getWidth();
        Path path = new Path();
        int paddingLeft = ViewUtils.getViewPaddingLeft((View)this);
        int paddingRight = ViewUtils.getViewPaddingRight((View)this);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        if (this.shapeType == ShapeType.OVAL) {
            int height = this.getHeight();
            path.moveTo((float)((width - paddingLeft - paddingRight) / 2 + paddingLeft), (float)paddingTop);
            path.lineTo((float)(width - paddingRight), (float)paddingTop);
            path.lineTo((float)(width - paddingRight), (float)((height - paddingTop - paddingBottom) / 2 + paddingTop));
            path.arcTo(new RectF((float)paddingLeft, (float)paddingTop, (float)(width - paddingRight), (float)(height - paddingBottom)), 0.0f, -90.0f);
        } else {
            float rightTopRadius = ViewUtils.getRtlValue(this.isRtl ? this.startTopRadius : this.endTopRadius, this.rightTopRadius);
            path.moveTo((float)width - rightTopRadius - (float)paddingRight, (float)paddingTop);
            path.lineTo((float)(width - paddingRight), (float)paddingTop);
            path.lineTo((float)(width - paddingRight), (float)paddingTop + rightTopRadius);
            path.arcTo(new RectF((float)(width - paddingRight) - 2.0f * rightTopRadius, (float)paddingTop, (float)(width - paddingRight), (float)paddingTop + rightTopRadius * 2.0f), 0.0f, -90.0f);
        }
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    private void drawBottomLeft(Canvas canvas) {
        int height = this.getHeight();
        Path path = new Path();
        int paddingLeft = ViewUtils.getViewPaddingLeft((View)this);
        int paddingRight = ViewUtils.getViewPaddingRight((View)this);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        if (this.shapeType == ShapeType.OVAL) {
            int width = this.getWidth();
            path.moveTo((float)paddingLeft, (float)((height - paddingTop - paddingBottom) / 2 + paddingTop));
            path.lineTo((float)paddingLeft, (float)(height - paddingBottom));
            path.lineTo((float)((width - paddingLeft - paddingRight) / 2 + paddingLeft), (float)(height - paddingBottom));
            path.arcTo(new RectF((float)paddingLeft, (float)paddingTop, (float)(width - paddingRight), (float)(height - paddingBottom)), 90.0f, 90.0f);
        } else {
            float leftBottomRadius = ViewUtils.getRtlValue(this.isRtl ? this.endBottomRadius : this.startBottomRadius, this.leftBottomRadius);
            path.moveTo((float)paddingLeft, (float)(height - paddingBottom) - leftBottomRadius);
            path.lineTo((float)paddingLeft, (float)(height - paddingBottom));
            path.lineTo((float)paddingLeft + leftBottomRadius, (float)(height - paddingBottom));
            path.arcTo(new RectF((float)paddingLeft, (float)(height - paddingBottom) - 2.0f * leftBottomRadius, (float)paddingLeft + leftBottomRadius * 2.0f, (float)(height - paddingBottom)), 90.0f, 90.0f);
        }
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    private void drawBottomRight(Canvas canvas) {
        int height = this.getHeight();
        int width = this.getWidth();
        Path path = new Path();
        int paddingLeft = ViewUtils.getViewPaddingLeft((View)this);
        int paddingRight = ViewUtils.getViewPaddingRight((View)this);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        if (this.shapeType == ShapeType.OVAL) {
            path.moveTo((float)((width - paddingLeft - paddingRight) / 2 + paddingLeft), (float)(height - paddingBottom));
            path.lineTo((float)(width - paddingRight), (float)(height - paddingBottom));
            path.lineTo((float)(width - paddingRight), (float)((height - paddingTop - paddingBottom) / 2 + paddingTop));
            path.arcTo(new RectF((float)paddingLeft, (float)paddingTop, (float)(width - paddingRight), (float)(height - paddingBottom)), 0.0f, 90.0f);
        } else {
            float rightBottomRadius = ViewUtils.getRtlValue(this.isRtl ? this.startBottomRadius : this.endBottomRadius, this.rightBottomRadius);
            path.moveTo((float)(width - paddingRight) - rightBottomRadius, (float)(height - paddingBottom));
            path.lineTo((float)(width - paddingRight), (float)(height - paddingBottom));
            path.lineTo((float)(width - paddingRight), (float)(height - paddingBottom) - rightBottomRadius);
            path.arcTo(new RectF((float)(width - paddingRight) - 2.0f * rightBottomRadius, (float)(height - paddingBottom) - 2.0f * rightBottomRadius, (float)(width - paddingRight), (float)(height - paddingBottom)), 0.0f, 90.0f);
        }
        path.close();
        canvas.drawPath(path, this.mRoundPaint);
    }

    public int getBgShapeColor() {
        return this.curBgShapeColor;
    }

    public void setBgShapeColor(@ColorInt int bgShapeColor) {
        this.setBgShapeColors(ColorStateList.valueOf((int)bgShapeColor));
    }

    public void setBgShapeColors(ColorStateList bgShapeColor) {
        if (bgShapeColor == null) {
            return;
        }
        this.bgShapeColor = bgShapeColor;
        this.updateColors();
    }

    public float getLeftTopRadius() {
        return this.leftTopRadius;
    }

    public void setLeftTopRadius(float leftTopRadius) {
        this.leftTopRadius = leftTopRadius;
        this.invalidate();
    }

    public float getLeftBottomRadius() {
        return this.leftBottomRadius;
    }

    public void setLeftBottomRadius(float leftBottomRadius) {
        this.leftBottomRadius = leftBottomRadius;
        this.invalidate();
    }

    public float getRightTopRadius() {
        return this.rightTopRadius;
    }

    public void setRightTopRadius(float rightTopRadius) {
        this.rightTopRadius = rightTopRadius;
        this.invalidate();
    }

    public float getRightBottomRadius() {
        return this.rightBottomRadius;
    }

    public void setRightBottomRadius(float rightBottomRadius) {
        this.rightBottomRadius = rightBottomRadius;
        this.invalidate();
    }

    public void setRadius(int radius) {
        this.leftTopRadius = radius;
        this.rightTopRadius = radius;
        this.leftBottomRadius = radius;
        this.rightBottomRadius = radius;
        this.invalidate();
    }

    public void setRadius(int leftTopRadius, int rightTopRadius, int rightBottomRadius, int leftBottomRadius) {
        this.leftTopRadius = leftTopRadius;
        this.rightTopRadius = rightTopRadius;
        this.rightBottomRadius = rightBottomRadius;
        this.leftBottomRadius = leftBottomRadius;
        this.invalidate();
    }

    public void setRelativeRadius(int startTopRadius, int endTopRadius, int endBottomRadius, int startBottomRadius) {
        this.startTopRadius = startTopRadius;
        this.endTopRadius = endTopRadius;
        this.endBottomRadius = endBottomRadius;
        this.startBottomRadius = startBottomRadius;
        this.invalidate();
    }

    public ShapeType getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(ShapeType shapeType) {
        this.shapeType = shapeType;
        this.invalidate();
    }

    public float getBgPaintWidth() {
        return this.mBgPaintWidth;
    }

    public ShapeType getBgShapeType() {
        return this.bgShapeType;
    }

    public void setBgShapeType(ShapeType bgShapeType) {
        this.bgShapeType = bgShapeType;
        this.invalidate();
    }

    public float getGradientAngle() {
        return this.gradientAngle;
    }

    public void setGradientAngle(float gradientAngle) {
        this.gradientAngle = gradientAngle;
        this.invalidate();
    }

    public boolean isGradientRtlAngle() {
        return this.gradientRtlAngle;
    }

    public void setGradientRtlAngle(boolean gradientRtlAngle) {
        this.gradientRtlAngle = gradientRtlAngle;
        this.invalidate();
    }

    public boolean isGradient() {
        return this.isGradient;
    }

    public void setGradient(boolean gradient) {
        this.isGradient = gradient;
        this.invalidate();
    }

    public void setBgRadius(float bgRadius) {
        this.bgLeftTopRadius = bgRadius;
        this.bgLeftBottomRadius = bgRadius;
        this.bgRightTopRadius = bgRadius;
        this.bgRightBottomRadius = bgRadius;
        this.invalidate();
    }

    public void setBgRadius(float bgLeftTopRadius, float bgRightTopRadius, float bgRightBottomRadius, float bgLeftBottomRadius) {
        this.bgLeftTopRadius = bgLeftTopRadius;
        this.bgRightTopRadius = bgRightTopRadius;
        this.bgRightBottomRadius = bgRightBottomRadius;
        this.bgLeftBottomRadius = bgLeftBottomRadius;
        this.invalidate();
    }

    public void setBgRelativeRadius(float bgStartTopRadius, float bgEndTopRadius, float bgEndBottomRadius, float bgStartBottomRadius) {
        this.bgStartTopRadius = bgStartTopRadius;
        this.bgEndTopRadius = bgEndTopRadius;
        this.bgEndBottomRadius = bgEndBottomRadius;
        this.bgStartBottomRadius = bgStartBottomRadius;
        this.invalidate();
    }

    public float getBgLeftTopRadius() {
        return this.bgLeftTopRadius;
    }

    public void setBgLeftTopRadius(float bgLeftTopRadius) {
        this.bgLeftTopRadius = bgLeftTopRadius;
        this.invalidate();
    }

    public float getBgLeftBottomRadius() {
        return this.bgLeftBottomRadius;
    }

    public void setBgLeftBottomRadius(float bgLeftBottomRadius) {
        this.bgLeftBottomRadius = bgLeftBottomRadius;
        this.invalidate();
    }

    public float getBgRightTopRadius() {
        return this.bgRightTopRadius;
    }

    public void setBgRightTopRadius(float bgRightTopRadius) {
        this.bgRightTopRadius = bgRightTopRadius;
        this.invalidate();
    }

    public float getBgRightBottomRadius() {
        return this.bgRightBottomRadius;
    }

    public void setBgRightBottomRadius(float bgRightBottomRadius) {
        this.bgRightBottomRadius = bgRightBottomRadius;
        this.invalidate();
    }

    public float getStartTopRadius() {
        return this.startTopRadius;
    }

    public void setStartTopRadius(float startTopRadius) {
        this.startTopRadius = startTopRadius;
        this.invalidate();
    }

    public float getStartBottomRadius() {
        return this.startBottomRadius;
    }

    public void setStartBottomRadius(float startBottomRadius) {
        this.startBottomRadius = startBottomRadius;
        this.invalidate();
    }

    public float getEndTopRadius() {
        return this.endTopRadius;
    }

    public void setEndTopRadius(float endTopRadius) {
        this.endTopRadius = endTopRadius;
        this.invalidate();
    }

    public float getEndBottomRadius() {
        return this.endBottomRadius;
    }

    public void setEndBottomRadius(float endBottomRadius) {
        this.endBottomRadius = endBottomRadius;
        this.invalidate();
    }

    public float getBgStartTopRadius() {
        return this.bgStartTopRadius;
    }

    public void setBgStartTopRadius(float bgStartTopRadius) {
        this.bgStartTopRadius = bgStartTopRadius;
        this.invalidate();
    }

    public float getBgStartBottomRadius() {
        return this.bgStartBottomRadius;
    }

    public void setBgStartBottomRadius(float bgStartBottomRadius) {
        this.bgStartBottomRadius = bgStartBottomRadius;
        this.invalidate();
    }

    public float getBgEndTopRadius() {
        return this.bgEndTopRadius;
    }

    public void setBgEndTopRadius(float bgEndTopRadius) {
        this.bgEndTopRadius = bgEndTopRadius;
        this.invalidate();
    }

    public float getBgEndBottomRadius() {
        return this.bgEndBottomRadius;
    }

    public void setBgEndBottomRadius(float bgEndBottomRadius) {
        this.bgEndBottomRadius = bgEndBottomRadius;
        this.invalidate();
    }

    private boolean is4BgRadiusEquals() {
        float bgLeftTopRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgEndTopRadius : this.bgStartTopRadius, this.bgLeftTopRadius);
        float bgLeftBottomRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgEndBottomRadius : this.bgStartBottomRadius, this.bgLeftBottomRadius);
        float bgRightTopRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgStartTopRadius : this.bgEndTopRadius, this.bgRightTopRadius);
        float bgRightBottomRadius = ViewUtils.getRtlValue(this.isRtl ? this.bgStartBottomRadius : this.bgEndBottomRadius, this.bgRightBottomRadius);
        return bgRightTopRadius == bgLeftTopRadius && bgLeftBottomRadius == bgLeftTopRadius && bgRightBottomRadius == bgLeftTopRadius;
    }

    public float[] getGradientPositions() {
        return this.gradientPositions;
    }

    public void setGradientPositions(@Nullable float[] gradientPositions) {
        this.gradientPositions = gradientPositions;
        this.invalidate();
    }

    public int[] getGradientColors() {
        return this.gradientColors;
    }

    public List<ColorStateList> getGradientColorStates() {
        return this.gradientColorStates;
    }

    public void setGradientColors(@Size(min=2L) @NonNull @ColorInt int[] gradientColors) {
        ColorStateList[] colorStateLists = new ColorStateList[gradientColors.length];
        for (int i = 0; i < gradientColors.length; ++i) {
            colorStateLists[i] = ColorStateList.valueOf((int)gradientColors[i]);
        }
        this.setGradientColors(colorStateLists);
    }

    public void setGradientColors(@NonNull ColorStateList[] colorStateLists) {
        this.gradientColorStates.clear();
        this.gradientColorStates.addAll(Arrays.asList(colorStateLists));
        if (this.gradientColorStates.size() == 1) {
            this.gradientColorStates.add(ColorStateList.valueOf((int)0));
        }
        if (this.gradientPositions != null && this.gradientColorStates.size() != this.gradientPositions.length) {
            this.gradientPositions = null;
        }
        this.updateColors();
    }

    public static enum ShapeType {
        NONE(0),
        RECTANGLE(1),
        OVAL(2);

        final int type;

        private ShapeType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static ShapeType getType(int type) {
            if (type == 1) {
                return RECTANGLE;
            }
            if (type == 2) {
                return OVAL;
            }
            return NONE;
        }
    }

    public static enum ShapeScaleType implements Serializable
    {
        FIT_XY(1),
        FIT_START(2),
        FIT_CENTER(3),
        FIT_END(4),
        CENTER(5),
        CENTER_CROP(6),
        CENTER_INSIDE(7),
        START_CROP(8),
        END_CROP(9),
        AUTO_START_CENTER_CROP(10),
        AUTO_END_CENTER_CROP(11);

        final int type;

        private ShapeScaleType(int ni) {
            this.type = ni;
        }

        public static ShapeScaleType getType(int ni) {
            if (ni == 1) {
                return FIT_XY;
            }
            if (ni == 2) {
                return FIT_START;
            }
            if (ni == 3) {
                return FIT_CENTER;
            }
            if (ni == 4) {
                return FIT_END;
            }
            if (ni == 5) {
                return CENTER;
            }
            if (ni == 6) {
                return CENTER_CROP;
            }
            if (ni == 7) {
                return CENTER_INSIDE;
            }
            if (ni == 8) {
                return START_CROP;
            }
            if (ni == 9) {
                return END_CROP;
            }
            if (ni == 10) {
                return AUTO_START_CENTER_CROP;
            }
            if (ni == 11) {
                return AUTO_END_CENTER_CROP;
            }
            return null;
        }

        public static ShapeScaleType getType(ImageView.ScaleType scaleType) {
            if (scaleType == ImageView.ScaleType.FIT_XY) {
                return FIT_XY;
            }
            if (scaleType == ImageView.ScaleType.FIT_START) {
                return FIT_START;
            }
            if (scaleType == ImageView.ScaleType.FIT_CENTER) {
                return FIT_CENTER;
            }
            if (scaleType == ImageView.ScaleType.FIT_END) {
                return FIT_END;
            }
            if (scaleType == ImageView.ScaleType.CENTER) {
                return CENTER;
            }
            if (scaleType == ImageView.ScaleType.CENTER_CROP) {
                return CENTER_CROP;
            }
            if (scaleType == ImageView.ScaleType.CENTER_INSIDE) {
                return CENTER_INSIDE;
            }
            return null;
        }

        public static ImageView.ScaleType getScaleType(ShapeScaleType scaleType) {
            if (scaleType == FIT_XY) {
                return ImageView.ScaleType.FIT_XY;
            }
            if (scaleType == FIT_START) {
                return ImageView.ScaleType.FIT_START;
            }
            if (scaleType == FIT_CENTER) {
                return ImageView.ScaleType.FIT_CENTER;
            }
            if (scaleType == FIT_END) {
                return ImageView.ScaleType.FIT_END;
            }
            if (scaleType == CENTER) {
                return ImageView.ScaleType.CENTER;
            }
            if (scaleType == CENTER_CROP) {
                return ImageView.ScaleType.CENTER_CROP;
            }
            if (scaleType == CENTER_INSIDE) {
                return ImageView.ScaleType.CENTER_INSIDE;
            }
            return null;
        }

        public int getType() {
            return this.type;
        }
    }
}

