/*
 * Decompiled with CFR 0.152.
 */
package com.flyjingfish.shapeimageviewlib;

import android.os.Build;
import android.view.View;
import androidx.core.text.TextUtilsCompat;
import java.util.Locale;

class ViewUtils {
    ViewUtils() {
    }

    public static int getViewPaddingLeft(View view) {
        boolean isRtl = false;
        if (Build.VERSION.SDK_INT >= 19) {
            isRtl = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
        }
        int paddingStart = view.getPaddingStart();
        int paddingEnd = view.getPaddingEnd();
        int paddingLeft = view.getPaddingLeft();
        int paddingLeftMax = isRtl ? (paddingEnd != 0 ? paddingEnd : paddingLeft) : (paddingStart != 0 ? paddingStart : paddingLeft);
        return paddingLeftMax;
    }

    public static int getViewPaddingRight(View view) {
        boolean isRtl = false;
        if (Build.VERSION.SDK_INT >= 19) {
            isRtl = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
        }
        int paddingStart = view.getPaddingStart();
        int paddingEnd = view.getPaddingEnd();
        int paddingRight = view.getPaddingRight();
        int paddingRightMax = isRtl ? (paddingStart != 0 ? paddingStart : paddingRight) : (paddingEnd != 0 ? paddingEnd : paddingRight);
        return paddingRightMax;
    }

    public static float getRtlValue(float startEndValue, float leftRightValue) {
        float value = startEndValue != 0.0f ? startEndValue : leftRightValue;
        return value;
    }
}

