/*
 * Decompiled with CFR 0.152.
 */
package com.flyjingfish.shapeimageviewlib;

import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.flyjingfish.shapeimageviewlib.ShapeImageView;
import com.flyjingfish.shapeimageviewlib.ViewUtils;

class ShapeImageViewAttacher
implements View.OnLayoutChangeListener {
    private final ShapeImageView mImageView;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private ShapeImageView.ShapeScaleType mScaleType;
    private float mAutoCropHeightWidthRatio;

    public ShapeImageViewAttacher(ShapeImageView imageView) {
        this.mImageView = imageView;
        imageView.addOnLayoutChangeListener(this);
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            this.update();
        }
    }

    public void update() {
        Drawable drawable = this.mImageView.getDrawable();
        this.updateBaseMatrix(drawable);
    }

    private void updateBaseMatrix(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        float viewWidth = this.getImageViewWidth((ImageView)this.mImageView);
        float viewHeight = this.getImageViewHeight((ImageView)this.mImageView);
        int drawableWidth = drawable.getIntrinsicWidth();
        int drawableHeight = drawable.getIntrinsicHeight();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        if (this.mScaleType == ShapeImageView.ShapeScaleType.START_CROP) {
            this.mBaseMatrix.reset();
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate(0.0f, 0.0f);
            this.resetMatrix();
        } else if (this.mScaleType == ShapeImageView.ShapeScaleType.END_CROP) {
            this.mBaseMatrix.reset();
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate(viewWidth - (float)drawableWidth * scale, viewHeight - (float)drawableHeight * scale);
            this.resetMatrix();
        } else if (this.mScaleType == ShapeImageView.ShapeScaleType.AUTO_START_CENTER_CROP) {
            float imageHeightWidthRatio = (float)drawableHeight * 1.0f / (float)drawableWidth;
            float viewHeightWidthRatio = viewHeight / viewWidth;
            float ratio = imageHeightWidthRatio / viewHeightWidthRatio;
            this.mBaseMatrix.reset();
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            if (ratio >= this.mAutoCropHeightWidthRatio) {
                this.mBaseMatrix.postTranslate(0.0f, 0.0f);
            } else {
                this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
            }
            this.resetMatrix();
        } else if (this.mScaleType == ShapeImageView.ShapeScaleType.AUTO_END_CENTER_CROP) {
            float imageHeightWidthRatio = (float)drawableHeight * 1.0f / (float)drawableWidth;
            float viewHeightWidthRatio = viewHeight / viewWidth;
            float ratio = imageHeightWidthRatio / viewHeightWidthRatio;
            this.mBaseMatrix.reset();
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            if (ratio >= this.mAutoCropHeightWidthRatio) {
                this.mBaseMatrix.postTranslate(viewWidth - (float)drawableWidth * scale, viewHeight - (float)drawableHeight * scale);
            } else {
                this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
            }
            this.resetMatrix();
        } else {
            ImageView.ScaleType scaleType = ShapeImageView.ShapeScaleType.getScaleType(this.mScaleType);
            if (scaleType != null) {
                this.mImageView.setScaleType(scaleType);
            }
        }
    }

    private void resetMatrix() {
        this.setImageViewMatrix(this.getDrawMatrix());
    }

    private Matrix getDrawMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        return this.mDrawMatrix;
    }

    private void setImageViewMatrix(Matrix matrix) {
        this.mImageView.setImageMatrix(matrix);
    }

    public void setScaleType(ShapeImageView.ShapeScaleType scaleType) {
        if (scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    public ShapeImageView.ShapeScaleType getShapeScaleType() {
        return this.mScaleType;
    }

    private int getImageViewWidth(ImageView imageView) {
        return imageView.getWidth() - ViewUtils.getViewPaddingLeft((View)imageView) - ViewUtils.getViewPaddingRight((View)imageView);
    }

    private int getImageViewHeight(ImageView imageView) {
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    public Matrix getImageMatrix() {
        return this.mDrawMatrix;
    }

    public void setAutoCropHeightWidthRatio(float autoCropHeightWidthRatio) {
        this.mAutoCropHeightWidthRatio = autoCropHeightWidthRatio;
    }
}

