/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedLong;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;

public class ByteUtils {
    public static byte[] toByteArray(int value, int byteSize) {
        BigInteger bigInteger = ByteUtils.checkSize(byteSize * 8, BigInteger.valueOf(value));
        return ByteUtils.toLeftPaddedByteArray(byteSize, bigInteger);
    }

    public static byte[] toByteArray(BigInteger value, int byteSize) {
        BigInteger bigInteger = ByteUtils.checkSize(byteSize * 8, value);
        return ByteUtils.toLeftPaddedByteArray(byteSize, bigInteger);
    }

    private static byte[] toLeftPaddedByteArray(int byteSize, BigInteger bigInteger) {
        byte[] target = new byte[byteSize];
        byte[] source = bigInteger.toByteArray();
        for (int i = 0; i < source.length && i < target.length; ++i) {
            target[byteSize - i - 1] = source[source.length - i - 1];
        }
        return target;
    }

    public static List<UnsignedByte> parse(String hex) {
        String padded = ByteUtils.padded(hex);
        ArrayList<UnsignedByte> result = new ArrayList<UnsignedByte>();
        for (int i = 0; i < padded.length(); i += 2) {
            result.add(UnsignedByte.of(padded.substring(i, i + 2)));
        }
        return result;
    }

    public static BigInteger checkSize(int expectedBits, BigInteger value) {
        Preconditions.checkArgument((value.bitLength() <= expectedBits ? 1 : 0) != 0, (Object)("value has " + value.bitLength() + " bits but should be <= " + expectedBits));
        return value;
    }

    public static String toHex(List<UnsignedByte> segments) {
        return Joiner.on((String)"").join((Iterable)segments.stream().map(UnsignedByte::hexValue).collect(Collectors.toList()));
    }

    public static UnsignedLong toUnsignedLong(UnsignedByteArray segments) {
        return UnsignedLong.valueOf((String)segments.hexValue(), (int)16);
    }

    public static String padded(String hex) {
        return hex.length() % 2 == 0 ? hex : "0" + hex;
    }

    public static String padded(String hex, int hexLength) {
        return Strings.repeat((String)"0", (int)(hexLength - hex.length())) + hex;
    }
}

