/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.Decoded;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.addresses.Version;
import org.xrpl.xrpl4j.codec.addresses.VersionType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Decoded", generator="Immutables")
@Immutable
public final class ImmutableDecoded
implements Decoded {
    private final Version version;
    private final UnsignedByteArray bytes;
    @Nullable
    private final VersionType type;

    private ImmutableDecoded(Version version, UnsignedByteArray bytes, @Nullable VersionType type) {
        this.version = version;
        this.bytes = bytes;
        this.type = type;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public UnsignedByteArray bytes() {
        return this.bytes;
    }

    @Override
    public Optional<VersionType> type() {
        return Optional.ofNullable(this.type);
    }

    public final ImmutableDecoded withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDecoded(newValue, this.bytes, this.type);
    }

    public final ImmutableDecoded withBytes(UnsignedByteArray value) {
        if (this.bytes == value) {
            return this;
        }
        UnsignedByteArray newValue = Objects.requireNonNull(value, "bytes");
        return new ImmutableDecoded(this.version, newValue, this.type);
    }

    public final ImmutableDecoded withType(VersionType value) {
        VersionType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableDecoded(this.version, this.bytes, newValue);
    }

    public final ImmutableDecoded withType(Optional<? extends VersionType> optional) {
        VersionType value = optional.orElse(null);
        if (Objects.equals((Object)this.type, (Object)value)) {
            return this;
        }
        return new ImmutableDecoded(this.version, this.bytes, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDecoded && this.equalTo((ImmutableDecoded)another);
    }

    private boolean equalTo(ImmutableDecoded another) {
        return this.version.equals((Object)another.version) && this.bytes.equals(another.bytes) && Objects.equals((Object)this.type, (Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.bytes.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.type);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Decoded").omitNullValues().add("version", (Object)this.version).add("bytes", (Object)this.bytes).add("type", (Object)this.type).toString();
    }

    public static ImmutableDecoded copyOf(Decoded instance) {
        if (instance instanceof ImmutableDecoded) {
            return (ImmutableDecoded)instance;
        }
        return ImmutableDecoded.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Decoded", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_BYTES = 2L;
        private long initBits = 3L;
        @Nullable
        private Version version;
        @Nullable
        private UnsignedByteArray bytes;
        @Nullable
        private VersionType type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Decoded instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.version());
            this.bytes(instance.bytes());
            Optional<VersionType> typeOptional = instance.type();
            if (typeOptional.isPresent()) {
                this.type(typeOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bytes(UnsignedByteArray bytes) {
            this.bytes = Objects.requireNonNull(bytes, "bytes");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(VersionType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Optional<? extends VersionType> type) {
            this.type = type.orElse(null);
            return this;
        }

        public ImmutableDecoded build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDecoded(this.version, this.bytes, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bytes");
            }
            return "Cannot build Decoded, some of required attributes are not set " + attributes;
        }
    }
}

